<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (News Management)
 * @Module      News 
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_News extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('news_title')->from('news')->where('id = '.$id)->execute()->current();
        return empty($check->news_title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'news "'.$check->news_title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_news($execution = TRUE){
        $news = Setup::join_histories('news');                     
        return $execution === true ? $news->execution() : $news;
    }
    
    /**
     * @param
     */
    public function recent_news($limit = 1) {
        $result = DB::select()
                ->from('news')
                ->where('status', '=', 'active')
                ->order_by('news_date', 'desc')
                ->limit($limit)
                ->as_object()
                ->execute();
        
        return ($result->valid()) ? $result : null ;
    }    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('news');
        
        if (!empty($get_params[0])) {
            if ($get_params[0] == 'field') {
                $field_name = "news.$get_params[1]";
                
                if (!empty($get_params[2]))
                    $querying->where("$field_name = $get_params[2]");
            } else {
                $querying->where("news.id = $get_params[0]");
            }
        }
        
        return $querying->execute();
    }
    
    /*
     * 
     */
    public function get_all_published_news(){
        $result = DB::select()
                ->from('news')
                ->where('status', '=', 'active')
                ->order_by('news_date', 'desc')
                ->as_object()
                ->execute();
        
        return ($result->valid()) ? $result : null ;
    }
    
    /*
     * 
     */
    public function get_parent_menu_title($param=null){
        
        $menu_title = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $menu_title = $query->current()->menu_title;
            } else {
                $query2 = DB::select('menu_title')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $menu_title = ($query2->valid()) ? $query2->current()->menu_title : null;
            }            
        }        
        return $menu_title;        
    }
    
    
    /*
     * 
     */
    public function get_image_path($news_id=null){
        $image_path = null;
        
        $query = DB::select('image_path')
                ->from('news')
                ->where('id', '=', $news_id)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $image_path = $query->current()->image_path;        
        }   
        
        return $image_path;
    }
    
}