<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (Page)
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Page extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('page_title')->from('pages')->where('id = '.$id)->execute()->current();
        return empty($check->page_title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'page "'.$check->page_title.'"'
                ));
    }
    
    public function get_page($execution = true) {
        $get_page = $this->select('pg.*',array('sm.id','menu_id'),'sm.is_system','sm.parent_id','sm.menu_title','sm.permalink','sm.ordering','sm.status')
                        ->from(array('pages','pg'))
                        ->join(array('site_menus','sm'))
                        ->on("pg.site_menu_id = sm.id");
        return $execution === true ? $get_page->execute() : $get_page;
    }
    
    /*
     * 
     */
    public function get_current_page($param){
        
        $result = $this->get_page(false)
                ->where('sm.permalink', '=', $param)
                ->as_object()
                ->execute();        
        
        return ($result->valid())?$result:null;
    }
    
    /*
     * 
     */
    public function get_top_page($parent_id){

        $result = $this->get_page(false)
                ->limit(1)
                ->order_by('sm.id', 'asc')
                ->where('sm.parent_id', '=', $parent_id)
                ->as_object()
                ->execute();   
        
        return ($result->valid())?$result:null;
    }
    
    /*
     * 
     */
    public function get_parent_permalink($param){
        
        $permalink = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $permalink = $query->current()->permalink;
            } else {
                $query2 = DB::select('permalink')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $permalink = ($query2->valid()) ? $query2->current()->permalink : null;
            }            
        }        
        return $permalink;        
    }
    
     /*
     * 
     */
    public function get_parent_menu_title($param){
        
        $menu_title = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $menu_title = $query->current()->menu_title;
            } else {
                $query2 = DB::select('menu_title')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $menu_title = ($query2->valid()) ? $query2->current()->menu_title : null;
            }            
        }        
        return $menu_title;        
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_page($execution = TRUE){
        $page = Setup::join_histories('pages',array(array('sm.id','menu_id'),'sm.is_system','sm.parent_id','sm.menu_title','sm.permalink','sm.ordering','sm.status'))
                    ->join(array('site_menus','sm'))
                    ->on('sm.id = pages.site_menu_id')
                    ->where('sm.is_system = 0')
                    ->and_where('sm.parent_id = 0');
                     
        return $execution === true ? $page->execution() : $page;
    }
    
    public function page_total($execution = true) {
        $page_total = $this->total_record('pages',false)
                        ->join(array('site_menus','m'))
                        ->on('pages.site_menu_id = m.id')
                        ->where('m.is_system = 0');
        
        return $execution === true ? $page_total->execute()->current()->total : $page_total;
    }
    
    public function traverse_limit_page($value = 0,$offset = 0, $limit = 10,$level=0) {        
        $object = Setup::join_histories('pages',array('sm.ordering','sm.status','sm.parent_id'))
                    ->join(array('site_menus','sm'))
                    ->on('sm.id = pages.site_menu_id')
                    ->where('sm.is_system = 0')
                    ->and_where('sm.parent_id = '.$value)
                    ->order_by('ordering');
        if ($value == 0) 
            $object->offset($offset)->limit($limit);
        
        $arr_data = $object->execute();
        
        if (!empty($arr_data[0]->id)) {
            $index_data = 0;
                        
            foreach ($arr_data as $item) {                
                $result[$index_data]['data']  = $item;
                $result[$index_data]['level'] = $level;
                $result[$index_data]['child'] = $this->traverse_limit_page($item->site_menu_id,$offset,$limit,$level+1);
                $index_data++; 
            }
        }else{
            return null;
        }
        
        return $result;
    }
}
?>