<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    News Category List
 * @Module      News
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/
?>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'news/manage/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'news/manage/form/create'); ?></div>  
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('title');?></th>
            <th class="date"><?php echo __('date');?></th>
            <th class="status"><?php echo __('status');?></th>
            <th class="create_time"><?php echo __('create_time');?></th>
            <th class="last_update"><?php echo __('last_update');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {
                    $modify_class = __make_class($index,$item->status);
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search($item->news_title).'</td>';
                        echo '<td class="center">'.$item->news_date.'</td>';
                        echo '<td class="center">'.$site->tool->mixed_search($item->status).'</td>';
                        echo '<td class="center">'.$item->time_created.'</td>';
                        echo '<td class="center">'.$item->last_updated.'</td>';
                        echo '<td class="center">';
                            $list_action  = $item->status == 'active' ? 'deactivate' : 'activate';
                            $update_value = $item->status == 'active' ? 'inactive' : 'active';
                              
                            echo Form::list_action($site,$list_action,array(   
                                    "class"  => "ajax",
                                    "href"   => $site->bs_cms.'system/ajax/update-status/news/'.$update_value.'/'.$item->id,
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('news').' '.$item->news_title)).'"
                                                    }]
                                        }',
                                ));
                            
                            echo '&nbsp; &nbsp;';
                            echo Form::list_action($site,'edit',array(
                                    'title' => __('edit_user'),
                                    'href'  => $site->bs_cms.'news/manage/form/edit/'.$item->id
                                ));
                            
                            
                            if ( $site->user->profile->role_id <= 1 
                                    || !empty($site->user->profile->permission->news->delete)) {
                                echo '&nbsp; &nbsp;';
                                echo Form::list_action($site,'delete',array(  
                                        'class'  => 'no-ajax', 
                                        'title'  => __('delete_news'),
                                        "href"   => $site->bs_cms.'news/manage/delete-news/'.$item->id,
                                        "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "module" : "news",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('news').' '.$item->news_title)).'"
                                                    }]
                                        }',
                                    ));
                            }
                            
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="8">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="8">
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    