<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Page Listing Template
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

if (empty($columns) || !is_array($columns)) {
    echo 'No Columns' ; return;
}
?>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'page/manage/form/create'); ?></div>
    <div class="clear"></div>
</div>

<table class="webarq_percent_table sortable" id="traversing-page-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <?php   
                foreach ($columns as  $key => $column) {
                    $column = $column == 'create_time' ? __('create',array('%item'=>'Time')) : $column;
                    echo '<th class="'.strtolower(helper_tool::pretty_name($column,'_')).'">'
                            .__($column).'</th>';
                }
                
            ?>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php 
            $length_of_column = count($columns)+3;
            echo !empty($tbody) 
                ? $tbody
                : '<tr><td colspan="'.$length_of_column.'">'.__('no_data').'</td></tr>';
        ?>     
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="<?php echo count($columns)+3;?>"> 
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php echo !empty($paging) ? $paging : "-"; ?>
</div>

<script>
    $('document').ready(function(){ 
        $('#traversing-page-listing').treeTable({
            //clickableNodeNames: true,
            treeColumn : 2,
            indent : 0      
        });
    });    
</script>