<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Widget Site Menu Controller
 * @Module      Global Config
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Widget_Base_Site_Menu_Controller extends Setup {
    
    public function data() {
        $menus = Model::factory('menu')
                        ->class_var('position_id',1)
                        ->class_var('status_menu','active')
                        ->traverse_limit_menu();        
        $menu_active = empty(Config::$site_config->menu->active) 
                     ? 'home'
                     : Config::$site_config->menu->active;
                     
        return $this->traversing_ul($menus,$menu_active);
    }
    
    private function traversing_ul(array $sources = null, $active = 'home', $level = 0) {
        $result = '';
        if (!empty($sources)) {
            $result .= '<ul ';
            
            /** Class Ul **/
            $result .= 'class="';
            $result .= $level == '0' ? 'site-menu parent' : 'child level-'.$level;
            $result .= '"';
            /** End Class **/
            
            $result .= '>';
            
            foreach ($sources as $key => $value) {
                /** Pre-Data **/
                $item = Translate::table('site_menus')->item($value['data'])->compile();
                
                $href = $item->is_system
                        ? Config::$site_config->bs_site.$item->permalink
                        : Config::$site_config->bs_site.'pages/'.$item->permalink;
                //$href = Config::lang_uri($href); // currently not need multilang
                
                /** Li Section **/
                $result .= '<li ';
                $result .= '>';
               
                /** A Section **/
                $result .= '<a ';
                $result .= 'class="';
                $result .= $active == $item->permalink ? 'active' : '';
                $result .= '"  href="'.$href.'" ';                
                $result .= '>';
                $result .= $item->menu_title;
                $result .= '</a>';
                
                /** Child **/
                /*
                if (!empty($value['child'])) {
                    $next_lvl = $level+1;
                    $result .= $this->traversing_ul($value['child'],$active,$next_lvl);    
                }
                 */   
                $result .= '</li>';    
            }
            
            $result .= '</ul>';
        } 
        return $result;           
    }
}
?>