<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Page_Manage extends Controller_Space_Cms {
    protected $site;
    protected $model_page;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'page_list';
        $this->authorized(array(
                'page' => 'create,edit,delete,view',
            )); // Check permission
           
       $this->model_page = Model::factory('page');  
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }
    
    public function action_index() {
        $this->action_list();
    }
        
    public function action_list() {
        $this->styles(array(
                $this->site->themes_js.'plugin/nested_table/jquery.treeTable.css' => 'screen,projection',
            ));
        $this->scripts(array(
                $this->site->themes_js.'plugin/nested_table/jquery.treeTable.js',
                $this->site->system_js.'library/ui/jquery.ui.draggable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.droppable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.sortable.min.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
            
        if ($this->authorisation === true) {  
            $paging = Pagination::factory(array(
                    'total_items'    => Model::factory('page')->page_total(false)
                                            ->where('m.parent_id = 0')->execute()->current()->total,
                    'items_per_page' => 15,
                    'view'           => 'pagination/webarq'
                ));
            
            $content = Traversal::traversing_table(array(
                    'columns'    => array(
                            'page_title'   => 'title',
                            'ordering'     => 'order',
                            'status'       => 'status',
                            'time_created' => 'create_time',
                            'last_updated' => 'last_update'
                        ),
                    'listing_template' => 'html/cms/page/traversing-listing-page',    
                    'array_data'       => $this->model_page->traverse_limit_page(0,$paging->offset,$paging->items_per_page),
                    'paging'           => $paging,           
                ));    
                
            $this->meta('title',__('manage_page'))
                     ->set('title',__('page_list'))
                     ->set('content',$content)
                     ->render();
        }
    }
    
    public function action_form() {
        // Extend permission
        $this->authorized(array('page' => $this->param1));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('page',array('%s'=>''))));
                
                // Get data
                $data  = $this->param1 == 'create' 
                    ? null 
                    : $this->model_page
                           ->get_page(false)
                           ->where('pg.id = '.$this->param2)
                           ->execute()->current();
                
                // Form Action
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->menu_id) ? '/'.$data->menu_id.'?return_id='.$this->param2 : '';
                
                // Rendering
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$this->html('page-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action)
                          )
                     ->render();
            }    
        }
    }
    
    public function action_save() {        
        $this->authorized(array(
            'page' => 'create'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => array('base','page'),
                       'form'           => 'page',
                       'owner'          => $this->site->user->profile->id,   
                       'order_option'   => array (
                                'table'          => 'site_menus',
                                'field'          => 'ordering',
                                'input_name'     => 'ordering',
                                'previous_input' => 'previous_ordering',
                                'parent'   => array(
                                        'field_name'     => 'parent_id',
                                        'input_name'     => 'parent',
                                        'previous_input' => 'previous_parent'
                                    )
                            ),
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                
                if (!empty($transaction->result_id) 
                    && isset($this->post['parent'])
                    && $this->post['parent'] == 0) {
                    Model::factory('base')->insert('site_menu_position_applications')
                            ->set('site_menu_id',$transaction->result_id['site_menus'])
                            ->set('site_menu_position_id',1)
                            ->execute();
                }                            
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>'page')));
                    $this->request->redirect('admin-cp/page/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/page/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'page' => 'edit'
        ));
        
        $get_id = $this->request->query('return_id');
        $get_id = empty($get_id) ? $this->param1 : $get_id;
         
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package' => array('base','page'),
                       'form'    => 'page',
                       'owner'   => $this->site->user->profile->id,
                       'record_history' => false,   
                       'order_option'   => array (
                                'table'          => 'site_menus',
                                'field'          => 'ordering',
                                'input_name'     => 'ordering',
                                'previous_input' => 'previous_ordering',
                                'parent'   => array(
                                        'field_name'     => 'parent_id',
                                        'input_name'     => 'parent',
                                        'previous_input' => 'previous_parent'
                                    )
                            ),
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    if (isset($this->post['parent'])
                        && $this->post['parent'] == 0) {
                        $arrays = Transaction::arrays(array(
                            'table'      => 'site_menu_position_applications',
                            'item_field' => array('site_menu_id','site_menu_position_id'),
                            'item_value' => array($this->post['site_menu_id'],array(1))
                        )); 
                    } else {
                        Model::factory('base')->delete('site_menu_position_applications')
                            ->where('site_menu_id = '.$this->post['site_menu_id'])
                            ->execute();
                    }
                                
                    Model::factory('history')->insert_history(array(
                        'table' => 'pages',
                        'owner' => $this->site->user->profile->id,
                        'source_id' => $get_id,
                        'type'  => 'update'
                    ));      
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }        
        
        
        $this->request->redirect('admin-cp/page/manage/form/edit/'.$get_id);
    }
    
    public function action_search() {
        
    }
}
   

?>