<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Event Read Controller
 * @Module      Event
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Site_Event_Home extends Controller_Space_Site {
    protected $site;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('event');       
       $this->site->menu->active = 'news-event';
       
       $this->permalink = $this->request->param('permalink');
       
       $this->banner = Widget::$instance->load('page-banner')
                    ->set('table','site_menus')
                    ->set('source_id',$this->site->menu->id)
                    ->set('position', 'Page Banner');
        
        $this->site->menu->title = Model::factory('event')->get_parent_menu_title('news-event');
       
       $this->left_content = View::factory('general/left-content')
                ->set('news_event_left', true)
                ->set('category_active', 'event')
                ->set('email_widget', true);
    }
            
    public function action_index(){
        
        $get_all_published_events = Model::factory('event')->get_all_published_events();
        $right_content = View::factory('html/site/event/right-content')
                ->set('events', $get_all_published_events)
                ->set('section', 'listing');
       
        $this->set('title', 'Event | ' . $this->site->meta->title)
             ->meta('title', 'Event | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    public function action_read() {                                  
        $event = Model::factory('event')->get_by('field','permalink',$this->permalink);
        $right_content = View::factory('html/site/event/right-content')
                ->set('event', $event)
                ->set('section', 'read');
       
        $this->set('title', 'Event | '. $this->site->meta->title)
             ->meta('title', substr(strip_tags($event->current()->description), 0, 160))
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    public function after() {        
        $this->render();
        parent::after();
    }

} // End Welcome
