<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Installer
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
 

return array (
    'configuration' => '
        {
            "configs" : {
                    "id" : {
                            "type" : "varchar",
                            "primary" : true,
                            "length" : "50"
                        },
                    "description" : {
                            "type" : "tinytext"
                        },
                    "value" : {
                            "type" : "varchar",
                            "length" : 500
                        }
                        
                },
            "histories" : {
                    "id" : {
                            "type" : "bigint",
                            "primary" : true,
                            "increment" : true
                        },
                    "source_id" : {
                            "type" : "char",
                            "length" : 15
                        },
                    "owner" : {
                            "type" : "int"
                        },
                    "table" : {
                            "type" : "varchar",
                            "length" : 50
                        },
                    "type" : {
                            "type" : "char",
                            "length" : 20
                        },
                    "time" : {
                            "type" : "datetime"
                        }
                },
            "history_descriptions" : {
                    "id" : {
                            "type" : "bigint",
                            "primary" : true,
                            "increment" : true
                        },
                    "history_id" : {
                            "type" : "char",
                            "length" : 15
                        },
                    "description" : {
                            "type" : "text"
                        }
                },
            "languages" : 
                {
                    "id" : {
                            "type" : "char",
                            "primary" : true,
                            "length" : 5,
                            "notnull" : true
                        },
                    "label" : {
                            "type" : "varchar",
                            "length" : 50
                        },
                    "is_system" : {
                            "type" : "boolean",
                            "default" : 0
                        },
                    "status" : {
                            "type" : "enum",
                            "option" : "active,inactive",
                            "default" : "active"
                        },
                    "ordering" : {
                            "type" : "int"
                        }
                },
            "translations" : 
                {
                    "id" : {
                            "type" : "bigint",
                            "primary" : true,
                            "increment" : true
                        },
                    "source_id" : {
                            "type" : "char",
                            "primary" : true,
                            "length" : 15
                        },
                    "lang_id" : {
                            "type" : "char",
                            "length" : 5,
                            "primary" : true
                        },
                    "table" : {
                            "type" : "varchar",
                            "length" : 35,
                            "primary" : true
                        },
                    "field" : {
                            "type" : "varchar",
                            "length" : 35,
                            "primary" : true
                        },
                    "value" : {
                            "type" : "longtext"
                        }
                },
            "meta" : {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "site_menu_id" : {
                            "type" : "varchar",
                            "length" : 50                        
                        },
                    "name" : {
                            "type" : "varchar",
                            "length" : 100
                        },
                    "description" : {
                            "type" : "varchar",
                            "length" : 500
                        }
                },
            "modules" : 
                {                   
                    "id" : {
                            "type" : "char",
                            "length" : 15,
                            "primary" : true
                        },
                    "label" : {
                            "type" : "char",
                            "length" : 25,
                            "primary" : true,
                            "notnull" : true,
                            "default" : ""
                        },
                    "ordering" : {
                            "type" : "int"
                        },
                    "is_system" : {
                            "type" : "boolean",
                            "default" : 0
                        },
                    "status" : {
                            "type" : "enum",
                            "option" : "active,inactive",
                            "default" : "active"
                        },
                    "description" : {
                            "type" : "text"
                        }
                },
            "module_menus" : 
                {
                    "id" : {
                            "type" : "varchar",
                            "primary" : true,
                            "length" : "50"
                        },
                    "module_id" : {
                            "type" : "char",
                            "length" : 15,
                            "primary" : true
                        },
                    "parent_id" : {
                            "type" : "int",
                            "default" : 0
                        },
                    "label" : {
                            "type" : "char",
                            "length" : 25,
                            "notnull" : true,
                            "default" : ""
                        },
                    "permalink" : {
                            "type" : "varchar",
                            "length" : 1024
                        },
                    "status" : {
                            "type" : "enum",
                            "option" : "active,inactive",
                            "default" : "active"
                        },
                    "ordering" : {
                            "type" : "int"
                        }
                },
            "module_menu_permissions" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "increment" : true
                        },
                    "module_menu_id" : {
                            "type" : "varchar",
                            "length" : "50"
                        },
                    "permission_id" : {
                            "type" : "int"
                        }
                },
            "module_menu_positions" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "increment" : true
                        },
                    "module_menu_id" : {
                            "type" : "varchar",
                            "length" : "50",
                            "primary" : true
                        },
                    "position" : {
                            "type" : "enum",
                            "option" : "top,right,bottom,left,main",
                            "default" : "left",
                            "primary" : true
                        }
                },
            "site_menus" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "is_system" : {
                            "type" : "boolean",
                            "default" : 0
                        },
                    "parent_id" : {
                            "type" : "int",
                            "default" : 0,
                            "form" : {
                                    "page" : {
                                            "name" : "parent",
                                            "label" : "parent_menu",
                                            "class" : "parent_page required",
                                            "open_decoration" : "menu_selector",
                                            "function" : "page::select_parent_page"
                                        },
                                    "menu" : {
                                            "name" : "parent",
                                            "label" : "parent_menu",
                                            "class" : "parent_page required",
                                            "order" : 2,
                                            "function" : "general::select_parent_menu"
                                        }
                                }
                        },
                    "menu_title" : {
                            "type" : "varchar",
                            "length" : 250,
                            "multilang" : false,
                            "form" : {
                                    "page" : {
                                            "name" : "menu_title",
                                            "label" : "menu_title",
                                            "class" : "menu_title required",
                                            "id" : "menu_title"
                                        },
                                    "menu" : {
                                            "name" : "menu_title",
                                            "label" : "menu_title",
                                            "class" : "menu_title required",
                                            "id" : "menu_title",
                                            "open_decoration" : "menu_selector"
                                        }
                                }
                            
                        },
                    "permalink" : {
                            "type" : "varchar",
                            "length" : 250,
                            "multilang" : false,
                            "form" : {
                                    "page" : {
                                            "name" : "permalink",
                                            "label" : "permalink",
                                            "class" : "permalink required",
                                            "id" : "permalink",
                                            "order" : 3
                                        },
                                    "menu" : {
                                            "name" : "permalink",
                                            "label" : "permalink",
                                            "class" : "permalink required",
                                            "id" : "permalink",
                                            "order" : 3
                                        }
                                }
                        },
                    "ordering" : {
                            "type" : "int",
                            "form" : {
                                    "page" : {
                                            "label" : "order",
                                            "name"  : "ordering",
                                            "class" : "ordering digits required",
                                            "function" : "page::page_order",
                                            "function_param" : {
                                                    "table" : "site_menus"
                                                },
                                            "order" : 4
                                        },
                                    "menu" : {
                                            "label" : "order",
                                            "name"  : "ordering",
                                            "class" : "ordering digits required",
                                            "function" : "page::page_order",
                                            "function_param" : {
                                                    "table" : "site_menus"
                                                },
                                            "order" : 4
                                        }
                                }
                        },
                    "status" : { 
                            "type" : "enum",
                            "option" : "active,inactive",
                            "default" : "active",
                            "form" : {
                                    "page" : {
                                            "label" : "status",
                                            "name"  : "status",
                                            "class" : "required",
                                            "order" : 5,
                                            "close_decoration" : "menu_selector"
                                        }
                                }
                        }
                },
            "site_menu_positions" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "auto" : true
                        },
                    "label" : {
                            "type" : "char",
                            "length" : 20
                        }
                },
            "site_menu_position_applications" : 
                {
                    "site_menu_id" : {
                            "type" : "int",
                            "primary" : true,
                            "seek" : "site_menus"
                        },
                    "site_menu_position_id" : {
                            "type" : "int",
                            "primary" : true,
                            "form" : {
                                    "menu" : {
                                            "label" : "positions",
                                            "name"  : "position",
                                            "function" : "general::form_menu_position",
                                            "class" : "required",
                                            "close_decoration" : "menu_selector"
                                        }
                                }
                        }
                }
        }
    ',   
    'mandatory' => ' 
        {
            "configs" : 
                [
                    {
                        "id" : "track_history",
                        "description" : "1 for On and 0 for Off",
                        "value" : {"value":"1"}
                    }
                ],
            "site_menu_positions" : 
                [
                    {
                        "id" : "1",
                        "label" : "Main"
                    },
                    {
                        "id" : "2",
                        "label" : "Bottom"
                    }
                ],
            "site_menus" :
                [
                    {
                        "id" : 1,
                        "is_system" : 1,
                        "parent_id" : 0,
                        "menu_title" : "Home",
                        "permalink" : "home",
                        "ordering" : 1     
                    }
                ],
            "site_menu_position_applications" :
                [
                    {
                        "site_menu_id" : 1,
                        "site_menu_position_id" : 1
                    }
                ],
            "languages" :
                [
                    {
                        "id" : "en",
                        "label" : "English",
                        "is_system" : 1,
                        "status" : "active",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `languages`"            
                    },
                    {
                        "id" : "id",
                        "label" : "Indonesian",
                        "is_system" : 1,
                        "status" : "active",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `languages`"   
                    }
                ],
            "modules" : 
                [
                    {
                        "id" : "template",
                        "label" : "template",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                        "is_system" : 1              
                    },
                    {
                        "id" : "system",
                        "label" : "system",
                        "ordering" : 999,      
                        "is_system" : 1          
                    }
                ],
            "module_menus" :
                [
                    {
                        "id" : "system_2",
                        "module_id" : "system",
                        "parent_id" : 0,
                        "label" : "histories",
                        "permalink" : "history",
                        "ordering" : 1
                    },
                    {
                        "id" : "system_1",
                        "module_id" : "system",
                        "parent_id" : 0,
                        "label" : "module_setting",
                        "permalink" : "module-setting",
                        "ordering" : 2
                    },
                    {
                        "id" : "system_3",
                        "module_id" : "system",
                        "parent_id" : 0,
                        "label" : "site_menu",
                        "permalink" : "site-menu",
                        "ordering" : 3
                    }
                ],
            "module_menu_positions" : 
                [
                    {
                        "module_menu_id" : "system_3",
                        "position" : "left"
                    }
                ]
        }
    '
);
?>