<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Career Read Controller
 * @Module      Career
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Site_Career_Home extends Controller_Space_Site {
    
    protected $site;
    
    protected $paramLink;
    
    protected $paramApply;
    
    public function before() {        
        parent::before();     
        
        $this->layout = 'two-column';
        
        $g = DB::select('id',array('menu_title','title'))->from('site_menus')->where('permalink','=','career')->where('status','=','active')->as_object()->execute()->current();
        if (is_object($g))
        {
            $this->site->menu = $g;
        } 
        else 
        {
            $this->site->menu->id = 0;
            $this->site->menu->title = __('career');
        }      
             
        $this->site->menu->active = 'career';   
        
        /*** Banner ***/
        $this->site->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner')
                                ->render();  
                                
        $this->paramLink  = $this->request->param('permalink');     
        $this->paramApply = $this->request->param('param2');
    }
    
    public function action_index() {
        
        $this->site->left_content = '<div id="leftWrp">            
										<div class="sideMenu">
											<h2>Career</h2>
											<ul>
												<li><a href="'.Kohana::$base_url.'career" class="active">Apply Now</a></li>
											</ul>
										</div>
										<p>Email us at: <br/>
											<a style="text-decoration:none;" href="mailto:personalia@golden-agrici.com">personalia@golden-agrici.com</a></p>      
										</div>';
                
        $this->meta('title',$this->site->meta->title)
                        ->set('title','Welcome');
        
        $crumbs = array($this->site->menu->title => 'career');
        $g = DB::select()->from('careers')->where('status','=','active');
        if (!empty($this->paramLink))
        {
            $detail = array('item'=>$g->where('permalink','=',$this->paramLink)->execute()->current(),'post'=>array('name'=>'','email'=>''));            
                     
            if (!empty($this->paramApply))
            {
                $this->submitCareer($detail);
            }            
            $this->site->right_content = $this->html('detail',$detail); 
        }
        else 
        {
            $p = 1;
            $d = $g->order_by('tanggal')->execute()->as_array();        
            $this->site->right_content = $this->html('list',array(
                        'items' => $d
                    ));           
        }      
        $this->site->crumbs = $crumbs;             
	}
 
    protected function submitCareer(array &$detail)
    {
        $xpost = $this->request->post();   
        
        if (!empty($detail['item']['id']) && is_array($xpost) && $xpost !== array())
        {
            $post  = Validation::factory($xpost);
            
            $post->rule('name','not_empty');
            $post->rule('email','not_empty');
            $post->rule('email','email');
            $post->rule('email','email_domain');
            
            $errors = array();
            if (!$post->check())
            {
                $errors = $post->errors('transaction');
            }
            
            $types = array('pdf','jpeg','jpg','png','doc','docx','ppt','pptx');
            $size  = 10; 
            $file  = Validation::factory($_FILES);
            $file->rule('resume',array('Upload','not_empty'));
            $file->rule('resume',array('Upload','size'),array(':value',$size*1024000));
            $file->rule('resume',array('Upload','type'),array(':value',$types));
            
            if (!$file->check())
            {
                $fileErrors = $file->errors();
                
                foreach ($fileErrors as $k => $v)
                {
                    switch($v[0])
                    {
                        case 'size':
                            $params = array(':size'=>$size);
                            break;
                        case 'type':
                            $params = array(':type'=>implode(',',$types));
                            break;
                        default:
                            $params = array(); 
                            break;
                    }
                    $errors [] = strtr(Kohana::message('transaction',$k.'.'.$v[0]),$params);
                }
            }
            
            if ($errors !== array())
            {
                $detail = array(
                    'status' => 'error',
                    'error'  => '<ul class="error" style="color:red;margin-left:15px;"><li>' . implode('</li><li>',$errors) . '</li></ul>',
                    'post'   => $xpost
                ) + $detail;   
            }
            else
            {                
                $dir = 'media/resumes'; 
                $fn  = 'resume-' . Helper_Tool::file_name_beautification($xpost['name'] . '-' . time() . '.' . Helper_Tool::file_type($_FILES['resume']['name']));
                
                if (!is_dir($dir)) mkdir($dir,0755);
                $sv = Upload::save($_FILES['resume'],$fn,$dir);
                if ($sv !== false)
                {
                    
                    DB::insert('submit_careers',array('career_id','name','email','resume','apply'))
                                    ->values(array($detail['item']['id'],$xpost['name'],$xpost['email'],$dir.'/'.$fn,date('Y-m-d H:i:s')))
                                    ->execute();
                    
                    Session::instance()->set('submitCareer',__('submit-career-thank-you'));
                    
                    $body  = '<html><head><title>Golden Agin Career</title></head><body><table rules="all" style="border-color: #666;" cellpadding="10">';
                    $body .= '<tr style=\'background: #eee;\'><td>Name</td><td>' . $xpost['name'] . '</td></tr>';
                    foreach (array('email') as $i => $key)
                        $body .= '<tr><td>' . ucfirst($key) . '</td><td>' . $xpost[$key] . '</td></tr>';                    
                    
                    $body .= '</table><br/><br/><i style="font-size:9px;">This is an auto generated email. Do not reply</i></html>';
                    
                    Email::factory('Golden Agin Career',$body,'text/html')
                        ->from('no-reply@golden-agin.com','Noreply')
                        ->to('personalia@golden-agrici.com','Personalia Golden Agin')
                        ->attach_file($dir.'/'.$fn)
                        ->send();
                    
                    $this->request->redirect(URL::base(true) . 'career/' . $detail['item']['permalink'] . '/apply');
                                                                
                }
            }
        }
    }
    
    public function after() {        
        $this->render();
        parent::after();
    }

} // End Welcome
