<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Career List
 * @Module      Career
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'career/manage/applicant/<?php echo Request::$initial->param('param1');?>/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo HTML::anchor(URL::base(true) . 'admin-cp/career/manage','Back to Career'); ?></div>
    <div class="fr">
        <form action="<?php echo $site->bs_cms;?>career/manage/list/search" method="POST" id="frm_search">        
            <input tabindex="0" type="text" name="search_key" class="required" value="<?php echo $site->search_value; ?>"/>
            <input type="submit"/>
        </form>
    </div>
    
    <div class="clear"></div>
</div>

<?php
    $sessionFollowed = Session::instance()->get_once('followUp');
    if (!empty($sessionFollowed))
    {
        echo '<div class="warning">'. $sessionFollowed . '</div><br />';        
    } ?>
    
<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="checkbox"></th>
            <th class="no"><?php echo __('no');?></th>
            <th class="title">Name</th>
            <th class="status">Email</th>
            <th class="status">Resume</th>
            <th class="status" style="width: 150px;">Apply On</th>
            <th class="status">Followed</th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty($items)) {
                $index = $paging->current_first_item;                
                foreach ($items as $item) {
                    $modify_class = __make_class($index);                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="checkbox">';       
                            echo Form::checkbox('','',false,array(
                                    'class' => 'tocheck',
                                    'idx' => $item['id']
                                ));       
                        echo '</td>';
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search($item['name']).'</td>';
                        echo '<td class="center">'.$site->tool->mixed_search($item['email']).'</td>';
                        echo '<td class="center">'.HTML::anchor(URL::base(true).$item['resume'],'Resume',array('target'=>'_blank')).'</td>';
                        echo '<td class="center">' . $item['apply'] . '</td>';         
                        echo '<td class="center">';
                        if ($item['state'] === '1')
                        {
                            echo HTML::image(URL::base(true) . 'assets/themes/webarq/images/cms/icon/check.png');
                        }
                        echo '</td>';             
                        echo '<td class="center">'; 
                        if ($item['state'] === '0')
                        { 
                            echo HTML::anchor(
                                    URL::base(true).'admin-cp/career/manage/followup/'.$item['id'],
                                    HTML::image(URL::base(true) . 'assets/themes/webarq/images/cms/icon/arrow_up.png'),
                                    array('title'=>'Click to mark ' . $item['name'] . ' application as followed'));
                        }
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="8">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="7">
                &nbsp;
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php  echo $paging->render(); ?>
</div>
    