<?php

/**
 * @author Marjuqi R.
 * @copyright June 2012
 * @company WEBARQ
 */

class Model_ceo extends Model_Base
{
    public $isUpdate=FALSE;
    
    public function count_all($table=null)
    {
        if(empty($table)) return false;
        
        $result = DB::select(array('COUNT("id")', 'total_row'))
                ->from($table)                
                ->limit(1) 
                ->as_object()      
                ->execute();
        $rest = $result[0]->total_row;
        return $rest;
    }
               
    public function show_ceos()
    {
        return DB::select("*")
              ->from('ceos')
              ->as_object()
              ->execute();
    }
    
    // added by marjuqi rahmat, Juni 2012
    
    public function list_ceos($limit=0,$offset=0)
    {
        $query = "SELECT * FROM `ceos` AS v order by `id` desc
                LIMIT ".$offset." , ".$limit;
        
        $tmp    = DB::query(Database::SELECT,$query)
                ->as_object()
                ->execute();
        
       $result  =   array();
       $ii      =   0;
       foreach($tmp as $key=>$val) {
           $result[$ii++] = $val;
       }
       
       return $result;
    } 
    
    public function list_frontend_ceos($table,$table_row_id,$limit=100,$offset=0)
    {
        $query = "SELECT * FROM `ceos` AS v 
                    WHERE `table`='".$table."' and `table_row_id`='".$table_row_id."' and status='1'
                        ORDER by `id` desc
                            LIMIT ".$offset." , ".$limit;
        
        $tmp    = DB::query(Database::SELECT,$query)
                ->as_object()
                ->execute();
        
       $result  =   array();
       $ii      =   0;
       foreach($tmp as $key=>$val) {
           $result[$ii++] = $val;
       }
       
       return $result;
    } 

    public function read_ceos($id=null)
    {  
        $query = "Select * from ceos where id='$id' LIMIT 1";        
        $result = DB::query(Database::SELECT,$query)
            ->as_object()
            ->execute();
                        
        return $result; 
    }    

    public function get_data($id=null,$execute = true) {
        $prepare = $this->select();
        $prepare->from(array('ceos','r'));
        
        if (!empty($id) && !is_bool($id)) {
            $value = Helper_Tool::operator($id);
            $prepare->where('r.id '.$value);
        }
        $execute = is_bool($id) ? $id : $execute;
        
        return $this->process_data($prepare,$execute);    
    }    
    
    public function find_ceos($title=null,$offset=0,$limit=0)
    {  
       $query = "Select * from ceos where title like '%".$title."%' order by `title` asc limit $offset, $limit";
       return DB::query(Database::SELECT,$query)       
            ->as_object()
            ->execute();
    }
    
    public function delete_ceo($id=null)
    {        
        return DB::delete('ceos')
                ->where('id','=',$id)
                ->execute();
    }
    
    public function row_delete($id=0,$execute=true) {
        $execute = is_bool($id) ? $id : $execute;
        if ($execute === false) {
            return $this->delete('ceos');
        }else {
            $this->delete('ceos')->where('id = '.$id)->execute();
            return true;
        }
    }
    
    public function row_activate($id=0,$execute=true) {
        $execute = is_bool($id) ? $id : $execute;
        if ($execute === false) {
            return false;
        }else {
            
            $field_update = array('status'   => '1');
        
            $result = DB::update('ceos')
                        ->set($field_update)                    
                        ->where('id','=',$id)
                        ->execute();
            
            return true;
        }
    }
    
    public function row_deactivate($id=0,$execute=true) {
        $execute = is_bool($id) ? $id : $execute;
        if ($execute === false) {
            return false;
        }else {
            
            $field_update = array('status'   => '0');
        
            $result = DB::update('ceos')
                        ->set($field_update)                    
                        ->where('id','=',$id)
                        ->execute();
            
            return true;
        }
    }
    
    public static function total_ceo($execution = TRUE) {
        return Model::factory('base')->base_total('ceos','id',$execution);
    }
    
    public static function limit_ceo($execution = TRUE){
       
        $prepare = Model::factory('base')->select("*")
                        ->from("ceos")
                        ->offset(Paging::$page->offset)
                        ->limit(Paging::$page->items_per_page)
                        ->order_by('id','desc');
                        
        return $execution === true ? $prepare->execute() : $prepare;
    }       
    
    public function insert_ceo(array $post = array()) {            
//        $source_id = $owner = $table = $type = null;        
//        if (Config::check('track_history') == 1 ) {
//            $time = date('Y-m-d h:i:s');
//            extract($post);
//            return $this->insert('histories')
//                 ->set('source_id',$source_id)
//                 ->set('owner',$owner)
//                 ->set('table',$table)
//                 ->set('type',$type)
//                 ->set('time',$time)
//                 ->execute();
//        }
    }
    
}


// End of Model