<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong, modified by Marjuqi R.
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      Comment
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => '
        {
            "comments" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "table" : {
                            "type" : "varchar",
                            "length" : "25",
                            "form" : {
                                    "create_comment" : {
                                            "label" : "Table Name",
                                            "name" : "table",
                                            "class" : "required"
                                        },
                                    "edit_comment" : {
                                            "label" : "Table Name",
                                            "name" : "table",
                                            "class" : "required"
                                        }
                                }
                        },
                    "table_row_id" : {
                            "type" : "int",
                            "form" : {
                                    "create_comment" : {
                                            "label" : "Table Row ID",
                                            "name" : "table_row_id",
                                            "class" : "required"
                                        },
                                    "edit_comment" : {
                                            "label" : "Table Row ID",
                                            "name" : "table_row_id",
                                            "class" : "required"
                                        }
                                }
                        },
                    "comment" : {
                            "type" : "mediumtext",
                            "form" : {
                                    "create_comment" : {
                                            "label" : "Comment",
                                            "name" : "comment",
                                            "class" : "required"
                                        },
                                    "edit_comment" : {
                                            "label" : "Comment",
                                            "name" : "comment",
                                            "class" : "required"
                                        }
                                }
                        },
                    "status" : {
                            "type" : "tinyint"
                        }
                }
        }
    ',
    'mandatory' => '
        {
            "modules" : 
                [
                    {
                        "id" : "comment",
                        "label" : "comment",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                        "is_system" : 1
                    }
                ],
            "module_menus" : 
                [
                    {
                        "id" : "comment",
                        "module_id" : "comment",
                        "parent_id" : 0,
                        "label" : "comment",
                        "permalink" : "manage",
                        "ordering" : 1
                    }
                ],
            "module_menu_positions" : 
                [
                    {
                        "module_menu_id" : "comment",
                        "position" : "left"
                    }
                ]
        }
    ',
);

?>