<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Banner Position Class Controller
 * @Module      media Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_MediaLibrary_BannerPosition extends Controller_Space_Cms {
    protected $site;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'banner_position';
        $this->authorized(array('medialibrary' => 'manage_banner_position')); // Check permission           
         
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('mp.id = '.$value_condition)
            ->or_where('mp.label like %'.$value_condition.'%')
            ->or_where('mp.width like %'.$value_condition.'%')
            ->or_where('mp.height like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {    
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'medialibrary',
                    'items_per_page' => 10,
                    'list_items' => Model::factory('library')->media_position(false)
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_banner_position'))
                 ->set('title',__('banner_position_list'))
                 ->set('content',$this->html('banner-position-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('banner_position',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('library')->get_media_position($this->param2);
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('banner-position-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
        
    }
    
    public function action_save() {  
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => 'medialibrary',
                       'form'           => 'banner_position',
                       'owner'          => $this->site->user->profile->id
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('banner_position')))));
                    $this->request->redirect('admin-cp/medialibrary/banner-position/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/medialibrary/banner-position'); 
    }
    
    public function action_update() { 
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package'        => 'medialibrary',
                       'form'           => 'banner_position',
                       'owner'          => $this->site->user->profile->id
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/medialibrary/banner-position/form/edit/'.$this->param1);
    }
}


?>