<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Banner Position List
 * @Module      Media Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'medialibrary/banner-position/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'medialibrary/banner-position/form/create'); ?></div>
    <div class="fr">
        <form action="<?php echo $site->bs_cms;?>medialibrary/banner-position/search" method="POST" id="frm_search">        
            <input tabindex="0" type="text" name="search_key" class="required" value="<?php echo $site->search_value; ?>"/>
            <input type="submit"/>
        </form>
    </div>    
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('label');?></th>
            <th class="size"><?php echo __('width');?></th>
            <th class="size"><?php echo __('height');?></th>
            <th class="create_time"><?php echo __('create_time');?></th>
            <th class="last_update"><?php echo __('last_update');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {
                    $modify_class = __make_class($index,'active');
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search($item->label).'</td>';
                        echo '<td class="center">'.$item->width.'</td>';
                        echo '<td class="center">'.$item->height.'</td>';
                        echo '<td class="center">'.$item->time_created.'</td>';
                        echo '<td class="center">'.$item->last_updated.'</td>';
                        echo '<td class="center">';                            
                            echo Form::list_action($site,'edit',array(   
                                    'title' => __('edit_banner_position'),
                                    'href'  => $site->bs_cms.'medialibrary/banner-position/form/edit/'.$item->id
                                ));
                            
                            /**    
                            echo '&nbsp; &nbsp;';                         
                            echo Form::list_action($site,'delete',array(   
                                    'title' => __('delete_role'),
                                    "href"   => $site->bs_cms.'user/ajax/delete-user/'.$item->id,
                                    'class' => 'ajax',
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('role'.' '.$item->full_name))).'"
                                                    }]
                                        }',
                                ));
                                echo '&nbsp; &nbsp;';
                            **/
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="7">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="6">
                &nbsp;
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    