<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Industry List
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<style>
#fade { /*--Transparent background layer--*/
    display: none; /*--hidden by default--*/
    background: #000;
    position: fixed; left: 0; top: 0;
    width: 100%; height: 100%;
    opacity: .80;
    z-index: 9999;
}
.popup_block{
	display: none; /*--hidden by default--*/
	background: #fff;
	padding: 20px;
	border: 10px solid #ddd;
	float: left;
	font-size: 1.2em;
	position: fixed;
	top: 50%; left: 50%;
	z-index: 99999;
	/*--CSS3 Box Shadows--*/
	-webkit-box-shadow: 0px 0px 20px #000;
	-moz-box-shadow: 0px 0px 20px #000;
	box-shadow: 0px 0px 20px #000;
	/*--CSS3 Rounded Corners--*/
	-webkit-border-radius: 10px;
	-moz-border-radius: 10px;
	border-radius: 10px;
}
img.btn_close {
	float: right;
	margin: -55px -55px 0 0;
}
/*--Making IE6 Understand Fixed Positioning--*/
*html #fade {
	position: absolute;
}
*html .popup_block {
	position: absolute;
}
    
</style>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'order/manage/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">    
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('name');?></th>
            <th class="addres"><?php echo __('subject');?></th>
            <th class="addres"><?php echo __('phone');?></th>
            <th class="addres"><?php echo __('fax');?></th>
            <th class="addres"><?php echo __('company');?></th>
            <th class="status"><?php echo __('status');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
//        echo Debug::vars(Paging::$init->list_items);
//        exit();
        
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {   
                    $modify_class = __make_class($index,$item->status);
                    echo '<tr id ="id_'.$item->id.'" class="'.$modify_class.'">',"\n";
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$item->name.'</td>';
                        echo '<td class="left">'.$item->title.'</td>';
                        echo '<td class="left">'.$item->phone.'</td>';
                        echo '<td class="left">'.$item->fax.'</td>';
                        echo '<td class="left">'.$item->company.'</td>';
                        echo '<td class="center" id="'.$item->id.'">'.$item->status.'</td>';
                        echo '<td class="center">';
                                                      
                            echo Form::list_action($site,'view',array(   
                                    'title'     => __('view_inquiry'),
                                    'class'     => 'poplight inquiry_view',
                                    'rel'       => 'popup_name',
                                    'inquiry_id'=>  $item->id,
                                    'href'      => '#?w=800' //$site->bs_cms.'order/ajax/view-inquiry/'.$item->id
                                ));
                            echo '&nbsp; &nbsp;';
                                                                                  
                            echo Form::list_action($site,'delete',array(   
                                    'title' => __('delete_inquiry'),
                                    "href"   => $site->bs_cms.'order/ajax/delete-inquiry/'.$item->id,
                                    'class' => 'ajax',
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('inquiry'.' '.$item->title))).'"
                                                    }]
                                        }',
                                ));
                                echo '&nbsp; &nbsp;';
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="9">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="9">
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>

<div id="popup_name" class="popup_block">
    <div id="container_inquiry" style="padding: 0px 25px 25px 25px;">
        <div><h3><span class="subject"></span></h3></div>
        <div>from :  <strong><span class="sender"></span></strong></div>
        <div>to : <span class="attention"></span></div>
        <div style="margin: 10px 0px 10px 0px;">
            This Inquiry come from <strong><span class="sender_name"></span></strong> 
            from <span class="country">from </span>, 
            industry field: <span class="industry"></span>
        </div>      
        <div><span style="border-bottom: 1px solid #000;"><strong>Messages:</strong></span><br>
            <span class="message"></span>
        </div> 
    </div>
</div>

<script>
    $(function(){
        $(".inquiry_view").click(function(){
            var inquiry_id = $(this).attr('inquiry_id')
            $.ajax({
            url: bs_cms + 'order/ajax/view-inquiry',
            type: "post",
            data: "inquiry_id="+inquiry_id,
            async: false,
            dataType : 'json',
            success: function(msg) {
                title = msg.title;
                email = msg.email;
                name = msg.name;
                attention = msg.attention;
                industry = msg.industry;
                country = msg.country;
                message = msg.message;
                status = msg.status;
                
                $("span.subject").html('');                
                $("span.sender").html('');
                $("span.sender_name").html('');
                $("span.attention").html('');
                $("span.industry").html('');
                $("span.country").html('');
                $("span.message").html('');
                $("td#"+inquiry_id).html('');
                
                $("span.subject").append(title);                
                $("span.sender").append(email);
                $("span.sender_name").append(name);
                $("span.attention").append(attention);
                $("span.industry").append(industry);
                $("span.country").append(country);
                $("span.message").append(message);
                $("td#"+inquiry_id).append(status);
                
            }
        });  
        });

        //$(".inquiry_view").colorbox({inline:true, width:"880px"});
    });
</script>

<script>
$(document).ready(function() {
//When you click on a link with class of poplight and the href starts with a # 
$('a.poplight[href^=#]').click(function() {
    var popID = $(this).attr('rel'); //Get Popup Name
    var popURL = $(this).attr('href'); //Get Popup href to define size

    //Pull Query & Variables from href URL
    var query= popURL.split('?');
    var dim= query[1].split('&');
    var popWidth = dim[0].split('=')[1]; //Gets the first query string value

    //Fade in the Popup and add close button
    $('#' + popID).fadeIn().css({ 'width': Number( popWidth ) }).prepend('<a href="#" class="close">&nbsp;</a>');

    //Define margin for center alignment (vertical   horizontal) - we add 80px to the height/width to accomodate for the padding  and border width defined in the css
    var popMargTop = ($('#' + popID).height() + 80) / 2;
    var popMargLeft = ($('#' + popID).width() + 80) / 2;

    //Apply Margin to Popup
    $('#' + popID).css({
        'margin-top' : -popMargTop,
        'margin-left' : -popMargLeft
    });

    //Fade in Background
    $('body').append('<div id="fade"></div>'); //Add the fade layer to bottom of the body tag.
    $('#fade').css({'filter' : 'alpha(opacity=80)'}).fadeIn(); //Fade in the fade layer - .css({'filter' : 'alpha(opacity=80)'}) is used to fix the IE Bug on fading transparencies 

    return false;
});

//Close Popups and Fade Layer
$('a.close, #fade').live('click', function() { //When clicking on the close or fade layer...
    $('#fade , .popup_block').fadeOut(function() {
    	    $('#fade, a.close').remove();  //fade them both out
});
return false;
});
});
</script>
    