<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Widget Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Widget {
    #public $config = array('site'=>'');
            
    // @var object  widget object instance
    public static $instance;
    
    // @var string  widget name
    public $wi_name;
    
    // @var array   widget variables
    public $wi_vars;
     
    public static function factory($config = null){
        return Widget::$instance = new Widget ($config);
    }
    
    public function __construct($config = null) {        
        Package::$init->populate($this,$config);                
    }
    
    /**
     * @var string  widget name
     * @var array   widget variables
     */
    
    public function load($widget_name,array $widget_controller_vars = NULL) {
        Widget::$instance = new Widget(array('site'=>$this->site));
        $this->wi_name = $widget_name;
        $this->wi_vars = is_array($widget_controller_vars) ? array_merge($widget_controller_vars) : array();
        return $this;
    }
    
    /**
     * @var mixed   string variable name or array of variables
     * @var string  variable value  
     */
    public function set($key,$value) {
        if (is_array($key))
            foreach ($key as $new_key=>$value) $this->wi_vars[$new_key] = $value;
        else
            $this->wi_vars[$key] = $value;
            
        return $this;
    }
    
    public function render() {
        $xplode = explode('::',$this->wi_name);
        
        $path = $name = '';
        $idex = 1;     
                   
        foreach ($xplode as $dir) {              
            $path  .= $dir.'/';
            $name  .= $idex < count($xplode) ? $dir.' ' : $dir;
            $idex++;
        }         
        
        $find_file = Kohana::find_file('views/widget/'.$path,'controller');
        
        if ($find_file) {
            require_once $find_file;
            $widget = ucfirst('widget_'.$this->tool->pretty_name($name,'_').'_controller');
            if (!class_exists($widget)) {
                return __('widget_controller_not_exist',array('%widget_name'=>'<span class="widget_name">'.$name.'</span>'));    
            }
            $widget = new $widget;
            
            $widget->set($this->wi_vars)->set('site',$this->site)->set('path',$path);            
            Package::$init->set_model($widget,$xplode[0]);
            
            $return = method_exists($widget,'render') ? $widget->render() : null;  
            
            return !empty($return)
                ? $return
                : $this->capture(Kohana::find_file('views/widget/'.$path,'view'),array(
                        'wi_var' => $widget->data(),
                        'vars'   => $this->wi_vars,
                        'site'   => $this->site
                    ));
                
        }else {
            return __('widget_not_exist',array('%widget_name'=>'<span class="widget_name">'.$name.'</span>'));
        }
    }
    
    protected function capture($wi_name,array $wi_data = array()) {
        // Import the view variables to local namespace
		extract($wi_data, EXTR_SKIP);

		// Capture the view output
		ob_start();

		try
		{
			// Load the view within the current scope
			include $wi_name;
		}
		catch (Exception $e)
		{
			// Delete the output buffer
			ob_end_clean();

			// Re-throw the exception
			throw $e;
		}

		// Get the captured output and close the buffer
		return ob_get_clean();
    }
    
    
    public function __toString() {
		try
		{
			return $this->render();
		}
		catch (Exception $e)
		{
			// Display the exception message
			Kohana_Exception::handler($e);

			return '';
		}
    }
}


?>