<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author             Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Cms Ajax User Class Controller
 * @Module             Product
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Product_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();
    }
    
    /*** deleteproduct category ***/
    public function action_delete_category() {
        $result = false;  
        /* first delete all descendant of this category 
         * (the items, the accessories of items, the download stuff of an items)
         */
        $this->db->delete('product_accessories')
                ->where('product_category_id = '.$this->param1)
                ->execute();
        
        $this->db->delete('product_downloads')
                ->where('product_category_id = '.$this->param1)
                ->execute();
        
        $this->db->delete('product_items')
                ->where('product_category_id = '.$this->param1)
                ->execute();
        
        /**
         *when everything goes fine, then delete the category 
         */
        $delete = $this->db->delete('product_categories')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            // Get query image
            $cover = $this->request->query('cover');
            if (!empty($cover))
            {
                $cover = base64_decode($cover);
                if (is_file($cover)) unlink($cover);
                
            }
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete product items ***/
    public function action_delete_item() {
        $result = false;  
                
        /* first delete all descendant of this item 
         * (the accessories of items and the download stuff of an items)
         */
        $this->db->delete('product_accessories')
                ->where('product_item_id = '.$this->param1)
                ->execute();
        
        $this->db->delete('product_downloads')
                ->where('product_item_id = '.$this->param1)
                ->execute();
        
        $delete = $this->db->delete('product_items')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            // Get query image
            $cover = $this->request->query('cover');
            if (!empty($cover))
            {
                $cover = base64_decode($cover);
                if (is_file($cover)) unlink($cover);
                
            }
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete product_accessory  ***/
    public function action_delete_accessory() {
        $result = false;  
        $delete = $this->db->delete('product_accessories')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete product download ***/
    public function action_delete_download() {
        $result = false;  
        $delete = $this->db->delete('product_downloads')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
   /*
     * check captcha validation;
     */
    public function action_check_captcha(){
        $code = Arr::get($this->request->initial()->post(), 'code');
        $valid = Captcha::valid($code);
        
        $ret = array('result'=>$valid);

        $this->ajax = json_encode($ret);
    }
    
    /*
     * check captcha validation;
     */
    public function action_select_product_item(){
        $ret = array();
        $temp = array();
        
        $category_id = Arr::get($this->request->initial()->post(), 'category_id');
        
        $product_item = DB::select('id', 'title')
                ->from('product_items')
                ->where('product_category_id', '=', $category_id)
                ->as_object()
                ->execute();
        
        if($product_item->valid()){            
            foreach($product_item as $data){
                $ret = array("id"=>$data->id,"title"=>$data->title);
                $temp[] =   $ret;
                
            }            
        }
        
        $this->ajax = json_encode($temp);
    }
    
    
    /*
     * ;
     */
    public function action_view_accessory_image(){
        $ret = array(
                    'id'=>'',
                    'image_path'=>''
                );
        
        $accessory_id = Arr::get($this->request->initial()->post(), 'accessory_id');                  
        $accessory_image = Model::factory('productaccessory')->get_accessory($accessory_id);
          
        if(!empty($accessory_image)){
            foreach($accessory_image as $data){
                $ret = array(
                    'id'=>$data->id,
                    'image_path'=>$data->image_path
                );
            }
        }        
      $this->ajax = json_encode($ret);
    }
    
}