<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Product Management)
 * @Module      Product 
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Product extends Model_Base {
        
    /*
     * get all product categories
     */
    public function get_product_categories($activeness = 'active'){
        $result = DB::select('id', 'title', 'permalink')
                ->from('product_categories')
                ->where('status', '=', $activeness)
                ->as_object()
                ->execute();
              
        return ($result->valid()) ? $result : null;
    }
    
    /*
     * get all product categories
     */
    public function get_top_category_permalink($activeness = 'active'){
        $result = DB::select('permalink')
                ->from('product_categories')
                ->where('status', '=', $activeness)
                ->limit(1)
                ->as_object()
                ->execute();
              
        return ($result->valid()) ? $result->current()->permalink : null;
    }
    
    /*
     * get all product items by category permalink
     */
    public function get_product_items($selected_category=null, $activeness = 'active'){
        $cat_id = Model::factory('productcategory')->get_cat_id($selected_category);
             
        $sql = "SELECT `pi`.`id`, `pi`.`title`, `pi`.`product_category_id`, `pi`.`description`, `pi`.`feature_product`, `pi`.`information`,
                `pi`.`model`, `pi`.`customer_benefit`, `pi`.`image_path`, `pi`.`permalink`, `pi`.`status`
                FROM `product_items` AS `pi`";
        
        $sql .= (!empty($cat_id))
        ? " where pi.product_category_id ='$cat_id' and `pi`.`status` = '$activeness'" 
        : " where `pi`.`status` = '$activeness'";
        
        $query = DB::query(Database::SELECT, $sql);
        
        $result = $query->as_object()->execute();
              
        return ($result->valid()) ? $result : null;
    }
    
    /*
     * get all product items by category permalink
     */
    public function get_products($cat_id=null, $activeness = 'active'){
        $sql = "SELECT `pi`.`id`, `pi`.`title`, `pi`.`product_category_id`, `pi`.`description`, `pi`.`feature_product`, `pi`.`information`,
                `pi`.`model`, `pi`.`customer_benefit`, `pi`.`image_path`, `pi`.`permalink`, `pi`.`status`, `pa`.`file_path`
                FROM `product_items` AS `pi`
                LEFT JOIN `product_accessories`AS `pa`
                ON `pi`.`id` = `pa`.`product_item_id`";
        
        $sql .= (!empty($cat_id))
        ? " where pi.product_category_id ='$cat_id' and `pi`.`status` = '$activeness'" 
        : " where `pi`.`status` = '$activeness'";
        
        $query = DB::query(Database::SELECT, $sql);
        
        $result = $query->as_object()->execute();
              
        return ($result->valid()) ? $result : null;
    }
    
    /*
     * $param ==> permalink
     */
    public function menu_stuff($param) {
                
        $query = DB::select('menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid())
        {
            foreach ($query as $item)
            {
               $title_menu = $item->menu_title; 
            }            
        }
        else
        {
            $title_menu = null;
        }
        
        return $title_menu;
    }
    
     /*
     * 
     */
    public function get_parent_menu_title($param){
        
        $menu_title = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $menu_title = $query->current()->menu_title;
            } else {
                $query2 = DB::select('menu_title')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $menu_title = ($query2->valid()) ? $query2->current()->menu_title : null;
            }            
        }        
        return $menu_title;        
    }
    
    /*
     * 
     */
    public function get_category_name($category_id = null){
        $query = DB::select('permalink', 'title')
                ->from('product_categories')
                ->where('id', '=', $category_id)
                ->as_object()
                ->execute();
        
        $category_name = ($query->valid()) ? $query->current()->title : null;
        return $category_name;
    }  
    
    /*
     * 
     */
    public function get_item_name($item_id = null){
        $query = DB::select('permalink', 'title')
                ->from('product_items')
                ->where('id', '=', $item_id)
                ->as_object()
                ->execute();
        
        $item_name = ($query->valid()) ? $query->current()->title : null;
        return $item_name;
    } 
    
    
}
