<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Product Category)
 * @Module      Product Category
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Productaccessory extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('product_accessories')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'product_accessories "'.$check->label.'"'
                ));
    }
        
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_productaccessory($execution = TRUE){
        $product_accessories = Setup::join_histories('product_accessories')
                    ->order_by('id','desc');                     
        return $execution === true ? $product_accessories->execution() : $product_accessories;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('product_accessories');
        
        if ($get_params[0] == 'field') {
            $field_name = "product_accessories.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get product accesories by product item
     */
    public function get_product_accessory($permalink=null, $activeness='active'){        
        $result = null;
        
        if(!empty($permalink)){
            $query_product_id = Model::factory('productitem')->get_product_id($permalink);
            $product_id = $query_product_id->current()->id;
        }
        
        if(isset($product_id)){
        $query = DB::select()
            ->from('product_accessories')
            ->where('product_item_id', '=', $product_id)
            ->and_where('status', '=', $activeness)
            ->as_object()
            ->execute();
        
            $result = ($query->valid()) ? $query : null ;
        }   
        
        return $result;
    }
    
    /*
     * 
     */
    public function get_accessory($id=null){
                
        $result = DB::select('id', 'image_path')
            ->from('product_accessories')
            ->where('id', '=', $id)
            ->as_object()
            ->execute();
        
         return ($result->valid()) ? $result : null ;
    }
    
}
?>