<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author             Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Product Api Class
 * @Module             News
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Product extends Kohana_Product {
    
    public static function input_order_category(array $data = null) {
        $data['table'] = 'product_categories';
        return General::factory($data)->input_order();
    }
    
    public static function select_category(array $data = null) {
        $categories = Model::factory('productcategory')
                        ->limit_productcategory(false)                        
                        ->order_by('product_categories.id')
                        ->execute();
        
        $options = array(''=>__('select_one'));
        if (!empty($categories[0])) 
            foreach ($categories as $category)
                $options[$category->id] = $category->title;
        
        return Form::select($data['name'],$options,$data['value'],$data['attribute']);
    }
    
    public static function select_product(array $data = null, $category_id = null) {
        $products = Model::factory('productitem')
                        ->limit_productitem(false)
                        ->where('product_category_id', '=', $category_id)
                        ->order_by('product_items.id')
                        ->execute();
        
        $options = array(''=>__('select_one'));
        if (!empty($products[0])) 
            foreach ($products as $product)
                $options[$product->id] = $product->title;
        
        return Form::select($data['name'],$options,$data['value'],$data['attribute']);
    }
    
    public static function uploadCover($inputName,$width = null, $height = null)
    {
        if (isset($_FILES[$inputName]) && !empty($_FILES[$inputName]['name']))
        { 
            $exts = array('jpeg','jpg','gif','png');
            $file = Validation::factory($_FILES);            
            $file->rules($inputName,array(
               array(array('Upload','valid')),
               array(array('Upload','type'),array(':value', $exts))
            ));
            
            if ($file->check())
            {
                $fn  = Inflector::camelize($inputName.' '. time(). ' '.Helper_Tool::file_name_beautification($_FILES[$inputName]['name']));
                $dir = Inflector::plural($inputName);
                if (!is_dir('media/images/product/'.$dir)) 
                {
                    mkdir('media/images/product/'.$dir,0755);
                }
                $up = Upload::save($file[$inputName],$fn,'media/images/product/'.$dir.'/');
                
                if ($up !== false)
                {
                    // Resizing                        
                    $im  = Image::factory('media/images/product/'.$dir.'/'.$fn);
                    if (isset($width) && isset($height) && ($im->width !== $width || $im->height !== $height))
                    {
                        $im->resize($width,$height,Image::NONE);
                    }                
                    elseif (isset($width) && $im->width !== $width)
                    {
                        $im->resize($width);
                    }
                    elseif (isset($height) && $im->height !== $height)
                    {
                        $im->resize(null,$height);
                    }
                    
                    $im->save();
                    
                    return 'media/images/product/'.$dir.'/'.$fn;
                }
                else
                {
                    return array('status'=>'Error','message'=>'Error while trying to upload file');    
                }
            } 
            else
            {
                return array('status'=>'Error','message'=>'Please check your file');
            }         
        }
    }    
}