<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author           Daniel Simangunsong
 * @author        Deni Budhi Santana
 * @Company     Webarq
 * @copyright   2012
 * @Package     Module Package Installation
 * @Module        Product
 * @License      Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "product_categories" :
                    {
                        "id" :
                            {
                                "type" : "int",                            
                                "primary" : true,
                                "increment" : true
                            },
                        "title" :
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_category" :
                                            {
                                                "type" : "text",
                                                "label" : "Title",
                                                "name" : "title",
                                                "class" : "title required"
                                            }
                                    }
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_category" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 1                                                
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_category" :
                                            {
                                                "label" : "description",
                                                "type" : "textarea",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "product_category" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            },
                        "cover" :
                            {
                                "type"      : "varchar",
                                "length"    : 255,
                                "form"      :
                                    {
                                        "product_category" :
                                            {
                                                "label" : "Banner",
                                                "type"  : "file",
                                                "info"  : "Best image resolution: Width = 940px, Height = 238px"
                                            }
                                    }
                            }
                    },
                "product_items" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Title",
                                                "class" : "title required"
                                            }
                                    }                                
                            },
                        "model" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Model",
                                                "class" : "model required"
                                            }
                                    }                                
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 2
                                            }
                                    }
                            },
                        "product_category_id" : 
                            {
                                "type" : "int",
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "product_category",
                                                "class" : "product_category  required",
                                                "function" : "product::select_category",
                                                "order" : 2
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "description",
                                                "type"  : "textarea",
                                                "info"  : "Use ; marks as row separator and use | marks as field/value separator at one row"
                                            }
                                    }
                            },
                        "information" : 
                            {
                                "type" : "varchar",
                                "length" : 1208,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "information",
                                                "type"  : "textarea"
                                            }
                                    }
                            },
                        "customer_benefit" : 
                            {
                                "type" : "varchar",
                                "length" : 1208,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "customer_benefit",
                                                "type"  : "textarea",
                                                "info"  : "Use ; marks as row separator"
                                            }
                                    }
                            },
                        "image_path" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Image",
                                                "type"  : "file",
                                                "info"  : "Best image resolution: Width = 175px, Height = 285px"
                                            }
                                    }
                            },
                        "cover" :
                            {
                                "type"      : "varchar",
                                "length"    : 255,
                                "form"      :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Banner",
                                                "type"  : "file",
                                                "info"  : "Best image resolution: Width = 940px, Height = 238px"
                                            }
                                    }
                            },
                        "feature_product" : 
                            {
                                "type" : "enum",
                                "option" : "inactive,active",
                                "default" : "inactive",
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Feature Product"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "product_item" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            }
                    },
                "product_accessories" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "Title",
                                                "class" : "title required"
                                            }
                                    }                                
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 2
                                            }
                                    }
                            },
                        "product_category_id" : 
                            {
                                "type" : "int",
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "product_category",
                                                "class" : "product_category  required",
                                                "function" : "product::select_category",
                                                "order" : 2
                                            }
                                    }
                            },
                        "product_item_id" : 
                            {
                                "type" : "int",
                                "length" : 10,
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "product_item",
                                                "class" : "product_id  required",
                                                "function" : "product::select_product"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "description",
                                                "type"  : "textarea"
                                            }
                                    }
                            },
                        "file_path" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "PDF",
                                                "type"  : "file",
                                                "info"  : "File type allowed: PDF"
                                            }
                                    }
                            },
                        "image_path" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "Image",
                                                "type"  : "file",
                                                "info"  : "Best image resolution: Width = 120px, Height = 95px"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "product_accessory" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            }
                    },
                 "product_downloads" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "Title",
                                                "class" : "title required"
                                            }
                                    }                                
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 2
                                            }
                                    }
                            },
                        "product_category_id" : 
                            {
                                "type" : "int",
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "product_category",
                                                "class" : "product_category  required",
                                                "function" : "product::select_category",
                                                "order" : 2
                                            }
                                    }
                            },
                        "product_item_id" : 
                            {
                                "type" : "int",
                                "length" : 10,
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "product_item",
                                                "class" : "product_id  required",
                                                "function" : "product::select_product"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "description",
                                                "type"  : "textarea"
                                            }
                                    }
                            },
                        "file_path" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "file_path",
                                                "type"  : "file",
                                                "info"  : "File type allowed: PDF"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "product_download" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            }
                    }
            }
        ',
    'alter_configuration' => 
        '
            {
            
            }
                
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "product",
                            "label" : "product",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "product",
                            "action" : "create_product_category",
                            "label" : "create_product_category"
                        },
                        {
                            "module_id" : "product",
                            "action" : "edit_product_category",
                            "label" : "edit_product_category"
                        },
                        {
                            "module_id" : "product",
                            "action" : "delete_product_category",
                            "label" : "delete_product_category"
                        },
                        {
                            "module_id" : "product",
                            "action" : "view_product_category",
                            "label" : "view_product_category"
                        },
                        {
                            "module_id" : "product",
                            "action" : "create_product_item",
                            "label" : "create_product_item"
                        },
                        {
                            "module_id" : "product",
                            "action" : "edit_product_item",
                            "label" : "edit_product_item"
                        },
                        {
                            "module_id" : "product",
                            "action" : "delete_product_item",
                            "label" : "delete_product_item"
                        },
                        {
                            "module_id" : "product",
                            "action" : "view_product_item",
                            "label" : "view_product_item"
                        },
                        {
                            "module_id" : "product",
                            "action" : "create_product_accessory",
                            "label" : "create_product_accessory"
                        },
                        {
                            "module_id" : "product",
                            "action" : "edit_product_accessory",
                            "label" : "edit_product_accessory"
                        },
                        {
                            "module_id" : "product",
                            "action" : "delete_product_accessory",
                            "label" : "delete_product_accessory"
                        },
                        {
                            "module_id" : "product",
                            "action" : "view_product_accessory",
                            "label" : "view_product_accessory"
                        },
                        {
                            "module_id" : "product",
                            "action" : "create_product_download",
                            "label" : "create_product_download"
                        },
                        {
                            "module_id" : "product",
                            "action" : "edit_product_download",
                            "label" : "edit_product_download"
                        },
                        {
                            "module_id" : "product",
                            "action" : "delete_product_download",
                            "label" : "delete_product_download"
                        },
                        {
                            "module_id" : "product",
                            "action" : "view_product_download",
                            "label" : "view_product_download"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "product_1",
                            "module_id" : "product",
                            "parent_id" : 0,
                            "label" : "product_category_list",
                            "permalink" : "category/manage",
                            "ordering" : 1
                        },
                        {
                            "id" : "product_2",
                            "module_id" : "product",
                            "parent_id" : 0,
                            "label" : "product_item_list",
                            "permalink" : "product/manage",
                            "ordering" : 2
                        },
                        {
                            "id" : "product_3",
                            "module_id" : "product",
                            "parent_id" : 0,
                            "label" : "product_accessory_list",
                            "permalink" : "Accessory/manage",
                            "ordering" : 3
                        },
                        {
                            "id" : "product_4",
                            "module_id" : "product",
                            "parent_id" : 0,
                            "label" : "product_download_list",
                            "permalink" : "download/manage",
                            "ordering" : 4
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "product_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'create_product_category\'"
                        },
                        {
                            "module_menu_id" : "product_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'edit_product_category\'"
                        },
                        {
                            "module_menu_id" : "product_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'delete_product_category\'"
                        },
                        {
                            "module_menu_id" : "product_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'view_product_category\'"
                        },
                        {
                            "module_menu_id" : "product_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'create_product_item\'"
                        },
                        {
                            "module_menu_id" : "product_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'edit_product_item\'"
                        },
                        {
                            "module_menu_id" : "product_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'delete_product_item\'"
                        },
                        {
                            "module_menu_id" : "product_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'view_product_item\'"
                        },
                        {
                            "module_menu_id" : "product_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'create_product_accessory\'"
                        },
                        {
                            "module_menu_id" : "product_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'edit_product_accessory\'"
                        },
                        {
                            "module_menu_id" : "product_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'delete_product_accessory\'"
                        },
                        {
                            "module_menu_id" : "product_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'view_product_accessory\'"
                        },
                        {
                            "module_menu_id" : "product_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'create_product_download\'"
                        },
                        {
                            "module_menu_id" : "product_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'edit_product_download\'"
                        },
                        {
                            "module_menu_id" : "product_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'delete_product_download\'"
                        },
                        {
                            "module_menu_id" : "product_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'product\' AND `action` = \'view_product_download\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "product_1",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "product_2",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "product_3",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "product_4",
                            "position" : "left"
                        }
                    ],
                "site_menus" :
                    [
                        {
                            "is_system" : 1,
                            "parent_id" : 0,
                            "menu_title" : "Product",
                            "permalink" : "product",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `site_menus`"     
                        }
                    ],
                "site_menu_position_applications" :
                    [
                        {
                            "site_menu_id" : "SELECT `id` FROM `site_menus` WHERE `menu_title` = \'Product\'",
                            "site_menu_position_id" : 1
                        }
                    ]
            }
        '
);