<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (Role)
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Role extends Model_Base {
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_role($execution = TRUE){
        /**
        $role = $this->select()->from('roles')
                        ->offset(Paging::$page->offset)
                        ->limit(Paging::$page->items_per_page)
                        ->order_by('id','asc');
        **/
        $role = $this->select()->from('roles')->order_by('id','asc');
        
        return $execution === true ? $role->execute() : $role;
    }
    
    /**
     * @param integer role id
     * @param boolean true or false query execution
     * 
     * Get role listing
     */
    public function get_role($id=null,$execute = true) {
        $prepare = $this->select('r.id','r.label','r.status','is_admin');            
        $prepare->from(array('roles','r'));
        
        if (!empty($id) && !is_bool($id)) {
            $value = Helper_Tool::operator($id);
            $prepare->where('r.id '.$value);
        }
        $execute = is_bool($id) ? $id : $execute;
        
        return $this->process_data($prepare,$execute);    
    }
    
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action='create') {
        $check = $this->select(array('label','label'))->from('roles')->where('id = '.$id)->execute();
        return empty($check[0]->label) 
            ? __('unknown') 
            :__($action.'_role',array(
                '%role' => __($check[0]->label,array('%s'=>''))
            ));
    } 
    
    /**
     * @var integer content id of history item
     */
    public function historymap_permission($id) {
        $check = $this->select(array('label','label'))->from('permissions')->where('id = '.$id)->execute();
        return empty($check[0]->label) 
            ? __('unknown') 
            : __('create_permission',array(
                '%permission' => __($check[0]->label,array('%s'=>''))
            ));
    }      
    
    public function historymap_userrolepermission($id) {
        $check = $this->select(array('p.label','permission'),array('r.label','role'))
                ->from(array('user_role_permissions','urp'))
                ->join(array('permissions','p'))->on('p.id = urp.permission_id')
                ->join(array('roles','r'))->on('r.id = urp.role_id')
                ->where('urp.id = '.$id)
                ->execute();
        
        return empty($check[0])
            ? __('unknown').$id
            : __('set_role_permission',array(
                '%permission' => __($check[0]->permission,array('%s'=>'')),
                '%role' => __($check[0]->role,array('%s'=>''))
            ));
    }  
    
    /**
     * @param integer permission id
     * @param boolean true or false query execution
     * 
     * Get permission listing
     */
    public function permission($id = null,$execute = true) {
        $prepare = $this->select('p.id','p.module_id','p.action','p.label','p.description',array('m.label','module'))
            ->from(array('permissions','p'))
            ->join(array('modules','m'),'left')->on('m.id = p.module_id');
            
        
        
        if (!empty($id) && !is_bool($id)) {
            $value = Helper_Tool::operator($id);
            $prepare->where('p.id '.$value);
        }
        $execute = is_bool($id) ? $id : $execute;
        $prepare->order_by('m.ordering','asc');        
        return $this->process_data($prepare,$execute);        
    }
    
    /**
     * @param integer role id
     * 
     * Get all role's allowed action permission
     */
    public function mapping_role_permissions($role_id = -2000) {
        return $this->select('p.id','p.module_id','p.action')
            ->from(array('user_role_permissions','urp'))
            ->join(array('permissions','p'),'left')
            ->on('p.id = urp.permission_id')
            ->where("urp.role_id = $role_id")
            ->execute();
    }
    
    /**
     * @param integer role id
     * @param integer permission id
     * 
     * Check if role id allowed to do some action
     */
    public function is_permit($role_id = -2000,$permission_id = -2000) {
        $permit = $this->select('id')->from('user_role_permissions')
            ->where("role_id = $role_id")
            ->and_where("permission_id = $permission_id")
            ->execute();
            
        return empty($permit[0]->id) ? false : true;
    }
    
    /**
     * @param integer role id
     * @param integer permission id
     * @return kohana database query builder return
     */
    public function insert_role_permission($role_id,$permission_id) {
        return $this->insert('user_role_permissions')->set('role_id',$role_id)->set('permission_id',$permission_id)
            ->execute();
    }
    
    /**
     * @param integer permission id
     * @param integer role id
     * @return array  object of label permissions and role name
     */
    public function get_role_action_label($permission_id = 0, $role_id = 0) {
        return $this->select('urp.id','p.label',array('r.label','role'))
                ->from(array('permissions','p'))
                ->join(array('user_role_permissions','urp'),'left')->on('urp.permission_id = p.id')
                ->join(array('roles','r'),'left')->on('r.id = urp.role_id')
                ->where('urp.permission_id = '.$permission_id)
                ->and_where('urp.role_id = '.$role_id)
                ->execute();
    }
    
    public function del_role_permission($id=null) {
        $del = $this->delete('user_role_permissions');
        if (!is_bool($id)) {
            $del->where('id = '.$id)->execute();
        }        
        return $del;
    }
    
    /**
     * @param array
     */
    public function post_update(array $data = array()) {
            
    }
}
?>