<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Widget Permission Settings Controller
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Widget_User_Permission_Settings_Controller extends Setup {    
    public function data() {    
        if (!empty($this->role_id)) {
            $role = Model::factory('role');
            $get_role = $role->permission(false)
                      ->where('m.status = active');
                      
            if ($this->role_id > 1){
                $get_role->join(array('user_role_permissions','urp'))
                      ->on('urp.permission_id = p.id')
                      ->and_where('urp.role_id = '.$this->role_id);
                }
                          
            return array (
                'permissions' => $get_role->execute(),
                'roles' => $role->get_role('> 1',false)->where('r.status = active')->order_by('r.id','asc')->execute(),
                'model_role' => $role
            );
        } else {
            return false;
        }
    }
}
?>