<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong, modified by Marjuqi R.
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      CEO
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_CEO_Manage extends Controller_Space_Cms {
    protected $site;
    protected $items_per_page = 10;
    protected $total_items;
    public $ceo;
    
    public function before() {
        parent::before();     
        $this->ceo = Model::factory('ceo');
		$this->lib = ImageLibrary::factory();
        Paging::factory();		
    }
    
    public function action_index() {        
        $this->list_data();   
    }

    public function action_list() {
        $this->list_data();
    }
    
    private function list_data() {

        $data = $this->ceo->list_ceos($this->items_per_page);
        
        $paging = Paging::factory(array(
                'model' => 'ceo',
                'items_per_page' => $this->items_per_page,
                'list_items' => $data
            )); 
        
        Paging::$init->compile();       

        $this->site->menu->active = 'ceo_list';
        $this->meta('title','Manage CEO List')
             ->set('title',__('ceo list'))
             ->set('content',View::factory('cms/ceo-list', array(
                    'site' => $this->site,
                    'paging'=>$paging
                )))
             ->render();    
        
    }
    
    public function action_create() { 
	
        if ($this->authorisation === true) {
            $title = __('create',array('%item'=>__('ceo',array('%s'=>''))));
            
            $this->meta('title',__('manage_ceo'))
                 ->set('title',$title)
                 ->styles($this->site->system_js.'party3d/uploadify3/css/uploadify','screen,projection')
                 ->styles($this->site->system_js.'party3d/uploadify3/css/modify','screen,projection')
                 ->scripts($this->site->system_js.'party3d/uploadify3/scripts/uploadify')                 
                 ->set('content',View::factory('cms/ceo-form', array(
                        'site' => $this->site,
                        'action' => 'create',
                        'page' => 'create',
                        'lib' => $this->lib
                    )))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();    
        }
		
    }  
    
    public function action_save() {  
        if ($this->authorisation === true) {  
            if($this->post) {
                $transaction =  Transaction::factory(array(
                       'package' => 'ceo',
                       'form'    => 'create_ceo',
                       'job'     => 'insert',
                       'owner'   => $this->site->user->profile->id,
					   'post'    => $this->post
                  ));
                $transaction->start();
                $transaction->execute($transaction);
            }
        }
        
        $this->request->redirect('admin-cp/ceo/manage');
    }
    
    public function action_edit() {
        if ($this->authorisation === true) {  
		
            $title = __('edit',array('%item'=>__('ceo',array('%s'=>''))));
            
            $this->meta('title',__('manage_ceo'))
                 ->set('title',$title)
                 ->styles($this->site->system_js.'party3d/uploadify3/css/uploadify','screen,projection')
                 ->styles($this->site->system_js.'party3d/uploadify3/css/modify','screen,projection')
                 ->scripts($this->site->system_js.'party3d/uploadify3/scripts/uploadify')                 
                 ->set('content',View::factory('cms/ceo-form',array(
                    'data' 	=> $this->ceo->get_data($this->param1),
                    'page' 	=> 'update',
                    'action'=> 'update',
                    'site' 	=> $this->site,
					'lib' => $this->lib
                 )))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
				 
        }
    }    
    
    public function action_update() {
        if ($this->authorisation === true) {  
            if($this->post) {               
                $transaction =  Transaction::factory(array(
                       'package' => 'ceo',
                       'form'    => 'edit_ceo',
                       'job'     => 'update',
                       'owner'   => $this->site->user->profile->id,
                       'item_id' => $this->param1,
					   'post'    => $this->post
                  ));
                $transaction->start();  
                $transaction->_object['ceos']->where('id = '.$this->param1);
                $transaction->execute($transaction);
                
                if ($transaction === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }
        $this->request->redirect('admin-cp/ceo/manage/edit/'.$this->param1);
    }       
}
   

?>