<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Awards Management)
 * @Module      Awards 
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Contact extends Model_Base {
        
    /*
     * get all active award images
     */
    public function get_award_images($activeness = 'active'){
        $query = DB::select('media_libraries.file_name')
                ->from('media_applications')                
                ->join('media_libraries', 'left')
                ->on('media_applications.media_library_id', '=', 'media_libraries.id')
                ->where('media_applications.table', '=', 'awards')
                ->as_object()
                ->execute();
              
        if ($query->valid())
        {
            $result = $query;
        }
        else
        {
            $result = null;
        }
        
        return $result;
    }
    
    /*
     * $param ==> permalink
     */
    public function menu_stuff($param) {
                
        $query = DB::select('menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid())
        {
            foreach ($query as $item)
            {
               $title_menu = $item->menu_title; 
            }            
        }
        else
        {
            $title_menu = null;
        }
        
        return $title_menu;
    }
    
     /*
     * 
     */
    public function get_parent_menu_title($param){
        
        $menu_title = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $menu_title = $query->current()->menu_title;
            } else {
                $query2 = DB::select('menu_title')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $menu_title = ($query2->valid()) ? $query2->current()->menu_title : null;
            }            
        }        
        return $menu_title;        
    }
    
}
