<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author      Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Contacts Management)
 * @Module      Contact Location 
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_ContactLocation extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('title')->from('contact_locations')->where('id = '.$id)->execute()->current();
        return empty($check->title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'contact_locations "'.$check->title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_contactlocation($execution = TRUE){
        $contact_locations = Setup::join_histories('contact_locations')
                    ->order_by('id','desc');                     
        return $execution === true ? $contact_locations->execution() : $contact_locations;
    }
    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('contact_locations');
        
        if ($get_params[0] == 'field') {
            $field_name = "contact_locations.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get toop location
     */
    public function get_office_location(){
        $result = DB::select()
                ->from('contact_locations')
                ->where('status', '=', 'active')
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
    
}
?>