<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    View History
 * @Module      Base      
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

?>
<table class="webarq_percent_table" id="history">
    <thead>
        <tr>
            <th class="checkbox"></th>
            <th class="no"><?php echo __('no');?></th>
            <th class="date"><?php echo __('date');?></th>
            <th><?php echo __('description');?></th>
            <!--<th class="action"><?php echo __('action');?></th>-->
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items)) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $history) {
                    $modify_class  = 'listing_';
                    $modify_class .= $index % 2 == 0 ? 'odd' : '';
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="checkbox">';        
                            echo Form::checkbox('','',false,array(
                                    'class' => 'tocheck',
                                    'idx' => $history->id                                     
                                ));                    
                        echo '</td>';
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td class="center">'.$site->tool->manipulate_date($history->time).'</td>';
                        echo '<td class="history">';  
                            echo empty($history->description)
                                ? Historymap::factory(array(
                                        'table'  => $history->table,
                                        'actor'  => $history->actor,
                                        'action' => $history->type,
                                        'to_map' => $history->source_id
                                    ))->description
                                : Config::reverse_message($history->description);   
                        echo '</td>';
                        /**
                        echo '<td class="center">';
                            echo Form::list_action($site,'delete',array(
                                    "class"  => "ajax",
                                    "href"   => $site->bs_cms.'system/ajax/delete-history/'.$history->id,
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message" : [{
                                                    "title":"'.__('confirmation').'",
                                                    "body":"'.__('permanent_delete').'"
                                                }]
                                        }'
                                ));
                        echo '</td>';
                        **/
                    echo '</tr>',"\n";
                    $index++;
                }
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td colspan="4">
                &nbsp;
                <?php 
                    /**
                    echo Html::anchor('#',__('check_all'),array('class'=>'checkbox_trigger check', 'id'=>'active'));
                    echo '&nbsp;|&nbsp;';
                    echo Html::anchor('#',__('uncheck_all'),array('class'=>'checkbox_trigger uncheck', 'id'=>'inactive'));
                    echo '&nbsp;&nbsp;';
                    echo Form::select(
                            'run_trigger',
                            array(
                                '' =>  __('with_selected'),
                                'delete-history' => __('delete')
                            ), 
                            null, 
                            array(
                                'class'    => 'general',
                                'id'       => 'run_trigger',
                                'disabled' => 'disabled',
                                'href'     => $site->bs_cms.'system/ajax',
                                'i_have'   => '{
                                        "session":"'.$site->cookie.'",
                                        "model":"history",
                                        "message" : [{
                                            "global_title" : "'.__('confirmation').'",
                                            "delete-history" : [{
                                                "body" : "'.__('permanent_delete').'"
                                            }]
                                        }]
                                    }'
                            ),
                            false
                        );
                    **/
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php echo Paging::$page->render();?>
</div>