<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Profile Class Controller
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_User_Profile extends Controller_Space_Cms {
    protected $site;
    
    public function before() {
        parent::before();
    }
    
    public function action_index() {        
        $this->meta('title','My profile')
             ->set('title','My Profile')
             ->set('content',Widget::$instance->load('user::profile'))
             ->render();
    }
    
    public function action_edit() {  
        $data = Model::factory('user')->get_by('field','id',$this->param1)->current(); 
        
        $this->meta('title',__('edit_profile'))
            ->set('title',__('edit_profile'))
            ->set('content',$this->html('user-form')
                ->set('transaction','edit')
                ->set('data',$data)
                ->set('form_action','profile/update/'.$this->param1)
                ->set('form_profile',true)
              )
            ->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate'
            ))
            ->render();
    }
    
    public function action_update() {
        if($this->post) {     
            $this->post['password'] =
                $this->post['password'] == $this->post['previous_password']
                    ? false 
                    : $this->site->user->make_password($this->post['password']);
            $transaction =  Transaction::update(array(
                   'package' => 'user',
                   'form'    => 'cms_user_form',
                   'owner'   => $this->site->user->profile->id,
                   'post'    => $this->post
              ));
            $transaction->execute($transaction);
            
            if ($transaction === true) {
                Session::instance()->set('message',__('success_update'));
            }else{
                Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
            }
        }
        $this->request->redirect('admin-cp/user/profile/edit/'.$this->param1);
    }
}