<?php

defined('SYSPATH') or die('No direct script access.');

// -- Environment setup --------------------------------------------------------
// Load the core Kohana class
require SYSPATH . 'classes/kohana/core' . EXT;

if (is_file(APPPATH . 'classes/kohana' . EXT)) {
    // Application extends the core
    require APPPATH . 'classes/kohana' . EXT;
} else {
    // Load empty core extension
    require SYSPATH . 'classes/kohana' . EXT;
}

/**
 * Set the default time zone.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/timezones
 */
date_default_timezone_set('America/Chicago');

/**
 * Set the default locale.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'en_US.utf-8');

/**
 * Enable the Kohana auto-loader.
 *
 * @see  http://kohanaframework.org/guide/using.autoloading
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Kohana', 'auto_load'));

/**
 * Enable the Kohana auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

// -- Configuration and initialization -----------------------------------------

/**
 * Set the default language
 */
I18n::lang('en');


/**
 * Package initiation
 */
Package::instance();

/**
 * Set Kohana::$environment if a 'KOHANA_ENV' environment variable has been supplied.
 *
 * Note: If you supply an invalid environment name, a PHP warning will be thrown
 * saying "Couldn't find constant Kohana::<INVALID_ENV_NAME>"
 */
Kohana::$environment = Kohana::DEVELOPMENT; // Adding Code DEVELOPMENT MODE.
# Kohana::$environment = Kohana::PRODUCTION;  // Adding Code PRODUCTION MODE.

if (isset($_SERVER['KOHANA_ENV'])) {
    Kohana::$environment = constant('Kohana::' . strtoupper($_SERVER['KOHANA_ENV']));
}

/**
 * Initialize Kohana, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */
Kohana::init(array(
    'base_url' => '/',
    'index_file' => FALSE,
));

/**
 * Attach the file write to logging. Multiple writers are supported.
 */
Kohana::$log->attach(new Log_File(APPPATH . 'logs'));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Kohana::$config->attach(new Config_File);


/**
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Kohana::modules(
        array(
            /********************* Kohana Default Modules *********************/
            // Database
            'database' => MODPATH . 'database', 
            // Image 
            'image' => MODPATH . 'image',
            // Imagefly 
            'imagefly' => MODPATH . 'imagefly',
            // Userguide
            'userguide' => MODPATH . 'userguide',
            // Pagination 
            'pagination' => MODPATH . 'pagination',
            // Email
            'email' => MODPATH . 'email',
            // Captcha 
            'captcha' => MODPATH . 'captcha',
            
            /********************* WCMS' Required Modules *********************/
            // Plug 
            'plug' => MODPATH . 'ampflified/plug',
            // Global Configuration
            'globalconfig' => MODPATH . 'ampflified/globalconfig',
            // User 
            'user'          => MODPATH . 'ampflified/user',
            // Page 
            'page'          => MODPATH . 'ampflified/page',
            // Templanation
            'template'      => MODPATH . 'ampflified/templanation',
            
            /********************* WCMS' Optional Modules *********************/
            // Comment 
            //'comment'       => MODPATH . 'ampflified/comment',
            // CEO (Chief Executive Officer)
            //'ceo'           => MODPATH . 'ampflified/ceo',
            // Media Library 
            'library'       => MODPATH . 'ampflified/medialibrary',
            // News 
            'news'          => MODPATH . 'ampflified/news',
            // Event 
            'event'         => MODPATH . 'ampflified/event',
            // Contact 
            'contact'       => MODPATH . 'ampflified/contact',
            // home banner / slider 
            'homeslider'    => MODPATH . 'ampflified/homeslider',
            // Order 
            'order'         => MODPATH . 'ampflified/order',
            // Product 
            'product'       => MODPATH . 'ampflified/product',
        )
    ) ;



/**
 * Set the routes. Each route must have a minimum of a name, a URI and a set of
 * defaults for the URI.
 */

// Select default lang
$default_lang = Db::select('id')
                    ->from('languages')
                    ->order_by('ordering','asc')
                    ->where('status','=','active')
                    ->limit(1)
                    ->as_object()
                    ->execute()
                    ->current();
                    
$default_lang = empty($default_lang->id) ? 'en' : $default_lang->id; 

 // Enable only language in uri
Route::set('language', '(<lang>)',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => $default_lang,
        'directory'  => 'site/system',
		'controller' => 'home',
		'action'     => 'index',
	));

/*
 * imagefle routing
 */
Route::set('imagefly', 'imagefly/<params>/<imagepath>', array('imagepath' => '.*'))
    ->defaults(array(
        'directory'  => 'site',
        'controller' => 'imagefly',
    ));


// Catch-all route for Captcha classes to run
Route::set('captcha', 'captcha(/<group>)')
	->defaults(array(
		'controller' => 'captcha',
                'directory' => 'site',
		'action' => 'index',
		'group' => NULL
          ));

// Search Routing 
Route::set('search', '(<lang>/)search(/<param1>(/<param2>(/<param3>(/<param4>))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/search',
		'controller' => 'pages',
		'action'     => 'view',
	));

/**
 * module pages routing 
 */
Route::set('pages', '(<lang>/)pages(/<param1>(/<param2>(/<param3>(/<param4>))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/page',
		'controller' => 'pages',
		'action'     => 'view',
	));

/**
 * module pages contact-us 
 */
Route::set('contact-us', '(<lang>/)contact-us(/<action>(/<param1>(/<param2>(/<param3>(/<param4>)))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/contact',
		'controller' => 'contact',
		'action'     => 'index',
	));

/**
 * module pages contact
 */
Route::set('contact', '(<lang>/)contact(/<action>(/<param1>(/<param2>(/<param3>(/<param4>)))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/contact',
		'controller' => 'contact',
		'action'     => 'index',
	));

/**
 *module news and event routing 
 */
Route::set('news-event', '(<lang>/)news-event(/<controller>(/<permalink>))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/news',
		'controller' => 'read',
		'action'     => 'index',
	));

/**
 *module news routing 
 */
Route::set('news', '(<lang>/)news(/<action>(/<permalink>))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/news',
		'controller' => 'read',
		'action'     => 'index',
	));

/**
 *module event routing 
 */
Route::set('event', '(<lang>/)event(/<action>(/<permalink>))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/event',
		'controller' => 'home',
		'action'     => 'index',
	));

/**
 *module order 
 */
Route::set('how-to-order', '(<lang>/)how-to-order(/<permalink>)',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/order',
		'controller' => 'order',
		'action'     => 'index',
	));

/**
 *module product 
 */
Route::set('product', '(<lang>/)product(/<param1>(/<param2>))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site/product',
		'controller' => 'product',
		'action'     => 'index',
	));
    
// System Routing  
Route::set('site-system','(<lang>/)(<controller>(/<action>(/<param1>(/<param2>(/<param3>(/<param4>))))))',
            array('
                lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})', // \w{2}
                'controller' => 'home'
            )) 
	->defaults(array(
        'lang'       => $default_lang,
        'directory'  => 'site/system',
		'controller' => 'home',
		'action'     => 'index',
	));  
 
// All error should be used this routing
Route::set('error', '(<lang>/)(<page>/)error(/<action>(/<message>))', array('lang' => '\w{2}','action' => '[0-9]++', 'message' => '.+','page'=>'frontend|cms'))
    ->defaults(array(
        'lang'       => $default_lang,
        'page'       => 'frontend',
        'directory'  => 'error',
        'controller' => 'error'
    ));

// General Routing
Route::set('general', '(<lang>/)general/(<controller>(/<action>(/<param1>(/<param2>(/<param3>)))))', array('lang' => '\w{2}','message' => '.+'))
    ->defaults(array(
        'lang'       => $default_lang,
        'directory'  => 'general',
        'controller' => 'cheat',
        'action'     => 'testme'
    ));

// Backend Routing
Route::set('cms', '(<lang>/)'.CMSPAGE.'(/<package>(/<controller>(/<action>(/<param1>(/<param2>(/<param3>(/<param4>)))))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})'))
	->defaults(array(
        'lang'       => $default_lang,
        'directory'  => 'cms',
        'package'    => 'user',
		'controller' => 'auth',
		'action'     => 'index',
	));



// Site routing
Route::set('site', '(<lang>/)(<package>(/<controller>(/<action>(/<param1>(/<param2>(/<param3>(/<param4>)))))))',array('lang' => '([a-zA-Z]{2}|[a-zA-Z]{2}-[a-zA-Z]{2})')) // \w{2}
	->defaults(array(
        'lang'       => 'en',
        'directory'  => 'site',
        'package'    => 'system',
		'controller' => 'home',
		'action'     => 'index',
	));

// Default Routing    
Route::set('default', '(<controller>(/<action>(/<id>)))')
        ->defaults(array(
            'controller' => 'welcome',
            'action' => 'index',
        ));

/** Test Given URI **/  /**
$uri = '';
foreach (Route::all() as $r)
{
  echo Debug::vars($r->matches($uri));
}
exit;

/** **/