/*
SQLyog Ultimate v9.02 
MySQL - 5.5.16 : Database - client_goldenagin
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`client_goldenagin` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `client_goldenagin`;

/*Table structure for table `attentions` */

DROP TABLE IF EXISTS `attentions`;

CREATE TABLE `attentions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `receiver` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `attentions` */

insert  into `attentions`(`id`,`title`,`description`,`receiver`,`status`) values (1,'Customer Support','<p>\n	customer support.</p>\n','goldengs@cbn.net.id','active'),(2,'Information','<p>\n	Information</p>\n','info-goldengs@cbn.net.id','active'),(3,'Tester','<p>\n	tis is email for tester</p>\n','andika@webarq.com','inactive');

/*Table structure for table `configs` */

DROP TABLE IF EXISTS `configs`;

CREATE TABLE `configs` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `value` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `configs` */

insert  into `configs`(`id`,`description`,`value`) values ('track_history','1 for On and 0 for Off','{\"value\":\"1\"}');

/*Table structure for table `contact_categories` */

DROP TABLE IF EXISTS `contact_categories`;

CREATE TABLE `contact_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `receiver` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `contact_categories` */

insert  into `contact_categories`(`id`,`title`,`description`,`receiver`,`status`) values (1,'Customer Service','<p>\n	this is attention for customer service.</p>\n','andika@webarq.com','active'),(2,'Developer','<p>\n	Developer</p>\n','andika@webarq.com','active');

/*Table structure for table `contact_locations` */

DROP TABLE IF EXISTS `contact_locations`;

CREATE TABLE `contact_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8_unicode_ci,
  `phone` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `google_coordinate` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `contact_locations` */

insert  into `contact_locations`(`id`,`title`,`address`,`phone`,`fax`,`email`,`status`,`google_coordinate`) values (1,'Head Office','<p>\n	Mitra Bahari Blok D1<br />\n	Jl. Pakin No. 1<br />\n	Jakarta Utara, Indonesia</p>\n',' (62-21) 6669 2030',' (62-21) 6669 2580, 6669','goldengs@cbn.net.id','active',' -6.126047,106.811142');

/*Table structure for table `countries` */

DROP TABLE IF EXISTS `countries`;

CREATE TABLE `countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `countries` */

insert  into `countries`(`id`,`title`,`country_code`,`status`) values (2,'India','IN','active'),(3,'Hong Kong','HK','active'),(4,'Japan','JP','active');

/*Table structure for table `events` */

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_date` datetime DEFAULT NULL,
  `location` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `image_path` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `events` */

insert  into `events`(`id`,`title`,`permalink`,`event_date`,`location`,`description`,`image_path`,`status`) values (2,'Event Test','event-test','2012-10-01 14:01:00',NULL,'<p>\n	<strong>Aliquam ac mauris at tellus fermentum dignissim</strong><br />\n	Praesent tincidunt, lacus sed volutpat dictum, diam eros laoreet massa, et vestibulum est lorem nec odio. Nam scelerisque, neque nec tempus fringilla, massa arcu faucibus lacus, sed commodo turpis libero in nunc. Aliquam ac mauris at tellus fermentum dignissim eu vel urna. Suspendisse eget neque in dolor iaculis suscipit ac sit amet justo. Cras gravida leo non sem dapibus vel pharetra urna lacinia. Vestibulum sit amet enim non nisi placerat rhoncus. Vivamus volutpat, mauris aliquet accumsan accumsan, enim ligula dignissim quam, eget accumsan felis augue nec enim. Aliquam dapibus sem ut mauris rhoncus interdum. Etiam elementum, tortor vitae consectetur auctor, mauris nunc fringilla ipsum, ac gravida est lorem ut odio. Quisque tempus ullamcorper lectus, a consequat eros condimentum eget. Fusce rutrum velit in diam varius aliquet lacinia risus dapibus. Donec pellentesque mi nec libero facilisis nec rhoncus odio hendrerit.<br />\n	<br />\n	Fusce in elit quis velit viverra porttitor. Sed et mauris a lacus aliquam faucibus quis eu magna. Donec tincidunt suscipit interdum. In erat felis, egestas sed placerat eget, lacinia vel metus. Fusce tortor ipsum, ullamcorper vel malesuada vel, feugiat sed elit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse posuere eleifend tempus. Etiam pulvinar quam quis leo venenatis <a href=\"http://www.google.com\" target=\"_blank\">lacinia</a>.<br />\n	&nbsp;</p>\n<ol>\n	<li>\n		Nulla et libero felis. Nullam quis velit quam. Curabitur sed massa augue.</li>\n	<li>\n		Nulla et libero felis. Nullam quis velit quam. Curabitur sed massa augue.</li>\n	<li>\n		Nulla et libero felis. Nullam quis velit quam. Curabitur sed massa augue.</li>\n</ol>\n','media/images/event/5069403c7b5d5_240x207.jpg','active');

/*Table structure for table `histories` */

DROP TABLE IF EXISTS `histories`;

CREATE TABLE `histories` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source_id` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(11) DEFAULT NULL,
  `table` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1713 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `histories` */

insert  into `histories`(`id`,`source_id`,`owner`,`table`,`type`,`time`) values (1,'track_history',1,'configs','create','2012-09-11 01:38:51'),(2,'1',1,'site_menu_positions','create','2012-09-11 01:38:51'),(3,'2',1,'site_menu_positions','create','2012-09-11 01:38:51'),(4,'1',1,'site_menus','create','2012-09-11 01:38:51'),(5,'0',1,'site_menu_position_applications','create','2012-09-11 01:38:51'),(6,'en',1,'languages','install','2012-09-11 01:38:51'),(7,'id',1,'languages','install','2012-09-11 01:38:51'),(8,'template',1,'modules','install','2012-09-11 01:38:51'),(9,'system',1,'modules','install','2012-09-11 01:38:51'),(10,'system_2',1,'module_menus','create','2012-09-11 01:38:51'),(11,'system_1',1,'module_menus','create','2012-09-11 01:38:52'),(12,'system_3',1,'module_menus','create','2012-09-11 01:38:52'),(13,'1',1,'module_menu_positions','set','2012-09-11 01:38:52'),(14,'2',1,'module_menu_positions','set','2012-09-11 01:38:52'),(15,'3',1,'module_menu_positions','set','2012-09-11 01:38:52'),(16,'1',1,'roles','create','2012-09-11 01:38:52'),(17,'2',1,'roles','create','2012-09-11 01:38:52'),(18,'1',1,'users','register','2012-09-11 01:38:52'),(19,'2',1,'users','register','2012-09-11 01:38:52'),(20,'0',1,'user_details','update','2012-09-11 01:38:52'),(21,'0',1,'user_details','update','2012-09-11 01:38:52'),(22,'user',1,'modules','install','2012-09-11 01:38:52'),(23,'1',1,'permissions','create','2012-09-11 01:38:52'),(24,'2',1,'permissions','create','2012-09-11 01:38:52'),(25,'3',1,'permissions','create','2012-09-11 01:38:52'),(26,'4',1,'permissions','create','2012-09-11 01:38:52'),(27,'5',1,'permissions','create','2012-09-11 01:38:52'),(28,'6',1,'permissions','create','2012-09-11 01:38:52'),(29,'7',1,'permissions','create','2012-09-11 01:38:52'),(30,'8',1,'permissions','create','2012-09-11 01:38:52'),(31,'user_1',1,'module_menus','create','2012-09-11 01:38:52'),(32,'user_2',1,'module_menus','create','2012-09-11 01:38:52'),(33,'user_3',1,'module_menus','create','2012-09-11 01:38:52'),(34,'user_4',1,'module_menus','create','2012-09-11 01:38:52'),(35,'1',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(36,'2',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(37,'3',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(38,'4',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(39,'5',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(40,'6',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(41,'7',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(42,'4',1,'module_menu_positions','set','2012-09-11 01:38:52'),(43,'5',1,'module_menu_positions','set','2012-09-11 01:38:52'),(44,'6',1,'module_menu_positions','set','2012-09-11 01:38:52'),(45,'7',1,'module_menu_positions','set','2012-09-11 01:38:52'),(46,'1',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(47,'2',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(48,'3',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(49,'4',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(50,'5',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(51,'6',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(52,'7',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(53,'8',1,'user_role_permissions','allow','2012-09-11 01:38:52'),(54,'page',1,'modules','install','2012-09-11 01:38:52'),(55,'9',1,'permissions','create','2012-09-11 01:38:52'),(56,'10',1,'permissions','create','2012-09-11 01:38:52'),(57,'11',1,'permissions','create','2012-09-11 01:38:52'),(58,'12',1,'permissions','create','2012-09-11 01:38:52'),(59,'page_1',1,'module_menus','create','2012-09-11 01:38:52'),(60,'8',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(61,'9',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(62,'10',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(63,'11',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(64,'8',1,'module_menu_positions','set','2012-09-11 01:38:52'),(65,'1',1,'media_positions','create','2012-09-11 01:38:52'),(66,'2',1,'media_positions','create','2012-09-11 01:38:52'),(67,'medialibrary',1,'modules','install','2012-09-11 01:38:52'),(68,'image_library',1,'module_menus','create','2012-09-11 01:38:52'),(69,'banner_position',1,'module_menus','create','2012-09-11 01:38:52'),(70,'13',1,'permissions','create','2012-09-11 01:38:52'),(71,'14',1,'permissions','create','2012-09-11 01:38:52'),(72,'12',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(73,'13',1,'module_menu_permissions','add','2012-09-11 01:38:52'),(74,'news',1,'modules','install','2012-09-11 01:38:52'),(75,'15',1,'permissions','create','2012-09-11 01:38:52'),(76,'16',1,'permissions','create','2012-09-11 01:38:52'),(77,'17',1,'permissions','create','2012-09-11 01:38:53'),(78,'18',1,'permissions','create','2012-09-11 01:38:53'),(79,'19',1,'permissions','create','2012-09-11 01:38:53'),(80,'20',1,'permissions','create','2012-09-11 01:38:53'),(81,'21',1,'permissions','create','2012-09-11 01:38:53'),(82,'22',1,'permissions','create','2012-09-11 01:38:53'),(83,'news_1',1,'module_menus','create','2012-09-11 01:38:53'),(84,'news_2',1,'module_menus','create','2012-09-11 01:38:53'),(85,'14',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(86,'15',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(87,'16',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(88,'17',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(89,'18',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(90,'19',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(91,'20',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(92,'21',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(93,'9',1,'module_menu_positions','set','2012-09-11 01:38:53'),(94,'10',1,'module_menu_positions','set','2012-09-11 01:38:53'),(95,'0',1,'site_menu_position_applications','create','2012-09-11 01:38:53'),(96,'event',1,'modules','install','2012-09-11 01:38:53'),(97,'23',1,'permissions','create','2012-09-11 01:38:53'),(98,'24',1,'permissions','create','2012-09-11 01:38:53'),(99,'25',1,'permissions','create','2012-09-11 01:38:53'),(100,'26',1,'permissions','create','2012-09-11 01:38:53'),(101,'event_1',1,'module_menus','create','2012-09-11 01:38:53'),(102,'22',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(103,'23',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(104,'24',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(105,'25',1,'module_menu_permissions','add','2012-09-11 01:38:53'),(106,'11',1,'module_menu_positions','set','2012-09-11 01:38:53'),(107,'2',1,'site_menus','create','2012-09-11 02:03:34'),(108,'2',1,'site_menu_position_applications','create','2012-09-11 02:03:34'),(109,'3',1,'site_menus','create','2012-09-11 02:41:38'),(110,'3',1,'site_menu_position_applications','create','2012-09-11 02:41:38'),(111,'1',1,'pages','create','2012-09-11 02:41:38'),(112,'1',1,'pages','update','2012-09-11 02:43:24'),(113,'4',1,'site_menus','create','2012-09-11 02:45:08'),(114,'4',1,'site_menu_position_applications','create','2012-09-11 02:45:08'),(115,'2',1,'pages','create','2012-09-11 02:45:08'),(116,'5',1,'site_menus','create','2012-09-11 03:02:01'),(117,'5',1,'site_menu_position_applications','create','2012-09-11 03:02:01'),(118,'3',1,'pages','create','2012-09-11 03:02:01'),(119,'6',1,'site_menus','create','2012-09-11 03:02:48'),(120,'6',1,'site_menu_position_applications','create','2012-09-11 03:02:48'),(121,'4',1,'pages','create','2012-09-11 03:02:48'),(122,'7',1,'site_menus','create','2012-09-11 03:06:31'),(123,'7',1,'site_menu_position_applications','create','2012-09-11 03:06:31'),(124,'8',1,'site_menus','create','2012-09-11 03:06:56'),(125,'8',1,'site_menu_position_applications','create','2012-09-11 03:06:56'),(126,'9',1,'site_menus','create','2012-09-11 03:07:50'),(127,'9',1,'site_menu_position_applications','create','2012-09-11 03:07:50'),(128,'10',1,'site_menus','create','2012-09-11 03:08:20'),(129,'10',1,'site_menu_position_applications','create','2012-09-11 03:08:20'),(130,'1',1,'media_positions','update','2012-09-11 03:38:01'),(131,'1',1,'media_positions','update','2012-09-11 03:38:28'),(132,'2',1,'media_positions','update','2012-09-11 03:39:38'),(133,'1',1,'news_categories','create','2012-09-14 07:19:17'),(134,'1',1,'news','create','2012-09-14 07:19:59'),(135,'2',1,'news','create','2012-09-17 12:10:33'),(136,'2',1,'news','delete','2012-09-17 12:11:13'),(137,'3',1,'news','create','2012-09-17 12:12:25'),(138,'4',1,'news','create','2012-09-17 12:16:12'),(139,'5',1,'news','create','2012-09-17 12:16:36'),(140,'6',1,'news','create','2012-09-17 12:21:49'),(141,'7',1,'news','create','2012-09-17 12:23:34'),(142,'7',1,'news','update','2012-09-17 12:44:25'),(143,'7',1,'news','delete','2012-09-17 12:50:59'),(144,'6',1,'news','delete','2012-09-17 12:51:03'),(145,'4',1,'news','delete','2012-09-17 12:51:06'),(146,'5',1,'news','delete','2012-09-17 12:51:10'),(147,'3',1,'news','delete','2012-09-17 12:51:13'),(148,'1',1,'news','update','2012-09-17 12:51:32'),(149,'8',1,'news','create','2012-09-17 12:57:49'),(150,'8',1,'news','update','2012-09-17 12:58:25'),(151,'1',1,'news','update','2012-09-17 12:59:20'),(152,'1',1,'events','create','2012-09-17 03:59:29'),(153,'11',1,'site_menus','create','2012-09-17 04:05:16'),(154,'11',1,'site_menu_position_applications','create','2012-09-17 04:05:16'),(155,'12',1,'site_menus','create','2012-09-17 04:05:33'),(156,'12',1,'site_menu_position_applications','create','2012-09-17 04:05:33'),(157,'contact',1,'modules','install','2012-09-17 06:08:43'),(158,'27',1,'permissions','create','2012-09-17 06:08:43'),(159,'28',1,'permissions','create','2012-09-17 06:08:43'),(160,'29',1,'permissions','create','2012-09-17 06:08:43'),(161,'30',1,'permissions','create','2012-09-17 06:08:43'),(162,'31',1,'permissions','create','2012-09-17 06:08:43'),(163,'32',1,'permissions','create','2012-09-17 06:08:43'),(164,'33',1,'permissions','create','2012-09-17 06:08:43'),(165,'34',1,'permissions','create','2012-09-17 06:08:43'),(166,'contact_1',1,'module_menus','create','2012-09-17 06:08:43'),(167,'contact_2',1,'module_menus','create','2012-09-17 06:08:43'),(168,'26',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(169,'27',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(170,'28',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(171,'29',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(172,'30',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(173,'31',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(174,'32',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(175,'33',1,'module_menu_permissions','add','2012-09-17 06:08:43'),(176,'12',1,'module_menu_positions','set','2012-09-17 06:08:43'),(177,'13',1,'module_menu_positions','set','2012-09-17 06:08:43'),(178,'1',1,'contact_locations','create','2012-09-17 06:15:28'),(179,'1',1,'contact_categories','create','2012-09-17 06:16:31'),(180,'13',1,'site_menus','create','2012-09-17 06:18:51'),(181,'13',1,'site_menu_position_applications','create','2012-09-17 06:18:51'),(182,'14',1,'site_menus','create','2012-09-17 06:19:11'),(183,'14',1,'site_menu_position_applications','create','2012-09-17 06:19:11'),(184,'1',1,'media_libraries','upload','2012-09-18 03:36:06'),(185,'2',1,'media_libraries','upload','2012-09-18 03:36:06'),(186,'3',1,'media_libraries','upload','2012-09-18 03:36:07'),(187,'4',1,'media_libraries','upload','2012-09-18 03:36:07'),(188,'5',1,'media_libraries','upload','2012-09-18 03:36:08'),(189,'6',1,'media_libraries','upload','2012-09-18 03:36:08'),(190,'7',1,'media_libraries','upload','2012-09-18 03:36:08'),(191,'8',1,'media_libraries','upload','2012-09-18 03:36:09'),(192,'3',1,'site_menus','update','2012-09-18 03:41:45'),(193,'9',1,'site_menus','update','2012-09-18 06:15:59'),(194,'11',1,'site_menus','update','2012-09-18 06:16:36'),(195,'12',1,'site_menus','update','2012-09-18 06:17:05'),(196,'10',1,'site_menus','update','2012-09-18 06:17:33'),(197,'homeslider',1,'modules','install','2012-09-18 06:51:43'),(198,'35',1,'permissions','create','2012-09-18 06:51:43'),(199,'36',1,'permissions','create','2012-09-18 06:51:43'),(200,'37',1,'permissions','create','2012-09-18 06:51:43'),(201,'38',1,'permissions','create','2012-09-18 06:51:43'),(202,'homeslider_1',1,'module_menus','create','2012-09-18 06:51:43'),(203,'34',1,'module_menu_permissions','add','2012-09-18 06:51:43'),(204,'35',1,'module_menu_permissions','add','2012-09-18 06:51:43'),(205,'36',1,'module_menu_permissions','add','2012-09-18 06:51:43'),(206,'37',1,'module_menu_permissions','add','2012-09-18 06:51:43'),(207,'14',1,'module_menu_positions','set','2012-09-18 06:51:43'),(208,'9',1,'media_libraries','upload','2012-09-18 06:55:49'),(209,'1',1,'home_sliders','create','2012-09-18 06:56:36'),(210,'2',1,'home_sliders','create','2012-09-18 06:57:16'),(211,'3',1,'home_sliders','create','2012-09-18 06:57:47'),(212,'15',1,'site_menus','create','2012-09-18 07:30:07'),(213,'15',1,'site_menu_position_applications','create','2012-09-18 07:30:07'),(214,'16',1,'site_menus','create','2012-09-18 10:13:06'),(215,'16',1,'site_menu_position_applications','create','2012-09-18 10:13:06'),(216,'order',1,'modules','install','2012-09-19 06:14:00'),(217,'39',1,'permissions','create','2012-09-19 06:14:00'),(218,'40',1,'permissions','create','2012-09-19 06:14:00'),(219,'41',1,'permissions','create','2012-09-19 06:14:00'),(220,'42',1,'permissions','create','2012-09-19 06:14:00'),(221,'43',1,'permissions','create','2012-09-19 06:14:00'),(222,'44',1,'permissions','create','2012-09-19 06:14:00'),(223,'45',1,'permissions','create','2012-09-19 06:14:00'),(224,'46',1,'permissions','create','2012-09-19 06:14:00'),(225,'47',1,'permissions','create','2012-09-19 06:14:00'),(226,'48',1,'permissions','create','2012-09-19 06:14:00'),(227,'49',1,'permissions','create','2012-09-19 06:14:00'),(228,'50',1,'permissions','create','2012-09-19 06:14:00'),(229,'order_1',1,'module_menus','create','2012-09-19 06:14:00'),(230,'order_2',1,'module_menus','create','2012-09-19 06:14:00'),(231,'order_3',1,'module_menus','create','2012-09-19 06:14:00'),(232,'38',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(233,'39',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(234,'40',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(235,'41',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(236,'42',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(237,'43',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(238,'44',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(239,'45',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(240,'46',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(241,'47',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(242,'48',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(243,'49',1,'module_menu_permissions','add','2012-09-19 06:14:00'),(244,'15',1,'module_menu_positions','set','2012-09-19 06:14:00'),(245,'16',1,'module_menu_positions','set','2012-09-19 06:14:00'),(246,'17',1,'module_menu_positions','set','2012-09-19 06:14:00'),(247,'order',1,'modules','install','2012-09-19 06:19:01'),(248,'1',1,'attentions','create','2012-09-20 05:14:10'),(249,'2',1,'attentions','create','2012-09-20 05:14:49'),(250,'1',1,'industries','create','2012-09-20 05:16:06'),(251,'2',1,'industries','create','2012-09-20 05:28:35'),(252,'3',1,'industries','create','2012-09-20 05:28:57'),(253,'4',1,'industries','create','2012-09-20 05:29:20'),(254,'5',1,'industries','create','2012-09-20 05:29:39'),(255,'6',1,'industries','create','2012-09-20 05:29:55'),(256,'7',1,'industries','create','2012-09-20 05:30:12'),(257,'8',1,'industries','create','2012-09-20 05:30:31'),(258,'9',1,'industries','create','2012-09-20 05:30:47'),(259,'10',1,'industries','create','2012-09-20 05:31:02'),(260,'11',1,'industries','create','2012-09-20 05:31:18'),(261,'12',1,'industries','create','2012-09-20 05:31:39'),(262,'13',1,'industries','create','2012-09-20 05:31:56'),(263,'14',1,'industries','create','2012-09-20 05:32:14'),(264,'15',1,'industries','create','2012-09-20 05:32:37'),(265,'16',1,'industries','create','2012-09-20 05:32:53'),(266,'17',1,'industries','create','2012-09-20 05:33:09'),(267,'18',1,'industries','create','2012-09-20 05:33:25'),(268,'19',1,'industries','create','2012-09-20 05:33:45'),(269,'1',1,'countries','create','2012-09-20 05:34:23'),(270,'2',1,'countries','create','2012-09-20 05:35:42'),(271,'2',1,'countries','update','2012-09-20 05:35:47'),(272,'2',1,'countries','update','2012-09-20 05:40:58'),(273,'1',1,'countries','update','2012-09-20 05:41:12'),(274,'3',1,'countries','create','2012-09-20 05:41:31'),(275,'4',1,'countries','create','2012-09-20 05:41:57'),(276,'8',1,'site_menus','update','2012-09-20 06:31:59'),(277,'51',1,'permissions','create','2012-09-21 02:29:39'),(278,'52',1,'permissions','create','2012-09-21 02:29:39'),(279,'order_4',1,'module_menus','create','2012-09-21 02:29:39'),(280,'50',1,'module_menu_permissions','add','2012-09-21 02:29:39'),(281,'18',1,'module_menu_positions','set','2012-09-21 02:29:39'),(282,'53',1,'permissions','create','2012-09-21 03:21:21'),(283,'54',1,'permissions','create','2012-09-23 11:55:56'),(284,'55',1,'permissions','create','2012-09-23 11:55:56'),(285,'56',1,'permissions','create','2012-09-23 11:55:56'),(286,'51',1,'module_menu_permissions','add','2012-09-23 11:55:56'),(287,'52',1,'module_menu_permissions','add','2012-09-23 11:55:56'),(288,'53',1,'module_menu_permissions','add','2012-09-23 11:55:56'),(289,'product',1,'modules','install','2012-09-24 02:33:25'),(290,'57',1,'permissions','create','2012-09-24 02:33:25'),(291,'58',1,'permissions','create','2012-09-24 02:33:25'),(292,'59',1,'permissions','create','2012-09-24 02:33:25'),(293,'60',1,'permissions','create','2012-09-24 02:33:25'),(294,'61',1,'permissions','create','2012-09-24 02:33:25'),(295,'62',1,'permissions','create','2012-09-24 02:33:25'),(296,'63',1,'permissions','create','2012-09-24 02:33:25'),(297,'64',1,'permissions','create','2012-09-24 02:33:25'),(298,'65',1,'permissions','create','2012-09-24 02:33:25'),(299,'66',1,'permissions','create','2012-09-24 02:33:25'),(300,'67',1,'permissions','create','2012-09-24 02:33:25'),(301,'68',1,'permissions','create','2012-09-24 02:33:25'),(302,'69',1,'permissions','create','2012-09-24 02:33:25'),(303,'70',1,'permissions','create','2012-09-24 02:33:25'),(304,'71',1,'permissions','create','2012-09-24 02:33:25'),(305,'54',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(306,'55',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(307,'56',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(308,'57',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(309,'58',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(310,'59',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(311,'60',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(312,'61',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(313,'62',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(314,'63',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(315,'64',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(316,'65',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(317,'66',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(318,'67',1,'module_menu_permissions','add','2012-09-24 02:33:25'),(319,'19',1,'module_menu_positions','set','2012-09-24 02:33:25'),(320,'20',1,'module_menu_positions','set','2012-09-24 02:33:25'),(321,'21',1,'module_menu_positions','set','2012-09-24 02:33:25'),(322,'22',1,'module_menu_positions','set','2012-09-24 02:33:25'),(323,'72',1,'permissions','create','2012-09-24 02:37:55'),(324,'73',1,'permissions','create','2012-09-24 02:37:55'),(325,'74',1,'permissions','create','2012-09-24 02:37:55'),(326,'product_1',1,'module_menus','create','2012-09-24 02:37:55'),(327,'product_4',1,'module_menus','create','2012-09-24 02:37:55'),(328,'product_3',1,'module_menus','create','2012-09-24 02:37:55'),(329,'68',1,'module_menu_permissions','add','2012-09-24 02:37:55'),(330,'69',1,'module_menu_permissions','add','2012-09-24 02:37:55'),(331,'70',1,'module_menu_permissions','add','2012-09-24 02:37:55'),(332,'product_4',1,'module_menus','create','2012-09-24 02:42:20'),(333,'10',1,'media_libraries','upload','2012-09-24 04:33:34'),(334,'11',1,'media_libraries','upload','2012-09-24 04:33:52'),(335,'1',1,'product_categories','create','2012-09-24 05:03:03'),(336,'1',1,'product_categories','update','2012-09-24 05:03:10'),(337,'1',1,'product_categories','update','2012-09-24 05:03:15'),(338,'1',1,'product_categories','update','2012-09-24 05:53:41'),(339,'2',1,'product_categories','create','2012-09-24 05:54:22'),(340,'3',1,'product_categories','create','2012-09-24 05:54:45'),(341,'1',1,'product_items','create','2012-09-24 06:45:47'),(342,'1',1,'product_items','update','2012-09-24 06:46:11'),(343,'1',1,'product_items','update','2012-09-24 06:46:22'),(344,'1',1,'product_items','update','2012-09-24 06:46:27'),(345,'2',1,'product_items','create','2012-09-24 07:55:24'),(346,'1',1,'product_accessories','create','2012-09-24 08:52:43'),(347,'2',1,'product_accessories','create','2012-09-24 09:05:12'),(348,'3',1,'product_accessories','create','2012-09-24 09:07:08'),(349,'4',1,'product_accessories','create','2012-09-24 09:10:46'),(350,'5',1,'product_accessories','create','2012-09-24 09:11:27'),(351,'6',1,'product_accessories','create','2012-09-24 09:13:31'),(352,'6',1,'product_accessories','update','2012-09-24 09:14:02'),(353,'7',1,'product_accessories','create','2012-09-24 09:15:21'),(354,'8',1,'product_accessories','create','2012-09-24 09:17:15'),(355,'1',1,'product_accessories','update','2012-09-24 09:23:51'),(356,'1',1,'product_items','update','2012-09-24 09:34:42'),(357,'1',1,'product_downloads','create','2012-09-24 09:53:47'),(358,'2',1,'product_downloads','create','2012-09-24 09:55:32'),(359,'2',1,'product_downloads','update','2012-09-24 09:56:07'),(360,'7',1,'site_menus','update','2012-09-24 09:57:01'),(361,'2',1,'product_items','update','2012-09-25 12:28:02'),(362,'1',1,'product_items','update','2012-09-25 01:35:38'),(363,'1',1,'product_items','update','2012-09-25 01:48:51'),(364,'2',1,'product_items','update','2012-09-25 10:21:27'),(365,'1',1,'product_items','update','2012-09-25 10:22:03'),(366,'4',1,'pages','update','2012-09-28 02:01:33'),(367,'1',1,'news','update','2012-09-28 04:17:42'),(368,'1',1,'news','update','2012-09-28 04:39:25'),(369,'1',1,'news','update','2012-09-28 04:39:38'),(370,'1',1,'news','update','2012-09-28 04:39:59'),(371,'1',1,'news','update','2012-09-28 05:11:01'),(372,'1',1,'news','update','2012-09-28 05:11:18'),(373,'8',1,'news','update','2012-09-28 05:11:43'),(374,'1',1,'events','update','2012-09-28 06:48:33'),(375,'1',1,'events','update','2012-09-28 06:50:26'),(376,'2',1,'contact_categories','update','2012-09-28 06:52:34'),(377,'2',1,'attentions','update','2012-09-28 06:53:04'),(378,'2',1,'attentions','update','2012-09-28 06:53:36'),(379,'3',1,'attentions','create','2012-09-30 09:36:20'),(380,'3',1,'users','register','2012-09-30 10:19:21'),(381,'3',1,'user_details','update','2012-09-30 10:19:21'),(382,'9',1,'user_role_permissions','set','2012-09-30 10:20:09'),(383,'10',1,'user_role_permissions','set','2012-09-30 10:20:09'),(384,'11',1,'user_role_permissions','set','2012-09-30 10:20:10'),(385,'12',1,'user_role_permissions','set','2012-09-30 10:20:10'),(386,'13',1,'user_role_permissions','set','2012-09-30 10:20:12'),(387,'14',1,'user_role_permissions','set','2012-09-30 10:20:15'),(388,'15',1,'user_role_permissions','set','2012-09-30 10:20:16'),(389,'16',1,'user_role_permissions','set','2012-09-30 10:20:17'),(390,'17',1,'user_role_permissions','set','2012-09-30 10:20:17'),(391,'18',1,'user_role_permissions','set','2012-09-30 10:20:46'),(392,'19',1,'user_role_permissions','set','2012-09-30 10:20:46'),(393,'20',1,'user_role_permissions','set','2012-09-30 10:20:46'),(394,'21',1,'user_role_permissions','set','2012-09-30 10:20:47'),(395,'22',1,'user_role_permissions','set','2012-09-30 10:20:49'),(396,'23',1,'user_role_permissions','set','2012-09-30 10:20:51'),(397,'24',1,'user_role_permissions','set','2012-09-30 10:20:51'),(398,'25',1,'user_role_permissions','set','2012-09-30 10:20:52'),(399,'26',1,'user_role_permissions','set','2012-09-30 10:20:52'),(400,'27',1,'user_role_permissions','set','2012-09-30 10:20:52'),(401,'28',1,'user_role_permissions','set','2012-09-30 10:20:54'),(402,'29',1,'user_role_permissions','set','2012-09-30 10:20:54'),(403,'30',1,'user_role_permissions','set','2012-09-30 10:20:56'),(404,'31',1,'user_role_permissions','set','2012-09-30 10:20:57'),(405,'32',1,'user_role_permissions','set','2012-09-30 10:20:57'),(406,'33',1,'user_role_permissions','set','2012-09-30 10:20:58'),(407,'34',1,'user_role_permissions','set','2012-09-30 10:20:59'),(408,'35',1,'user_role_permissions','set','2012-09-30 10:20:59'),(409,'36',1,'user_role_permissions','set','2012-09-30 10:21:01'),(410,'37',1,'user_role_permissions','set','2012-09-30 10:21:03'),(411,'38',1,'user_role_permissions','set','2012-09-30 10:21:04'),(412,'39',1,'user_role_permissions','set','2012-09-30 10:21:04'),(413,'40',1,'user_role_permissions','set','2012-09-30 10:21:05'),(414,'41',1,'user_role_permissions','set','2012-09-30 10:21:05'),(415,'42',1,'user_role_permissions','set','2012-09-30 10:21:06'),(416,'43',1,'user_role_permissions','set','2012-09-30 10:21:07'),(417,'44',1,'user_role_permissions','set','2012-09-30 10:21:07'),(418,'45',1,'user_role_permissions','set','2012-09-30 10:21:09'),(419,'46',1,'user_role_permissions','set','2012-09-30 10:21:09'),(420,'47',1,'user_role_permissions','set','2012-09-30 10:21:10'),(421,'48',1,'user_role_permissions','set','2012-09-30 10:21:10'),(422,'49',1,'user_role_permissions','set','2012-09-30 10:21:11'),(423,'50',1,'user_role_permissions','set','2012-09-30 10:21:12'),(424,'51',1,'user_role_permissions','set','2012-09-30 10:21:12'),(425,'52',1,'user_role_permissions','set','2012-09-30 10:29:50'),(426,'53',1,'user_role_permissions','set','2012-09-30 10:29:50'),(427,'54',1,'user_role_permissions','set','2012-09-30 10:29:51'),(428,'55',1,'user_role_permissions','set','2012-09-30 10:29:51'),(429,'56',1,'user_role_permissions','set','2012-09-30 10:29:52'),(430,'57',1,'user_role_permissions','set','2012-09-30 10:29:52'),(431,'58',1,'user_role_permissions','set','2012-09-30 10:29:53'),(432,'59',1,'user_role_permissions','set','2012-09-30 10:29:54'),(433,'60',1,'user_role_permissions','set','2012-09-30 10:29:54'),(434,'61',1,'user_role_permissions','set','2012-09-30 10:29:55'),(435,'62',1,'user_role_permissions','set','2012-09-30 10:29:55'),(436,'63',1,'user_role_permissions','set','2012-09-30 10:29:56'),(437,'64',1,'user_role_permissions','set','2012-09-30 10:30:01'),(438,'65',1,'user_role_permissions','set','2012-09-30 10:30:01'),(439,'66',1,'user_role_permissions','set','2012-09-30 10:30:02'),(440,'0',1,'user_role_permissions','unset','2012-09-30 10:30:04'),(441,'67',1,'user_role_permissions','allow','2012-09-30 10:30:06'),(442,'68',1,'user_role_permissions','set','2012-09-30 10:30:07'),(443,'0',1,'user_role_permissions','unset','2012-09-30 10:30:12'),(444,'69',1,'user_role_permissions','allow','2012-09-30 10:30:13'),(445,'1',3,'contact_locations','update','2012-09-30 10:47:17'),(446,'2',3,'contact_categories','create','2012-09-30 10:51:56'),(447,'1',3,'contact_categories','update','2012-09-30 10:53:41'),(448,'3',1,'attentions','update','2012-09-30 11:06:04'),(449,'3',1,'attentions','update','2012-09-30 11:06:18'),(450,'3',1,'attentions','update','2012-09-30 11:06:29'),(451,'3',1,'attentions','update','2012-09-30 11:06:39'),(452,'3',3,'attentions','update','2012-09-30 11:18:04'),(453,'1',3,'news','update','2012-09-30 11:35:15'),(454,'1',3,'events','update','2012-09-30 11:36:18'),(455,'1',3,'events','update','2012-09-30 11:36:24'),(456,'1',3,'events','update','2012-09-30 11:36:41'),(457,'1',3,'events','update','2012-09-30 11:36:53'),(458,'1',1,'news','update','2012-09-30 11:37:54'),(459,'8',1,'news','update','2012-09-30 11:37:55'),(460,'1',1,'news','update','2012-09-30 11:39:03'),(461,'8',1,'news','update','2012-09-30 11:39:03'),(462,'1',1,'events','update','2012-09-30 11:39:09'),(463,'3',1,'roles','create','2012-09-30 11:40:48'),(464,'4',3,'roles','create','2012-10-01 12:27:06'),(465,'4',3,'users','register','2012-10-01 12:27:51'),(466,'4',3,'user_details','update','2012-10-01 12:27:51'),(467,'0',1,'user_role_permissions','unset','2012-10-01 12:27:53'),(468,'70',1,'user_role_permissions','allow','2012-10-01 12:27:59'),(469,'4',3,'roles','update','2012-10-01 12:30:16'),(470,'4',3,'roles','update','2012-10-01 12:30:25'),(471,'4',3,'roles','update','2012-10-01 12:31:10'),(472,'0',1,'user_role_permissions','unset','2012-10-01 12:32:53'),(473,'71',1,'user_role_permissions','allow','2012-10-01 12:32:57'),(474,'0',3,'user_role_permissions','unset','2012-10-01 12:41:27'),(475,'72',1,'user_role_permissions','allow','2012-10-01 12:41:27'),(476,'0',3,'user_role_permissions','unset','2012-10-01 12:41:51'),(477,'73',1,'user_role_permissions','allow','2012-10-01 12:41:53'),(478,'74',1,'user_role_permissions','allow','2012-10-01 01:30:10'),(479,'0',1,'user_role_permissions','unset','2012-10-01 01:30:13'),(480,'75',1,'user_role_permissions','allow','2012-10-01 01:30:14'),(481,'17',3,'site_menus','create','2012-10-01 01:34:33'),(482,'17',3,'site_menu_position_applications','create','2012-10-01 01:34:33'),(483,'5',3,'pages','create','2012-10-01 01:34:33'),(484,'5',3,'pages','update','2012-10-01 01:36:43'),(485,'5',3,'pages','update','2012-10-01 01:37:22'),(486,'5',1,'pages','update','2012-10-01 01:38:06'),(487,'5',1,'pages','update','2012-10-01 01:38:17'),(488,'4',1,'pages','update','2012-10-01 01:38:58'),(489,'4',1,'pages','update','2012-10-01 01:39:15'),(490,'5',1,'pages','update','2012-10-01 01:39:16'),(491,'4',1,'pages','update','2012-10-01 01:39:34'),(492,'5',1,'pages','update','2012-10-01 01:39:34'),(493,'12',1,'media_libraries','upload','2012-10-01 01:44:50'),(494,'9',3,'news','create','2012-10-01 01:53:58'),(495,'9',3,'news','update','2012-10-01 01:54:47'),(496,'9',1,'news','update','2012-10-01 01:55:42'),(497,'9',1,'news','update','2012-10-01 01:55:51'),(498,'9',1,'news','update','2012-10-01 01:56:10'),(499,'9',1,'news','update','2012-10-01 01:56:23'),(500,'9',3,'news','delete','2012-10-01 01:56:47'),(501,'2',3,'events','create','2012-10-01 02:03:24'),(502,'1',1,'events','update','2012-10-01 02:21:24'),(503,'1',1,'events','update','2012-10-01 02:23:04'),(504,'1',1,'events','update','2012-10-01 02:23:17'),(505,'1',1,'events','update','2012-10-01 02:23:30'),(506,'3',3,'contact_categories','create','2012-10-01 02:26:02'),(507,'3',1,'contact_categories','update','2012-10-01 02:26:38'),(508,'3',1,'contact_categories','update','2012-10-01 02:26:46'),(509,'3',3,'contact_categories','update','2012-10-01 02:27:15'),(510,'3',1,'contact_categories','update','2012-10-01 02:27:34'),(511,'3',1,'contact_categories','update','2012-10-01 02:27:45'),(512,'1',1,'contact_locations','update','2012-10-01 02:35:17'),(513,'1',1,'contact_locations','update','2012-10-01 02:35:29'),(514,'1',1,'contact_locations','update','2012-10-01 02:39:02'),(515,'1',1,'contact_locations','update','2012-10-01 02:39:31'),(516,'1',3,'contact_locations','update','2012-10-01 02:42:33'),(517,'1',3,'contact_locations','update','2012-10-01 02:42:43'),(518,'1',3,'contact_locations','update','2012-10-01 02:45:28'),(519,'1',3,'contact_locations','update','2012-10-01 02:46:02'),(520,'4',3,'home_sliders','create','2012-10-01 02:47:38'),(521,'4',1,'home_sliders','update','2012-10-01 02:54:50'),(522,'4',1,'home_sliders','update','2012-10-01 02:55:01'),(523,'4',1,'home_sliders','update','2012-10-01 02:55:12'),(524,'4',1,'home_sliders','update','2012-10-01 02:55:21'),(525,'4',3,'home_sliders','update','2012-10-01 02:55:58'),(526,'4',3,'home_sliders','update','2012-10-01 02:56:10'),(527,'4',3,'attentions','create','2012-10-01 02:58:01'),(528,'4',1,'attentions','update','2012-10-01 03:00:36'),(529,'4',1,'attentions','update','2012-10-01 03:00:48'),(530,'4',1,'attentions','update','2012-10-01 03:00:58'),(531,'4',1,'attentions','update','2012-10-01 03:01:07'),(532,'4',3,'attentions','update','2012-10-01 03:01:52'),(533,'4',3,'attentions','update','2012-10-01 03:02:11'),(534,'20',3,'industries','create','2012-10-01 03:08:15'),(535,'20',3,'industries','update','2012-10-01 03:08:28'),(536,'20',1,'industries','update','2012-10-01 03:08:53'),(537,'20',1,'industries','update','2012-10-01 03:09:03'),(538,'20',1,'industries','update','2012-10-01 03:09:27'),(539,'20',1,'industries','update','2012-10-01 03:09:35'),(540,'20',3,'industries','update','2012-10-01 03:09:46'),(541,'5',3,'countries','create','2012-10-01 03:19:58'),(542,'5',1,'countries','update','2012-10-01 03:20:13'),(543,'5',1,'countries','update','2012-10-01 03:20:19'),(544,'5',1,'countries','update','2012-10-01 03:20:28'),(545,'5',1,'countries','update','2012-10-01 03:20:36'),(546,'5',3,'countries','update','2012-10-01 03:20:56'),(547,'4',3,'product_categories','create','2012-10-01 03:30:04'),(548,'4',3,'product_categories','update','2012-10-01 03:30:16'),(549,'4',1,'product_categories','update','2012-10-01 03:30:43'),(550,'4',1,'product_categories','update','2012-10-01 03:30:52'),(551,'4',1,'product_categories','update','2012-10-01 03:31:04'),(552,'4',1,'product_categories','update','2012-10-01 03:31:11'),(553,'4',3,'product_categories','update','2012-10-01 03:31:23'),(554,'5',3,'product_categories','create','2012-10-01 03:31:54'),(555,'3',3,'product_items','create','2012-10-01 03:35:11'),(556,'9',3,'product_accessories','create','2012-10-01 03:38:55'),(557,'9',3,'product_accessories','update','2012-10-01 03:39:33'),(558,'3',3,'users','update','2012-10-01 03:42:21'),(559,'3',3,'user_details','update','2012-10-01 03:42:21'),(560,'3',3,'users','update','2012-10-01 03:42:46'),(561,'3',3,'user_details','update','2012-10-01 03:42:46'),(562,'5',3,'users','register','2012-10-01 03:50:10'),(563,'5',3,'user_details','update','2012-10-01 03:50:10'),(564,'76',3,'user_role_permissions','set','2012-10-01 03:50:28'),(565,'77',3,'user_role_permissions','set','2012-10-01 03:50:29'),(566,'78',3,'user_role_permissions','set','2012-10-01 03:50:30'),(567,'79',3,'user_role_permissions','set','2012-10-01 03:50:30'),(568,'5',1,'users','update','2012-10-01 03:51:09'),(569,'5',1,'users','update','2012-10-01 03:51:21'),(570,'5',1,'users','update','2012-10-01 03:51:35'),(571,'5',1,'users','update','2012-10-01 03:51:45'),(572,'5',3,'users','update','2012-10-01 03:52:08'),(573,'5',3,'user_details','update','2012-10-01 03:52:08'),(574,'5',5,'users','update','2012-10-01 03:52:28'),(575,'5',5,'user_details','update','2012-10-01 03:52:28'),(576,'4',1,'roles','update','2012-10-01 03:53:36'),(577,'4',1,'roles','update','2012-10-01 03:54:17'),(578,'4',1,'roles','update','2012-10-01 03:54:34'),(579,'4',1,'roles','update','2012-10-01 03:54:49'),(580,'4',3,'roles','update','2012-10-01 03:55:07'),(581,'4',3,'roles','delete','2012-10-01 03:55:37'),(582,'5',3,'roles','create','2012-10-01 03:56:32'),(583,'5',3,'roles','delete','2012-10-01 03:56:53'),(584,'6',3,'roles','create','2012-10-01 03:57:17'),(585,'6',3,'users','register','2012-10-01 03:57:52'),(586,'6',3,'user_details','update','2012-10-01 03:57:52'),(587,'80',3,'user_role_permissions','set','2012-10-01 03:58:00'),(588,'81',3,'user_role_permissions','set','2012-10-01 03:58:01'),(589,'82',3,'user_role_permissions','set','2012-10-01 03:58:01'),(590,'83',3,'user_role_permissions','set','2012-10-01 03:58:02'),(591,'84',3,'user_role_permissions','set','2012-10-01 03:58:02'),(592,'85',3,'user_role_permissions','set','2012-10-01 03:58:11'),(593,'3',1,'product_items','update','2012-10-01 04:38:59'),(594,'1',1,'industries','update','2012-10-01 05:45:31'),(595,'1',1,'industries','update','2012-10-01 05:45:39'),(596,'1',1,'product_accessories','update','2012-10-01 05:48:09'),(597,'1',1,'product_accessories','update','2012-10-01 05:48:16'),(598,'2',1,'product_downloads','update','2012-10-01 06:05:52'),(599,'2',1,'product_downloads','update','2012-10-01 06:08:05'),(600,'2',1,'product_downloads','update','2012-10-01 06:08:24'),(601,'75',1,'permissions','create','2012-10-01 06:16:33'),(602,'1',3,'product_items','update','2012-10-01 06:32:03'),(603,'3',3,'product_items','update','2012-10-01 06:32:28'),(604,'3',3,'product_items','update','2012-10-01 06:33:36'),(605,'71',1,'module_menu_permissions','add','2012-10-01 06:46:37'),(606,'72',1,'module_menu_permissions','add','2012-10-01 06:59:25'),(607,'73',1,'module_menu_permissions','add','2012-10-01 06:59:25'),(608,'74',1,'module_menu_permissions','add','2012-10-01 07:06:38'),(609,'1',1,'permissions','create','2012-10-01 07:09:33'),(610,'2',1,'permissions','create','2012-10-01 07:09:33'),(611,'3',1,'permissions','create','2012-10-01 07:09:33'),(612,'4',1,'permissions','create','2012-10-01 07:09:33'),(613,'5',1,'permissions','create','2012-10-01 07:09:33'),(614,'6',1,'permissions','create','2012-10-01 07:09:33'),(615,'7',1,'permissions','create','2012-10-01 07:09:33'),(616,'8',1,'permissions','create','2012-10-01 07:09:33'),(617,'1',1,'user_role_permissions','allow','2012-10-01 07:09:33'),(618,'2',1,'user_role_permissions','allow','2012-10-01 07:09:33'),(619,'3',1,'user_role_permissions','allow','2012-10-01 07:09:33'),(620,'4',1,'user_role_permissions','allow','2012-10-01 07:09:33'),(621,'5',1,'user_role_permissions','allow','2012-10-01 07:09:33'),(622,'6',1,'user_role_permissions','allow','2012-10-01 07:09:34'),(623,'7',1,'user_role_permissions','allow','2012-10-01 07:09:34'),(624,'8',1,'user_role_permissions','allow','2012-10-01 07:09:34'),(625,'9',1,'permissions','create','2012-10-01 07:09:34'),(626,'10',1,'permissions','create','2012-10-01 07:09:34'),(627,'11',1,'permissions','create','2012-10-01 07:09:34'),(628,'12',1,'permissions','create','2012-10-01 07:09:34'),(629,'13',1,'permissions','create','2012-10-01 07:09:34'),(630,'14',1,'permissions','create','2012-10-01 07:09:34'),(631,'15',1,'permissions','create','2012-10-01 07:09:34'),(632,'16',1,'permissions','create','2012-10-01 07:09:34'),(633,'17',1,'permissions','create','2012-10-01 07:09:34'),(634,'18',1,'permissions','create','2012-10-01 07:09:34'),(635,'19',1,'permissions','create','2012-10-01 07:09:34'),(636,'20',1,'permissions','create','2012-10-01 07:09:34'),(637,'21',1,'permissions','create','2012-10-01 07:09:34'),(638,'22',1,'permissions','create','2012-10-01 07:09:34'),(639,'75',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(640,'76',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(641,'77',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(642,'78',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(643,'23',1,'permissions','create','2012-10-01 07:09:34'),(644,'24',1,'permissions','create','2012-10-01 07:09:34'),(645,'25',1,'permissions','create','2012-10-01 07:09:34'),(646,'26',1,'permissions','create','2012-10-01 07:09:34'),(647,'27',1,'permissions','create','2012-10-01 07:09:34'),(648,'28',1,'permissions','create','2012-10-01 07:09:34'),(649,'29',1,'permissions','create','2012-10-01 07:09:34'),(650,'30',1,'permissions','create','2012-10-01 07:09:34'),(651,'79',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(652,'80',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(653,'81',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(654,'82',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(655,'83',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(656,'84',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(657,'85',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(658,'86',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(659,'31',1,'permissions','create','2012-10-01 07:09:34'),(660,'32',1,'permissions','create','2012-10-01 07:09:34'),(661,'33',1,'permissions','create','2012-10-01 07:09:34'),(662,'34',1,'permissions','create','2012-10-01 07:09:34'),(663,'87',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(664,'88',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(665,'89',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(666,'90',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(667,'35',1,'permissions','create','2012-10-01 07:09:34'),(668,'36',1,'permissions','create','2012-10-01 07:09:34'),(669,'37',1,'permissions','create','2012-10-01 07:09:34'),(670,'38',1,'permissions','create','2012-10-01 07:09:34'),(671,'39',1,'permissions','create','2012-10-01 07:09:34'),(672,'40',1,'permissions','create','2012-10-01 07:09:34'),(673,'41',1,'permissions','create','2012-10-01 07:09:34'),(674,'42',1,'permissions','create','2012-10-01 07:09:34'),(675,'43',1,'permissions','create','2012-10-01 07:09:34'),(676,'44',1,'permissions','create','2012-10-01 07:09:34'),(677,'45',1,'permissions','create','2012-10-01 07:09:34'),(678,'46',1,'permissions','create','2012-10-01 07:09:34'),(679,'47',1,'permissions','create','2012-10-01 07:09:34'),(680,'48',1,'permissions','create','2012-10-01 07:09:34'),(681,'49',1,'permissions','create','2012-10-01 07:09:34'),(682,'91',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(683,'92',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(684,'93',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(685,'94',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(686,'95',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(687,'96',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(688,'97',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(689,'98',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(690,'99',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(691,'100',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(692,'101',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(693,'102',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(694,'103',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(695,'104',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(696,'105',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(697,'50',1,'permissions','create','2012-10-01 07:09:34'),(698,'51',1,'permissions','create','2012-10-01 07:09:34'),(699,'52',1,'permissions','create','2012-10-01 07:09:34'),(700,'53',1,'permissions','create','2012-10-01 07:09:34'),(701,'54',1,'permissions','create','2012-10-01 07:09:34'),(702,'55',1,'permissions','create','2012-10-01 07:09:34'),(703,'56',1,'permissions','create','2012-10-01 07:09:34'),(704,'57',1,'permissions','create','2012-10-01 07:09:34'),(705,'58',1,'permissions','create','2012-10-01 07:09:34'),(706,'59',1,'permissions','create','2012-10-01 07:09:34'),(707,'60',1,'permissions','create','2012-10-01 07:09:34'),(708,'61',1,'permissions','create','2012-10-01 07:09:34'),(709,'62',1,'permissions','create','2012-10-01 07:09:34'),(710,'63',1,'permissions','create','2012-10-01 07:09:34'),(711,'64',1,'permissions','create','2012-10-01 07:09:34'),(712,'65',1,'permissions','create','2012-10-01 07:09:34'),(713,'106',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(714,'107',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(715,'108',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(716,'109',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(717,'110',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(718,'111',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(719,'112',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(720,'113',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(721,'114',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(722,'115',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(723,'116',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(724,'117',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(725,'118',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(726,'119',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(727,'120',1,'module_menu_permissions','add','2012-10-01 07:09:34'),(728,'66',1,'permissions','create','2012-10-01 07:20:43'),(729,'0',1,'user_role_permissions','unset','2012-10-01 07:20:43'),(730,'9',1,'user_role_permissions','allow','2012-10-01 07:20:45'),(731,'0',1,'user_role_permissions','unset','2012-10-01 07:21:13'),(732,'10',1,'user_role_permissions','allow','2012-10-01 07:21:14'),(733,'1',1,'permissions','create','2012-10-01 07:22:18'),(734,'2',1,'permissions','create','2012-10-01 07:22:18'),(735,'3',1,'permissions','create','2012-10-01 07:22:18'),(736,'4',1,'permissions','create','2012-10-01 07:22:18'),(737,'5',1,'permissions','create','2012-10-01 07:22:18'),(738,'6',1,'permissions','create','2012-10-01 07:22:18'),(739,'7',1,'permissions','create','2012-10-01 07:22:18'),(740,'8',1,'permissions','create','2012-10-01 07:22:18'),(741,'1',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(742,'2',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(743,'3',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(744,'4',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(745,'5',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(746,'6',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(747,'7',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(748,'8',1,'user_role_permissions','allow','2012-10-01 07:22:18'),(749,'9',1,'permissions','create','2012-10-01 07:22:18'),(750,'10',1,'permissions','create','2012-10-01 07:22:18'),(751,'11',1,'permissions','create','2012-10-01 07:22:18'),(752,'12',1,'permissions','create','2012-10-01 07:22:18'),(753,'13',1,'permissions','create','2012-10-01 07:22:18'),(754,'14',1,'permissions','create','2012-10-01 07:22:18'),(755,'15',1,'permissions','create','2012-10-01 07:22:18'),(756,'16',1,'permissions','create','2012-10-01 07:22:18'),(757,'17',1,'permissions','create','2012-10-01 07:22:18'),(758,'18',1,'permissions','create','2012-10-01 07:22:18'),(759,'19',1,'permissions','create','2012-10-01 07:22:18'),(760,'20',1,'permissions','create','2012-10-01 07:22:18'),(761,'21',1,'permissions','create','2012-10-01 07:22:18'),(762,'22',1,'permissions','create','2012-10-01 07:22:18'),(763,'23',1,'permissions','create','2012-10-01 07:22:18'),(764,'24',1,'permissions','create','2012-10-01 07:22:18'),(765,'25',1,'permissions','create','2012-10-01 07:22:18'),(766,'26',1,'permissions','create','2012-10-01 07:22:18'),(767,'27',1,'permissions','create','2012-10-01 07:22:18'),(768,'28',1,'permissions','create','2012-10-01 07:22:18'),(769,'29',1,'permissions','create','2012-10-01 07:22:18'),(770,'30',1,'permissions','create','2012-10-01 07:22:18'),(771,'31',1,'permissions','create','2012-10-01 07:22:18'),(772,'32',1,'permissions','create','2012-10-01 07:22:18'),(773,'33',1,'permissions','create','2012-10-01 07:22:18'),(774,'34',1,'permissions','create','2012-10-01 07:22:18'),(775,'35',1,'permissions','create','2012-10-01 07:22:18'),(776,'36',1,'permissions','create','2012-10-01 07:22:18'),(777,'37',1,'permissions','create','2012-10-01 07:22:18'),(778,'38',1,'permissions','create','2012-10-01 07:22:18'),(779,'39',1,'permissions','create','2012-10-01 07:22:18'),(780,'40',1,'permissions','create','2012-10-01 07:22:18'),(781,'41',1,'permissions','create','2012-10-01 07:22:18'),(782,'42',1,'permissions','create','2012-10-01 07:22:18'),(783,'43',1,'permissions','create','2012-10-01 07:22:18'),(784,'44',1,'permissions','create','2012-10-01 07:22:18'),(785,'45',1,'permissions','create','2012-10-01 07:22:18'),(786,'46',1,'permissions','create','2012-10-01 07:22:18'),(787,'47',1,'permissions','create','2012-10-01 07:22:18'),(788,'48',1,'permissions','create','2012-10-01 07:22:18'),(789,'49',1,'permissions','create','2012-10-01 07:22:18'),(790,'50',1,'permissions','create','2012-10-01 07:22:18'),(791,'121',1,'module_menu_permissions','add','2012-10-01 07:22:18'),(792,'51',1,'permissions','create','2012-10-01 07:22:18'),(793,'52',1,'permissions','create','2012-10-01 07:22:18'),(794,'53',1,'permissions','create','2012-10-01 07:22:18'),(795,'54',1,'permissions','create','2012-10-01 07:22:18'),(796,'55',1,'permissions','create','2012-10-01 07:22:18'),(797,'56',1,'permissions','create','2012-10-01 07:22:18'),(798,'57',1,'permissions','create','2012-10-01 07:22:18'),(799,'58',1,'permissions','create','2012-10-01 07:22:18'),(800,'59',1,'permissions','create','2012-10-01 07:22:18'),(801,'60',1,'permissions','create','2012-10-01 07:22:18'),(802,'61',1,'permissions','create','2012-10-01 07:22:18'),(803,'62',1,'permissions','create','2012-10-01 07:22:18'),(804,'63',1,'permissions','create','2012-10-01 07:22:18'),(805,'64',1,'permissions','create','2012-10-01 07:22:18'),(806,'65',1,'permissions','create','2012-10-01 07:22:18'),(807,'66',1,'permissions','create','2012-10-01 07:22:18'),(808,'122',1,'module_menu_permissions','add','2012-10-01 07:22:18'),(809,'123',1,'module_menu_permissions','add','2012-10-01 07:22:18'),(810,'124',1,'module_menu_permissions','add','2012-10-01 07:22:18'),(811,'125',1,'module_menu_permissions','add','2012-10-01 07:22:18'),(812,'1',1,'permissions','create','2012-10-01 07:24:54'),(813,'2',1,'permissions','create','2012-10-01 07:24:54'),(814,'3',1,'permissions','create','2012-10-01 07:24:54'),(815,'4',1,'permissions','create','2012-10-01 07:24:54'),(816,'5',1,'permissions','create','2012-10-01 07:24:54'),(817,'6',1,'permissions','create','2012-10-01 07:24:54'),(818,'7',1,'permissions','create','2012-10-01 07:24:54'),(819,'8',1,'permissions','create','2012-10-01 07:24:54'),(820,'1',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(821,'2',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(822,'3',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(823,'4',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(824,'5',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(825,'6',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(826,'7',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(827,'8',1,'user_role_permissions','allow','2012-10-01 07:24:54'),(828,'9',1,'permissions','create','2012-10-01 07:24:54'),(829,'10',1,'permissions','create','2012-10-01 07:24:54'),(830,'11',1,'permissions','create','2012-10-01 07:24:54'),(831,'12',1,'permissions','create','2012-10-01 07:24:54'),(832,'13',1,'permissions','create','2012-10-01 07:24:54'),(833,'14',1,'permissions','create','2012-10-01 07:24:54'),(834,'15',1,'permissions','create','2012-10-01 07:24:54'),(835,'16',1,'permissions','create','2012-10-01 07:24:54'),(836,'17',1,'permissions','create','2012-10-01 07:24:54'),(837,'18',1,'permissions','create','2012-10-01 07:24:54'),(838,'19',1,'permissions','create','2012-10-01 07:24:54'),(839,'20',1,'permissions','create','2012-10-01 07:24:54'),(840,'21',1,'permissions','create','2012-10-01 07:24:54'),(841,'22',1,'permissions','create','2012-10-01 07:24:54'),(842,'23',1,'permissions','create','2012-10-01 07:24:54'),(843,'24',1,'permissions','create','2012-10-01 07:24:54'),(844,'25',1,'permissions','create','2012-10-01 07:24:54'),(845,'26',1,'permissions','create','2012-10-01 07:24:54'),(846,'27',1,'permissions','create','2012-10-01 07:24:54'),(847,'28',1,'permissions','create','2012-10-01 07:24:54'),(848,'29',1,'permissions','create','2012-10-01 07:24:54'),(849,'30',1,'permissions','create','2012-10-01 07:24:54'),(850,'31',1,'permissions','create','2012-10-01 07:24:55'),(851,'32',1,'permissions','create','2012-10-01 07:24:55'),(852,'33',1,'permissions','create','2012-10-01 07:24:55'),(853,'34',1,'permissions','create','2012-10-01 07:24:55'),(854,'35',1,'permissions','create','2012-10-01 07:24:55'),(855,'36',1,'permissions','create','2012-10-01 07:24:55'),(856,'37',1,'permissions','create','2012-10-01 07:24:55'),(857,'38',1,'permissions','create','2012-10-01 07:24:55'),(858,'39',1,'permissions','create','2012-10-01 07:24:55'),(859,'40',1,'permissions','create','2012-10-01 07:24:55'),(860,'41',1,'permissions','create','2012-10-01 07:24:55'),(861,'42',1,'permissions','create','2012-10-01 07:24:55'),(862,'43',1,'permissions','create','2012-10-01 07:24:55'),(863,'44',1,'permissions','create','2012-10-01 07:24:55'),(864,'45',1,'permissions','create','2012-10-01 07:24:55'),(865,'46',1,'permissions','create','2012-10-01 07:24:55'),(866,'47',1,'permissions','create','2012-10-01 07:24:55'),(867,'48',1,'permissions','create','2012-10-01 07:24:55'),(868,'49',1,'permissions','create','2012-10-01 07:24:55'),(869,'50',1,'permissions','create','2012-10-01 07:24:55'),(870,'51',1,'permissions','create','2012-10-01 07:24:55'),(871,'52',1,'permissions','create','2012-10-01 07:24:55'),(872,'53',1,'permissions','create','2012-10-01 07:24:55'),(873,'54',1,'permissions','create','2012-10-01 07:24:55'),(874,'55',1,'permissions','create','2012-10-01 07:24:55'),(875,'56',1,'permissions','create','2012-10-01 07:24:55'),(876,'57',1,'permissions','create','2012-10-01 07:24:55'),(877,'58',1,'permissions','create','2012-10-01 07:24:55'),(878,'59',1,'permissions','create','2012-10-01 07:24:55'),(879,'60',1,'permissions','create','2012-10-01 07:24:55'),(880,'61',1,'permissions','create','2012-10-01 07:24:55'),(881,'62',1,'permissions','create','2012-10-01 07:24:55'),(882,'63',1,'permissions','create','2012-10-01 07:24:55'),(883,'64',1,'permissions','create','2012-10-01 07:24:55'),(884,'65',1,'permissions','create','2012-10-01 07:24:55'),(885,'66',1,'permissions','create','2012-10-01 07:24:55'),(886,'1',1,'permissions','create','2012-10-01 07:27:39'),(887,'2',1,'permissions','create','2012-10-01 07:27:39'),(888,'3',1,'permissions','create','2012-10-01 07:27:39'),(889,'4',1,'permissions','create','2012-10-01 07:27:39'),(890,'5',1,'permissions','create','2012-10-01 07:27:39'),(891,'6',1,'permissions','create','2012-10-01 07:27:39'),(892,'7',1,'permissions','create','2012-10-01 07:27:39'),(893,'8',1,'permissions','create','2012-10-01 07:27:39'),(894,'1',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(895,'2',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(896,'3',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(897,'4',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(898,'5',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(899,'6',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(900,'7',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(901,'8',1,'user_role_permissions','allow','2012-10-01 07:27:39'),(902,'9',1,'permissions','create','2012-10-01 07:27:39'),(903,'10',1,'permissions','create','2012-10-01 07:27:39'),(904,'11',1,'permissions','create','2012-10-01 07:27:39'),(905,'12',1,'permissions','create','2012-10-01 07:27:39'),(906,'13',1,'permissions','create','2012-10-01 07:27:39'),(907,'14',1,'permissions','create','2012-10-01 07:27:39'),(908,'15',1,'permissions','create','2012-10-01 07:27:39'),(909,'16',1,'permissions','create','2012-10-01 07:27:39'),(910,'17',1,'permissions','create','2012-10-01 07:27:39'),(911,'18',1,'permissions','create','2012-10-01 07:27:39'),(912,'19',1,'permissions','create','2012-10-01 07:27:39'),(913,'20',1,'permissions','create','2012-10-01 07:27:39'),(914,'21',1,'permissions','create','2012-10-01 07:27:39'),(915,'22',1,'permissions','create','2012-10-01 07:27:39'),(916,'23',1,'permissions','create','2012-10-01 07:27:39'),(917,'24',1,'permissions','create','2012-10-01 07:27:39'),(918,'25',1,'permissions','create','2012-10-01 07:27:39'),(919,'26',1,'permissions','create','2012-10-01 07:27:39'),(920,'27',1,'permissions','create','2012-10-01 07:27:39'),(921,'28',1,'permissions','create','2012-10-01 07:27:39'),(922,'29',1,'permissions','create','2012-10-01 07:27:39'),(923,'30',1,'permissions','create','2012-10-01 07:27:39'),(924,'31',1,'permissions','create','2012-10-01 07:27:39'),(925,'32',1,'permissions','create','2012-10-01 07:27:39'),(926,'33',1,'permissions','create','2012-10-01 07:27:39'),(927,'34',1,'permissions','create','2012-10-01 07:27:39'),(928,'35',1,'permissions','create','2012-10-01 07:27:39'),(929,'36',1,'permissions','create','2012-10-01 07:27:39'),(930,'37',1,'permissions','create','2012-10-01 07:27:39'),(931,'38',1,'permissions','create','2012-10-01 07:27:39'),(932,'39',1,'permissions','create','2012-10-01 07:27:39'),(933,'40',1,'permissions','create','2012-10-01 07:27:39'),(934,'41',1,'permissions','create','2012-10-01 07:27:39'),(935,'42',1,'permissions','create','2012-10-01 07:27:39'),(936,'43',1,'permissions','create','2012-10-01 07:27:39'),(937,'44',1,'permissions','create','2012-10-01 07:27:39'),(938,'45',1,'permissions','create','2012-10-01 07:27:39'),(939,'46',1,'permissions','create','2012-10-01 07:27:39'),(940,'47',1,'permissions','create','2012-10-01 07:27:39'),(941,'48',1,'permissions','create','2012-10-01 07:27:39'),(942,'49',1,'permissions','create','2012-10-01 07:27:39'),(943,'50',1,'permissions','create','2012-10-01 07:27:39'),(944,'51',1,'permissions','create','2012-10-01 07:27:39'),(945,'52',1,'permissions','create','2012-10-01 07:27:39'),(946,'53',1,'permissions','create','2012-10-01 07:27:39'),(947,'54',1,'permissions','create','2012-10-01 07:27:39'),(948,'55',1,'permissions','create','2012-10-01 07:27:39'),(949,'56',1,'permissions','create','2012-10-01 07:27:39'),(950,'57',1,'permissions','create','2012-10-01 07:27:39'),(951,'58',1,'permissions','create','2012-10-01 07:27:39'),(952,'59',1,'permissions','create','2012-10-01 07:27:39'),(953,'60',1,'permissions','create','2012-10-01 07:27:39'),(954,'61',1,'permissions','create','2012-10-01 07:27:39'),(955,'62',1,'permissions','create','2012-10-01 07:27:39'),(956,'63',1,'permissions','create','2012-10-01 07:27:39'),(957,'64',1,'permissions','create','2012-10-01 07:27:39'),(958,'65',1,'permissions','create','2012-10-01 07:27:39'),(959,'66',1,'permissions','create','2012-10-01 07:27:39'),(960,'9',1,'user_role_permissions','set','2012-10-01 07:29:08'),(961,'10',1,'user_role_permissions','set','2012-10-01 07:29:09'),(962,'11',1,'user_role_permissions','set','2012-10-01 07:29:09'),(963,'12',1,'user_role_permissions','set','2012-10-01 07:29:09'),(964,'13',1,'user_role_permissions','set','2012-10-01 07:29:13'),(965,'14',1,'user_role_permissions','set','2012-10-01 07:29:15'),(966,'15',1,'user_role_permissions','set','2012-10-01 07:29:15'),(967,'16',1,'user_role_permissions','set','2012-10-01 07:29:16'),(968,'17',1,'user_role_permissions','set','2012-10-01 07:29:16'),(969,'18',1,'user_role_permissions','set','2012-10-01 07:29:17'),(970,'19',1,'user_role_permissions','set','2012-10-01 07:29:18'),(971,'20',1,'user_role_permissions','set','2012-10-01 07:29:18'),(972,'21',1,'user_role_permissions','set','2012-10-01 07:29:19'),(973,'22',1,'user_role_permissions','set','2012-10-01 07:29:21'),(974,'23',1,'user_role_permissions','set','2012-10-01 07:29:21'),(975,'24',1,'user_role_permissions','set','2012-10-01 07:29:22'),(976,'25',1,'user_role_permissions','set','2012-10-01 07:29:23'),(977,'26',1,'user_role_permissions','set','2012-10-01 07:29:23'),(978,'27',1,'user_role_permissions','set','2012-10-01 07:29:24'),(979,'28',1,'user_role_permissions','set','2012-10-01 07:29:24'),(980,'29',1,'user_role_permissions','set','2012-10-01 07:29:25'),(981,'1',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(982,'2',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(983,'3',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(984,'4',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(985,'5',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(986,'6',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(987,'7',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(988,'8',1,'user_role_permissions','allow','2012-10-01 07:29:26'),(989,'9',1,'user_role_permissions','set','2012-10-01 07:29:26'),(990,'10',1,'user_role_permissions','set','2012-10-01 07:29:26'),(991,'11',1,'user_role_permissions','set','2012-10-01 07:29:27'),(992,'12',1,'user_role_permissions','set','2012-10-01 07:29:27'),(993,'13',1,'user_role_permissions','set','2012-10-01 07:29:29'),(994,'14',1,'user_role_permissions','set','2012-10-01 07:29:29'),(995,'15',1,'user_role_permissions','set','2012-10-01 07:29:29'),(996,'16',1,'user_role_permissions','set','2012-10-01 07:29:31'),(997,'17',1,'user_role_permissions','set','2012-10-01 07:29:31'),(998,'18',1,'user_role_permissions','set','2012-10-01 07:29:32'),(999,'1',1,'permissions','create','2012-10-01 07:29:33'),(1000,'2',1,'permissions','create','2012-10-01 07:29:33'),(1001,'3',1,'permissions','create','2012-10-01 07:29:33'),(1002,'4',1,'permissions','create','2012-10-01 07:29:33'),(1003,'5',1,'permissions','create','2012-10-01 07:29:33'),(1004,'6',1,'permissions','create','2012-10-01 07:29:33'),(1005,'7',1,'permissions','create','2012-10-01 07:29:33'),(1006,'8',1,'permissions','create','2012-10-01 07:29:34'),(1007,'9',1,'permissions','create','2012-10-01 07:29:34'),(1008,'10',1,'permissions','create','2012-10-01 07:29:34'),(1009,'11',1,'permissions','create','2012-10-01 07:29:34'),(1010,'12',1,'permissions','create','2012-10-01 07:29:34'),(1011,'13',1,'permissions','create','2012-10-01 07:29:34'),(1012,'14',1,'permissions','create','2012-10-01 07:29:34'),(1013,'15',1,'permissions','create','2012-10-01 07:29:34'),(1014,'16',1,'permissions','create','2012-10-01 07:29:34'),(1015,'17',1,'permissions','create','2012-10-01 07:29:34'),(1016,'18',1,'permissions','create','2012-10-01 07:29:34'),(1017,'19',1,'permissions','create','2012-10-01 07:29:34'),(1018,'20',1,'permissions','create','2012-10-01 07:29:34'),(1019,'21',1,'permissions','create','2012-10-01 07:29:34'),(1020,'22',1,'permissions','create','2012-10-01 07:29:34'),(1021,'23',1,'permissions','create','2012-10-01 07:29:34'),(1022,'24',1,'permissions','create','2012-10-01 07:29:34'),(1023,'25',1,'permissions','create','2012-10-01 07:29:34'),(1024,'26',1,'permissions','create','2012-10-01 07:29:34'),(1025,'27',1,'permissions','create','2012-10-01 07:29:34'),(1026,'28',1,'permissions','create','2012-10-01 07:29:34'),(1027,'29',1,'permissions','create','2012-10-01 07:29:34'),(1028,'30',1,'permissions','create','2012-10-01 07:29:34'),(1029,'31',1,'permissions','create','2012-10-01 07:29:34'),(1030,'32',1,'permissions','create','2012-10-01 07:29:34'),(1031,'33',1,'permissions','create','2012-10-01 07:29:34'),(1032,'34',1,'permissions','create','2012-10-01 07:29:34'),(1033,'35',1,'permissions','create','2012-10-01 07:29:34'),(1034,'36',1,'permissions','create','2012-10-01 07:29:34'),(1035,'37',1,'permissions','create','2012-10-01 07:29:34'),(1036,'38',1,'permissions','create','2012-10-01 07:29:34'),(1037,'39',1,'permissions','create','2012-10-01 07:29:34'),(1038,'40',1,'permissions','create','2012-10-01 07:29:34'),(1039,'41',1,'permissions','create','2012-10-01 07:29:34'),(1040,'42',1,'permissions','create','2012-10-01 07:29:34'),(1041,'43',1,'permissions','create','2012-10-01 07:29:34'),(1042,'44',1,'permissions','create','2012-10-01 07:29:34'),(1043,'45',1,'permissions','create','2012-10-01 07:29:34'),(1044,'46',1,'permissions','create','2012-10-01 07:29:34'),(1045,'47',1,'permissions','create','2012-10-01 07:29:34'),(1046,'48',1,'permissions','create','2012-10-01 07:29:34'),(1047,'49',1,'permissions','create','2012-10-01 07:29:34'),(1048,'50',1,'permissions','create','2012-10-01 07:29:34'),(1049,'51',1,'permissions','create','2012-10-01 07:29:34'),(1050,'52',1,'permissions','create','2012-10-01 07:29:34'),(1051,'53',1,'permissions','create','2012-10-01 07:29:34'),(1052,'54',1,'permissions','create','2012-10-01 07:29:34'),(1053,'55',1,'permissions','create','2012-10-01 07:29:34'),(1054,'56',1,'permissions','create','2012-10-01 07:29:34'),(1055,'57',1,'permissions','create','2012-10-01 07:29:34'),(1056,'58',1,'permissions','create','2012-10-01 07:29:34'),(1057,'59',1,'permissions','create','2012-10-01 07:29:34'),(1058,'60',1,'permissions','create','2012-10-01 07:29:34'),(1059,'61',1,'permissions','create','2012-10-01 07:29:34'),(1060,'62',1,'permissions','create','2012-10-01 07:29:34'),(1061,'63',1,'permissions','create','2012-10-01 07:29:34'),(1062,'64',1,'permissions','create','2012-10-01 07:29:34'),(1063,'19',1,'user_role_permissions','set','2012-10-01 07:29:34'),(1064,'20',1,'user_role_permissions','set','2012-10-01 07:29:34'),(1065,'21',1,'user_role_permissions','set','2012-10-01 07:29:34'),(1066,'22',1,'user_role_permissions','set','2012-10-01 07:29:35'),(1067,'23',1,'user_role_permissions','set','2012-10-01 07:29:35'),(1068,'24',1,'user_role_permissions','set','2012-10-01 07:29:36'),(1069,'25',1,'user_role_permissions','set','2012-10-01 07:29:36'),(1070,'26',1,'user_role_permissions','set','2012-10-01 07:29:37'),(1071,'27',1,'user_role_permissions','set','2012-10-01 07:29:38'),(1072,'28',1,'user_role_permissions','set','2012-10-01 07:29:40'),(1073,'29',1,'user_role_permissions','set','2012-10-01 07:29:41'),(1074,'30',1,'user_role_permissions','set','2012-10-01 07:29:43'),(1075,'31',1,'user_role_permissions','set','2012-10-01 07:29:44'),(1076,'32',1,'user_role_permissions','set','2012-10-01 07:29:44'),(1077,'33',1,'user_role_permissions','set','2012-10-01 07:29:45'),(1078,'34',1,'user_role_permissions','set','2012-10-01 07:29:46'),(1079,'35',1,'user_role_permissions','set','2012-10-01 07:29:46'),(1080,'36',1,'user_role_permissions','set','2012-10-01 07:29:47'),(1081,'37',1,'user_role_permissions','set','2012-10-01 07:29:48'),(1082,'38',1,'user_role_permissions','set','2012-10-01 07:29:49'),(1083,'39',1,'user_role_permissions','set','2012-10-01 07:29:50'),(1084,'40',1,'user_role_permissions','set','2012-10-01 07:29:52'),(1085,'41',1,'user_role_permissions','set','2012-10-01 07:29:52'),(1086,'42',1,'user_role_permissions','set','2012-10-01 07:29:53'),(1087,'65',1,'permissions','create','2012-10-01 07:29:55'),(1088,'66',1,'permissions','create','2012-10-01 07:29:55'),(1089,'0',1,'user_role_permissions','unset','2012-10-01 07:30:29'),(1090,'43',1,'user_role_permissions','allow','2012-10-01 07:30:30'),(1091,'44',1,'user_role_permissions','set','2012-10-01 07:30:30'),(1092,'45',1,'user_role_permissions','set','2012-10-01 07:31:30'),(1093,'46',1,'user_role_permissions','set','2012-10-01 07:31:32'),(1094,'47',1,'user_role_permissions','set','2012-10-01 07:31:32'),(1095,'48',1,'user_role_permissions','set','2012-10-01 07:31:34'),(1096,'49',1,'user_role_permissions','set','2012-10-01 07:31:36'),(1097,'50',1,'user_role_permissions','set','2012-10-01 07:31:37'),(1098,'51',1,'user_role_permissions','set','2012-10-01 07:31:37'),(1099,'52',1,'user_role_permissions','set','2012-10-01 07:31:38'),(1100,'53',1,'user_role_permissions','set','2012-10-01 07:31:39'),(1101,'54',1,'user_role_permissions','set','2012-10-01 07:31:42'),(1102,'55',1,'user_role_permissions','set','2012-10-01 07:31:43'),(1103,'56',1,'user_role_permissions','set','2012-10-01 07:31:43'),(1104,'57',1,'user_role_permissions','set','2012-10-01 07:31:44'),(1105,'58',1,'user_role_permissions','set','2012-10-01 07:31:45'),(1106,'59',1,'user_role_permissions','set','2012-10-01 07:31:45'),(1107,'60',1,'user_role_permissions','set','2012-10-01 07:31:46'),(1108,'61',1,'user_role_permissions','set','2012-10-01 07:31:47'),(1109,'62',1,'user_role_permissions','set','2012-10-01 07:31:48'),(1110,'63',1,'user_role_permissions','set','2012-10-01 07:31:49'),(1111,'64',1,'user_role_permissions','set','2012-10-01 07:31:50'),(1112,'65',1,'user_role_permissions','set','2012-10-01 07:31:51'),(1113,'1',1,'permissions','create','2012-10-01 07:39:42'),(1114,'2',1,'permissions','create','2012-10-01 07:39:42'),(1115,'3',1,'permissions','create','2012-10-01 07:39:42'),(1116,'4',1,'permissions','create','2012-10-01 07:39:42'),(1117,'5',1,'permissions','create','2012-10-01 07:39:42'),(1118,'6',1,'permissions','create','2012-10-01 07:39:42'),(1119,'7',1,'permissions','create','2012-10-01 07:39:42'),(1120,'126',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1121,'127',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1122,'1',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1123,'2',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1124,'3',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1125,'4',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1126,'5',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1127,'6',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1128,'7',1,'user_role_permissions','allow','2012-10-01 07:39:42'),(1129,'8',1,'permissions','create','2012-10-01 07:39:42'),(1130,'9',1,'permissions','create','2012-10-01 07:39:42'),(1131,'10',1,'permissions','create','2012-10-01 07:39:42'),(1132,'11',1,'permissions','create','2012-10-01 07:39:42'),(1133,'128',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1134,'12',1,'permissions','create','2012-10-01 07:39:42'),(1135,'13',1,'permissions','create','2012-10-01 07:39:42'),(1136,'129',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1137,'130',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1138,'14',1,'permissions','create','2012-10-01 07:39:42'),(1139,'15',1,'permissions','create','2012-10-01 07:39:42'),(1140,'16',1,'permissions','create','2012-10-01 07:39:42'),(1141,'17',1,'permissions','create','2012-10-01 07:39:42'),(1142,'131',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1143,'18',1,'permissions','create','2012-10-01 07:39:42'),(1144,'19',1,'permissions','create','2012-10-01 07:39:42'),(1145,'20',1,'permissions','create','2012-10-01 07:39:42'),(1146,'21',1,'permissions','create','2012-10-01 07:39:42'),(1147,'132',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1148,'22',1,'permissions','create','2012-10-01 07:39:42'),(1149,'23',1,'permissions','create','2012-10-01 07:39:42'),(1150,'24',1,'permissions','create','2012-10-01 07:39:42'),(1151,'25',1,'permissions','create','2012-10-01 07:39:42'),(1152,'26',1,'permissions','create','2012-10-01 07:39:42'),(1153,'27',1,'permissions','create','2012-10-01 07:39:42'),(1154,'28',1,'permissions','create','2012-10-01 07:39:42'),(1155,'29',1,'permissions','create','2012-10-01 07:39:42'),(1156,'133',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1157,'134',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1158,'30',1,'permissions','create','2012-10-01 07:39:42'),(1159,'31',1,'permissions','create','2012-10-01 07:39:42'),(1160,'32',1,'permissions','create','2012-10-01 07:39:42'),(1161,'33',1,'permissions','create','2012-10-01 07:39:42'),(1162,'135',1,'module_menu_permissions','add','2012-10-01 07:39:42'),(1163,'34',1,'permissions','create','2012-10-01 07:39:42'),(1164,'35',1,'permissions','create','2012-10-01 07:39:43'),(1165,'36',1,'permissions','create','2012-10-01 07:39:43'),(1166,'37',1,'permissions','create','2012-10-01 07:39:43'),(1167,'38',1,'permissions','create','2012-10-01 07:39:43'),(1168,'39',1,'permissions','create','2012-10-01 07:39:43'),(1169,'40',1,'permissions','create','2012-10-01 07:39:43'),(1170,'41',1,'permissions','create','2012-10-01 07:39:43'),(1171,'42',1,'permissions','create','2012-10-01 07:39:43'),(1172,'43',1,'permissions','create','2012-10-01 07:39:43'),(1173,'44',1,'permissions','create','2012-10-01 07:39:43'),(1174,'45',1,'permissions','create','2012-10-01 07:39:43'),(1175,'46',1,'permissions','create','2012-10-01 07:39:43'),(1176,'47',1,'permissions','create','2012-10-01 07:39:43'),(1177,'48',1,'permissions','create','2012-10-01 07:39:43'),(1178,'49',1,'permissions','create','2012-10-01 07:39:43'),(1179,'136',1,'module_menu_permissions','add','2012-10-01 07:39:43'),(1180,'137',1,'module_menu_permissions','add','2012-10-01 07:39:43'),(1181,'138',1,'module_menu_permissions','add','2012-10-01 07:39:43'),(1182,'139',1,'module_menu_permissions','add','2012-10-01 07:39:43'),(1183,'50',1,'permissions','create','2012-10-01 07:39:43'),(1184,'51',1,'permissions','create','2012-10-01 07:39:43'),(1185,'52',1,'permissions','create','2012-10-01 07:39:43'),(1186,'53',1,'permissions','create','2012-10-01 07:39:43'),(1187,'54',1,'permissions','create','2012-10-01 07:39:43'),(1188,'55',1,'permissions','create','2012-10-01 07:39:43'),(1189,'56',1,'permissions','create','2012-10-01 07:39:43'),(1190,'57',1,'permissions','create','2012-10-01 07:39:43'),(1191,'58',1,'permissions','create','2012-10-01 07:39:43'),(1192,'59',1,'permissions','create','2012-10-01 07:39:43'),(1193,'60',1,'permissions','create','2012-10-01 07:39:43'),(1194,'61',1,'permissions','create','2012-10-01 07:39:43'),(1195,'62',1,'permissions','create','2012-10-01 07:39:43'),(1196,'63',1,'permissions','create','2012-10-01 07:39:43'),(1197,'64',1,'permissions','create','2012-10-01 07:39:43'),(1198,'65',1,'permissions','create','2012-10-01 07:39:43'),(1199,'8',1,'user_role_permissions','set','2012-10-01 07:42:56'),(1200,'9',1,'user_role_permissions','set','2012-10-01 07:42:58'),(1201,'10',1,'user_role_permissions','set','2012-10-01 07:42:58'),(1202,'11',1,'user_role_permissions','set','2012-10-01 07:43:00'),(1203,'12',1,'user_role_permissions','set','2012-10-01 07:43:00'),(1204,'13',1,'user_role_permissions','set','2012-10-01 07:43:12'),(1205,'14',1,'user_role_permissions','set','2012-10-01 07:43:12'),(1206,'15',1,'user_role_permissions','set','2012-10-01 07:43:13'),(1207,'16',1,'user_role_permissions','set','2012-10-01 07:43:13'),(1208,'17',1,'user_role_permissions','set','2012-10-01 07:43:18'),(1209,'18',1,'user_role_permissions','set','2012-10-01 07:43:19'),(1210,'19',1,'user_role_permissions','set','2012-10-01 07:43:20'),(1211,'20',1,'user_role_permissions','set','2012-10-01 07:43:20'),(1212,'21',1,'user_role_permissions','set','2012-10-01 07:43:24'),(1213,'22',1,'user_role_permissions','set','2012-10-01 07:43:24'),(1214,'23',1,'user_role_permissions','set','2012-10-01 07:43:25'),(1215,'24',1,'user_role_permissions','set','2012-10-01 07:43:26'),(1216,'25',1,'user_role_permissions','set','2012-10-01 07:43:27'),(1217,'26',1,'user_role_permissions','set','2012-10-01 07:43:28'),(1218,'27',1,'user_role_permissions','set','2012-10-01 07:43:29'),(1219,'28',1,'user_role_permissions','set','2012-10-01 07:43:29'),(1220,'29',1,'user_role_permissions','set','2012-10-01 07:43:31'),(1221,'30',1,'user_role_permissions','set','2012-10-01 07:43:32'),(1222,'31',1,'user_role_permissions','set','2012-10-01 07:43:33'),(1223,'32',1,'user_role_permissions','set','2012-10-01 07:43:34'),(1224,'33',1,'user_role_permissions','set','2012-10-01 07:43:36'),(1225,'34',1,'user_role_permissions','set','2012-10-01 07:43:37'),(1226,'35',1,'user_role_permissions','set','2012-10-01 07:43:38'),(1227,'36',1,'user_role_permissions','set','2012-10-01 07:43:39'),(1228,'37',1,'user_role_permissions','set','2012-10-01 07:43:39'),(1229,'38',1,'user_role_permissions','set','2012-10-01 07:43:40'),(1230,'39',1,'user_role_permissions','set','2012-10-01 07:43:41'),(1231,'40',1,'user_role_permissions','set','2012-10-01 07:43:42'),(1232,'41',1,'user_role_permissions','set','2012-10-01 07:43:43'),(1233,'42',1,'user_role_permissions','set','2012-10-01 07:43:44'),(1234,'43',1,'user_role_permissions','set','2012-10-01 07:43:44'),(1235,'44',1,'user_role_permissions','set','2012-10-01 07:43:45'),(1236,'45',1,'user_role_permissions','set','2012-10-01 07:43:45'),(1237,'46',1,'user_role_permissions','set','2012-10-01 07:43:47'),(1238,'47',1,'user_role_permissions','set','2012-10-01 07:43:47'),(1239,'48',1,'user_role_permissions','set','2012-10-01 07:43:49'),(1240,'49',1,'user_role_permissions','set','2012-10-01 07:43:50'),(1241,'50',1,'user_role_permissions','set','2012-10-01 07:43:51'),(1242,'51',1,'user_role_permissions','set','2012-10-01 07:43:51'),(1243,'52',1,'user_role_permissions','set','2012-10-01 07:43:52'),(1244,'53',1,'user_role_permissions','set','2012-10-01 07:43:53'),(1245,'54',1,'user_role_permissions','set','2012-10-01 07:43:53'),(1246,'55',1,'user_role_permissions','set','2012-10-01 07:43:54'),(1247,'56',1,'user_role_permissions','set','2012-10-01 07:43:54'),(1248,'57',1,'user_role_permissions','set','2012-10-01 07:43:55'),(1249,'58',1,'user_role_permissions','set','2012-10-01 07:43:57'),(1250,'59',1,'user_role_permissions','set','2012-10-01 07:43:57'),(1251,'60',1,'user_role_permissions','set','2012-10-01 07:43:58'),(1252,'61',1,'user_role_permissions','set','2012-10-01 07:43:58'),(1253,'62',1,'user_role_permissions','set','2012-10-01 07:43:59'),(1254,'63',1,'user_role_permissions','set','2012-10-01 07:44:00'),(1255,'64',1,'user_role_permissions','set','2012-10-01 07:44:00'),(1256,'65',1,'user_role_permissions','set','2012-10-01 07:44:04'),(1257,'3',1,'attentions','update','2012-10-02 01:52:17'),(1258,'4',1,'product_items','create','2012-10-02 05:17:17'),(1259,'1',1,'permissions','create','2012-10-02 06:49:43'),(1260,'2',1,'permissions','create','2012-10-02 06:49:43'),(1261,'3',1,'permissions','create','2012-10-02 06:49:43'),(1262,'4',1,'permissions','create','2012-10-02 06:49:43'),(1263,'5',1,'permissions','create','2012-10-02 06:49:43'),(1264,'6',1,'permissions','create','2012-10-02 06:49:43'),(1265,'140',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1266,'1',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1267,'2',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1268,'3',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1269,'4',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1270,'5',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1271,'6',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1272,'7',1,'user_role_permissions','allow','2012-10-02 06:49:44'),(1273,'7',1,'permissions','create','2012-10-02 06:49:44'),(1274,'8',1,'permissions','create','2012-10-02 06:49:44'),(1275,'9',1,'permissions','create','2012-10-02 06:49:44'),(1276,'10',1,'permissions','create','2012-10-02 06:49:44'),(1277,'141',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1278,'11',1,'permissions','create','2012-10-02 06:49:44'),(1279,'12',1,'permissions','create','2012-10-02 06:49:44'),(1280,'142',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1281,'143',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1282,'13',1,'permissions','create','2012-10-02 06:49:44'),(1283,'14',1,'permissions','create','2012-10-02 06:49:44'),(1284,'15',1,'permissions','create','2012-10-02 06:49:44'),(1285,'16',1,'permissions','create','2012-10-02 06:49:44'),(1286,'144',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1287,'17',1,'permissions','create','2012-10-02 06:49:44'),(1288,'18',1,'permissions','create','2012-10-02 06:49:44'),(1289,'19',1,'permissions','create','2012-10-02 06:49:44'),(1290,'20',1,'permissions','create','2012-10-02 06:49:44'),(1291,'145',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1292,'21',1,'permissions','create','2012-10-02 06:49:44'),(1293,'22',1,'permissions','create','2012-10-02 06:49:44'),(1294,'23',1,'permissions','create','2012-10-02 06:49:44'),(1295,'24',1,'permissions','create','2012-10-02 06:49:44'),(1296,'25',1,'permissions','create','2012-10-02 06:49:44'),(1297,'26',1,'permissions','create','2012-10-02 06:49:44'),(1298,'27',1,'permissions','create','2012-10-02 06:49:44'),(1299,'28',1,'permissions','create','2012-10-02 06:49:44'),(1300,'146',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1301,'147',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1302,'29',1,'permissions','create','2012-10-02 06:49:44'),(1303,'30',1,'permissions','create','2012-10-02 06:49:44'),(1304,'31',1,'permissions','create','2012-10-02 06:49:44'),(1305,'32',1,'permissions','create','2012-10-02 06:49:44'),(1306,'148',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1307,'33',1,'permissions','create','2012-10-02 06:49:44'),(1308,'34',1,'permissions','create','2012-10-02 06:49:44'),(1309,'35',1,'permissions','create','2012-10-02 06:49:44'),(1310,'36',1,'permissions','create','2012-10-02 06:49:44'),(1311,'37',1,'permissions','create','2012-10-02 06:49:44'),(1312,'38',1,'permissions','create','2012-10-02 06:49:44'),(1313,'39',1,'permissions','create','2012-10-02 06:49:44'),(1314,'40',1,'permissions','create','2012-10-02 06:49:44'),(1315,'41',1,'permissions','create','2012-10-02 06:49:44'),(1316,'42',1,'permissions','create','2012-10-02 06:49:44'),(1317,'43',1,'permissions','create','2012-10-02 06:49:44'),(1318,'44',1,'permissions','create','2012-10-02 06:49:44'),(1319,'45',1,'permissions','create','2012-10-02 06:49:44'),(1320,'46',1,'permissions','create','2012-10-02 06:49:44'),(1321,'47',1,'permissions','create','2012-10-02 06:49:44'),(1322,'48',1,'permissions','create','2012-10-02 06:49:44'),(1323,'149',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1324,'150',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1325,'151',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1326,'152',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1327,'49',1,'permissions','create','2012-10-02 06:49:44'),(1328,'50',1,'permissions','create','2012-10-02 06:49:44'),(1329,'51',1,'permissions','create','2012-10-02 06:49:44'),(1330,'52',1,'permissions','create','2012-10-02 06:49:44'),(1331,'53',1,'permissions','create','2012-10-02 06:49:44'),(1332,'54',1,'permissions','create','2012-10-02 06:49:44'),(1333,'55',1,'permissions','create','2012-10-02 06:49:44'),(1334,'56',1,'permissions','create','2012-10-02 06:49:44'),(1335,'57',1,'permissions','create','2012-10-02 06:49:44'),(1336,'58',1,'permissions','create','2012-10-02 06:49:44'),(1337,'59',1,'permissions','create','2012-10-02 06:49:44'),(1338,'60',1,'permissions','create','2012-10-02 06:49:44'),(1339,'61',1,'permissions','create','2012-10-02 06:49:44'),(1340,'62',1,'permissions','create','2012-10-02 06:49:44'),(1341,'63',1,'permissions','create','2012-10-02 06:49:44'),(1342,'64',1,'permissions','create','2012-10-02 06:49:44'),(1343,'153',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1344,'154',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1345,'155',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1346,'156',1,'module_menu_permissions','add','2012-10-02 06:49:44'),(1347,'8',1,'user_role_permissions','set','2012-10-02 06:54:34'),(1348,'9',1,'user_role_permissions','set','2012-10-02 06:54:37'),(1349,'10',1,'user_role_permissions','set','2012-10-02 06:54:39'),(1350,'11',1,'user_role_permissions','set','2012-10-02 06:54:41'),(1351,'12',1,'user_role_permissions','set','2012-10-02 06:54:43'),(1352,'13',1,'user_role_permissions','set','2012-10-02 06:54:43'),(1353,'14',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1354,'15',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1355,'16',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1356,'17',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1357,'18',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1358,'19',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1359,'20',1,'user_role_permissions','set','2012-10-02 06:54:44'),(1360,'21',1,'user_role_permissions','set','2012-10-02 07:04:36'),(1361,'1',1,'permissions','create','2012-10-02 07:08:28'),(1362,'2',1,'permissions','create','2012-10-02 07:08:28'),(1363,'3',1,'permissions','create','2012-10-02 07:08:28'),(1364,'4',1,'permissions','create','2012-10-02 07:08:28'),(1365,'5',1,'permissions','create','2012-10-02 07:08:28'),(1366,'6',1,'permissions','create','2012-10-02 07:08:28'),(1367,'1',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1368,'2',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1369,'3',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1370,'4',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1371,'5',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1372,'6',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1373,'7',1,'user_role_permissions','allow','2012-10-02 07:08:28'),(1374,'7',1,'permissions','create','2012-10-02 07:08:28'),(1375,'8',1,'permissions','create','2012-10-02 07:08:28'),(1376,'9',1,'permissions','create','2012-10-02 07:08:28'),(1377,'10',1,'permissions','create','2012-10-02 07:08:28'),(1378,'11',1,'permissions','create','2012-10-02 07:08:28'),(1379,'12',1,'permissions','create','2012-10-02 07:08:28'),(1380,'13',1,'permissions','create','2012-10-02 07:08:28'),(1381,'14',1,'permissions','create','2012-10-02 07:08:28'),(1382,'15',1,'permissions','create','2012-10-02 07:08:28'),(1383,'16',1,'permissions','create','2012-10-02 07:08:28'),(1384,'17',1,'permissions','create','2012-10-02 07:08:28'),(1385,'18',1,'permissions','create','2012-10-02 07:08:28'),(1386,'19',1,'permissions','create','2012-10-02 07:08:28'),(1387,'20',1,'permissions','create','2012-10-02 07:08:28'),(1388,'21',1,'permissions','create','2012-10-02 07:08:28'),(1389,'22',1,'permissions','create','2012-10-02 07:08:28'),(1390,'23',1,'permissions','create','2012-10-02 07:08:28'),(1391,'24',1,'permissions','create','2012-10-02 07:08:28'),(1392,'25',1,'permissions','create','2012-10-02 07:08:28'),(1393,'26',1,'permissions','create','2012-10-02 07:08:28'),(1394,'27',1,'permissions','create','2012-10-02 07:08:28'),(1395,'28',1,'permissions','create','2012-10-02 07:08:28'),(1396,'29',1,'permissions','create','2012-10-02 07:08:28'),(1397,'30',1,'permissions','create','2012-10-02 07:08:28'),(1398,'31',1,'permissions','create','2012-10-02 07:08:28'),(1399,'32',1,'permissions','create','2012-10-02 07:08:28'),(1400,'33',1,'permissions','create','2012-10-02 07:08:28'),(1401,'34',1,'permissions','create','2012-10-02 07:08:28'),(1402,'35',1,'permissions','create','2012-10-02 07:08:28'),(1403,'36',1,'permissions','create','2012-10-02 07:08:28'),(1404,'37',1,'permissions','create','2012-10-02 07:08:28'),(1405,'38',1,'permissions','create','2012-10-02 07:08:28'),(1406,'39',1,'permissions','create','2012-10-02 07:08:28'),(1407,'40',1,'permissions','create','2012-10-02 07:08:28'),(1408,'41',1,'permissions','create','2012-10-02 07:08:28'),(1409,'42',1,'permissions','create','2012-10-02 07:08:28'),(1410,'43',1,'permissions','create','2012-10-02 07:08:28'),(1411,'44',1,'permissions','create','2012-10-02 07:08:28'),(1412,'45',1,'permissions','create','2012-10-02 07:08:28'),(1413,'46',1,'permissions','create','2012-10-02 07:08:28'),(1414,'47',1,'permissions','create','2012-10-02 07:08:28'),(1415,'48',1,'permissions','create','2012-10-02 07:08:28'),(1416,'49',1,'permissions','create','2012-10-02 07:08:28'),(1417,'50',1,'permissions','create','2012-10-02 07:08:28'),(1418,'51',1,'permissions','create','2012-10-02 07:08:28'),(1419,'52',1,'permissions','create','2012-10-02 07:08:28'),(1420,'53',1,'permissions','create','2012-10-02 07:08:28'),(1421,'54',1,'permissions','create','2012-10-02 07:08:28'),(1422,'55',1,'permissions','create','2012-10-02 07:08:28'),(1423,'56',1,'permissions','create','2012-10-02 07:08:28'),(1424,'57',1,'permissions','create','2012-10-02 07:08:28'),(1425,'58',1,'permissions','create','2012-10-02 07:08:28'),(1426,'59',1,'permissions','create','2012-10-02 07:08:28'),(1427,'60',1,'permissions','create','2012-10-02 07:08:28'),(1428,'61',1,'permissions','create','2012-10-02 07:08:28'),(1429,'62',1,'permissions','create','2012-10-02 07:08:28'),(1430,'63',1,'permissions','create','2012-10-02 07:08:28'),(1431,'157',1,'module_menu_permissions','add','2012-10-02 07:08:28'),(1432,'158',1,'module_menu_permissions','add','2012-10-02 07:08:28'),(1433,'159',1,'module_menu_permissions','add','2012-10-02 07:08:28'),(1434,'160',1,'module_menu_permissions','add','2012-10-02 07:08:28'),(1435,'8',1,'user_role_permissions','set','2012-10-02 07:09:59'),(1436,'9',1,'user_role_permissions','set','2012-10-02 07:10:00'),(1437,'10',1,'user_role_permissions','set','2012-10-02 07:10:00'),(1438,'11',1,'user_role_permissions','set','2012-10-02 07:10:01'),(1439,'12',1,'user_role_permissions','set','2012-10-02 07:10:06'),(1440,'13',1,'user_role_permissions','set','2012-10-02 07:10:08'),(1441,'14',1,'user_role_permissions','set','2012-10-02 07:10:09'),(1442,'15',1,'user_role_permissions','set','2012-10-02 07:10:09'),(1443,'16',1,'user_role_permissions','set','2012-10-02 07:10:12'),(1444,'17',1,'user_role_permissions','set','2012-10-02 07:10:14'),(1445,'18',1,'user_role_permissions','set','2012-10-02 07:10:15'),(1446,'19',1,'user_role_permissions','set','2012-10-02 07:10:15'),(1447,'20',1,'user_role_permissions','set','2012-10-02 07:10:17'),(1448,'21',1,'user_role_permissions','set','2012-10-02 07:10:18'),(1449,'22',1,'user_role_permissions','set','2012-10-02 07:10:19'),(1450,'23',1,'user_role_permissions','set','2012-10-02 07:10:22'),(1451,'24',1,'user_role_permissions','set','2012-10-02 07:10:23'),(1452,'25',1,'user_role_permissions','set','2012-10-02 07:10:23'),(1453,'26',1,'user_role_permissions','set','2012-10-02 07:10:24'),(1454,'27',1,'user_role_permissions','set','2012-10-02 07:10:24'),(1455,'28',1,'user_role_permissions','set','2012-10-02 07:10:25'),(1456,'29',1,'user_role_permissions','set','2012-10-02 07:10:27'),(1457,'30',1,'user_role_permissions','set','2012-10-02 07:10:28'),(1458,'31',1,'user_role_permissions','set','2012-10-02 07:10:29'),(1459,'32',1,'user_role_permissions','set','2012-10-02 07:10:30'),(1460,'33',1,'user_role_permissions','set','2012-10-02 07:10:31'),(1461,'34',1,'user_role_permissions','set','2012-10-02 07:10:32'),(1462,'35',1,'user_role_permissions','set','2012-10-02 07:10:33'),(1463,'36',1,'user_role_permissions','set','2012-10-02 07:10:33'),(1464,'37',1,'user_role_permissions','set','2012-10-02 07:10:34'),(1465,'38',1,'user_role_permissions','set','2012-10-02 07:10:34'),(1466,'39',1,'user_role_permissions','set','2012-10-02 07:10:35'),(1467,'40',1,'user_role_permissions','set','2012-10-02 07:10:37'),(1468,'41',1,'user_role_permissions','set','2012-10-02 07:10:37'),(1469,'42',1,'user_role_permissions','set','2012-10-02 07:10:38'),(1470,'43',1,'user_role_permissions','set','2012-10-02 07:10:38'),(1471,'44',1,'user_role_permissions','set','2012-10-02 07:10:39'),(1472,'45',1,'user_role_permissions','set','2012-10-02 07:10:40'),(1473,'46',1,'user_role_permissions','set','2012-10-02 07:10:40'),(1474,'47',1,'user_role_permissions','set','2012-10-02 07:10:41'),(1475,'48',1,'user_role_permissions','set','2012-10-02 07:11:58'),(1476,'49',1,'user_role_permissions','set','2012-10-02 07:11:58'),(1477,'50',1,'user_role_permissions','set','2012-10-02 07:11:59'),(1478,'51',1,'user_role_permissions','set','2012-10-02 07:12:00'),(1479,'52',1,'user_role_permissions','set','2012-10-02 07:12:00'),(1480,'53',1,'user_role_permissions','set','2012-10-02 07:12:01'),(1481,'54',1,'user_role_permissions','set','2012-10-02 07:12:01'),(1482,'55',1,'user_role_permissions','set','2012-10-02 07:12:02'),(1483,'56',1,'user_role_permissions','set','2012-10-02 07:12:03'),(1484,'57',1,'user_role_permissions','set','2012-10-02 07:12:05'),(1485,'58',1,'user_role_permissions','set','2012-10-02 07:12:05'),(1486,'59',1,'user_role_permissions','set','2012-10-02 07:12:06'),(1487,'60',1,'user_role_permissions','set','2012-10-02 07:12:06'),(1488,'61',1,'user_role_permissions','set','2012-10-02 07:12:07'),(1489,'62',1,'user_role_permissions','set','2012-10-02 07:12:07'),(1490,'63',1,'user_role_permissions','set','2012-10-02 07:12:08'),(1491,'64',1,'user_role_permissions','set','2012-10-02 07:12:10'),(1492,'1',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1493,'1',1,'permissions','create','2012-10-02 07:17:43'),(1494,'2',1,'permissions','create','2012-10-02 07:17:43'),(1495,'3',1,'permissions','create','2012-10-02 07:17:43'),(1496,'4',1,'permissions','create','2012-10-02 07:17:43'),(1497,'5',1,'permissions','create','2012-10-02 07:17:43'),(1498,'6',1,'permissions','create','2012-10-02 07:17:43'),(1499,'1',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1500,'2',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1501,'3',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1502,'4',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1503,'5',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1504,'2',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1505,'3',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1506,'4',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1507,'5',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1508,'1',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1509,'2',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1510,'3',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1511,'4',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1512,'5',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1513,'6',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1514,'7',1,'user_role_permissions','allow','2012-10-02 07:17:43'),(1515,'7',1,'permissions','create','2012-10-02 07:17:43'),(1516,'8',1,'permissions','create','2012-10-02 07:17:43'),(1517,'9',1,'permissions','create','2012-10-02 07:17:43'),(1518,'10',1,'permissions','create','2012-10-02 07:17:43'),(1519,'6',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1520,'7',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1521,'8',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1522,'9',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1523,'6',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1524,'11',1,'permissions','create','2012-10-02 07:17:43'),(1525,'12',1,'permissions','create','2012-10-02 07:17:43'),(1526,'10',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1527,'11',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1528,'13',1,'permissions','create','2012-10-02 07:17:43'),(1529,'14',1,'permissions','create','2012-10-02 07:17:43'),(1530,'15',1,'permissions','create','2012-10-02 07:17:43'),(1531,'16',1,'permissions','create','2012-10-02 07:17:43'),(1532,'12',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1533,'13',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1534,'14',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1535,'15',1,'module_menu_permissions','add','2012-10-02 07:17:43'),(1536,'7',1,'module_menu_positions','set','2012-10-02 07:17:43'),(1537,'17',1,'permissions','create','2012-10-02 07:17:43'),(1538,'18',1,'permissions','create','2012-10-02 07:17:43'),(1539,'19',1,'permissions','create','2012-10-02 07:17:43'),(1540,'20',1,'permissions','create','2012-10-02 07:17:43'),(1541,'16',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1542,'17',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1543,'18',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1544,'19',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1545,'8',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1546,'21',1,'permissions','create','2012-10-02 07:17:44'),(1547,'22',1,'permissions','create','2012-10-02 07:17:44'),(1548,'23',1,'permissions','create','2012-10-02 07:17:44'),(1549,'24',1,'permissions','create','2012-10-02 07:17:44'),(1550,'25',1,'permissions','create','2012-10-02 07:17:44'),(1551,'26',1,'permissions','create','2012-10-02 07:17:44'),(1552,'27',1,'permissions','create','2012-10-02 07:17:44'),(1553,'28',1,'permissions','create','2012-10-02 07:17:44'),(1554,'20',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1555,'21',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1556,'22',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1557,'23',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1558,'24',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1559,'25',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1560,'26',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1561,'27',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1562,'9',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1563,'10',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1564,'29',1,'permissions','create','2012-10-02 07:17:44'),(1565,'30',1,'permissions','create','2012-10-02 07:17:44'),(1566,'31',1,'permissions','create','2012-10-02 07:17:44'),(1567,'32',1,'permissions','create','2012-10-02 07:17:44'),(1568,'28',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1569,'29',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1570,'30',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1571,'31',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1572,'11',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1573,'33',1,'permissions','create','2012-10-02 07:17:44'),(1574,'34',1,'permissions','create','2012-10-02 07:17:44'),(1575,'35',1,'permissions','create','2012-10-02 07:17:44'),(1576,'36',1,'permissions','create','2012-10-02 07:17:44'),(1577,'37',1,'permissions','create','2012-10-02 07:17:44'),(1578,'38',1,'permissions','create','2012-10-02 07:17:44'),(1579,'39',1,'permissions','create','2012-10-02 07:17:44'),(1580,'40',1,'permissions','create','2012-10-02 07:17:44'),(1581,'41',1,'permissions','create','2012-10-02 07:17:44'),(1582,'42',1,'permissions','create','2012-10-02 07:17:44'),(1583,'43',1,'permissions','create','2012-10-02 07:17:44'),(1584,'44',1,'permissions','create','2012-10-02 07:17:44'),(1585,'45',1,'permissions','create','2012-10-02 07:17:44'),(1586,'46',1,'permissions','create','2012-10-02 07:17:44'),(1587,'47',1,'permissions','create','2012-10-02 07:17:44'),(1588,'32',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1589,'33',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1590,'34',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1591,'35',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1592,'36',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1593,'37',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1594,'38',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1595,'39',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1596,'40',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1597,'41',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1598,'42',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1599,'43',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1600,'44',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1601,'45',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1602,'46',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1603,'12',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1604,'13',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1605,'14',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1606,'15',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1607,'48',1,'permissions','create','2012-10-02 07:17:44'),(1608,'49',1,'permissions','create','2012-10-02 07:17:44'),(1609,'50',1,'permissions','create','2012-10-02 07:17:44'),(1610,'51',1,'permissions','create','2012-10-02 07:17:44'),(1611,'52',1,'permissions','create','2012-10-02 07:17:44'),(1612,'53',1,'permissions','create','2012-10-02 07:17:44'),(1613,'54',1,'permissions','create','2012-10-02 07:17:44'),(1614,'55',1,'permissions','create','2012-10-02 07:17:44'),(1615,'56',1,'permissions','create','2012-10-02 07:17:44'),(1616,'57',1,'permissions','create','2012-10-02 07:17:44'),(1617,'58',1,'permissions','create','2012-10-02 07:17:44'),(1618,'59',1,'permissions','create','2012-10-02 07:17:44'),(1619,'60',1,'permissions','create','2012-10-02 07:17:44'),(1620,'61',1,'permissions','create','2012-10-02 07:17:44'),(1621,'62',1,'permissions','create','2012-10-02 07:17:44'),(1622,'63',1,'permissions','create','2012-10-02 07:17:44'),(1623,'47',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1624,'48',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1625,'49',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1626,'50',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1627,'51',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1628,'52',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1629,'53',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1630,'54',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1631,'55',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1632,'56',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1633,'57',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1634,'58',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1635,'59',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1636,'60',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1637,'61',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1638,'62',1,'module_menu_permissions','add','2012-10-02 07:17:44'),(1639,'16',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1640,'17',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1641,'18',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1642,'19',1,'module_menu_positions','set','2012-10-02 07:17:44'),(1643,'8',1,'user_role_permissions','set','2012-10-02 07:18:07'),(1644,'9',1,'user_role_permissions','set','2012-10-02 07:18:43'),(1645,'10',1,'user_role_permissions','set','2012-10-02 07:18:43'),(1646,'11',1,'user_role_permissions','set','2012-10-02 07:18:45'),(1647,'12',1,'user_role_permissions','set','2012-10-02 07:18:46'),(1648,'13',1,'user_role_permissions','set','2012-10-02 07:18:47'),(1649,'14',1,'user_role_permissions','set','2012-10-02 07:18:49'),(1650,'15',1,'user_role_permissions','set','2012-10-02 07:18:50'),(1651,'16',1,'user_role_permissions','set','2012-10-02 07:18:51'),(1652,'17',1,'user_role_permissions','set','2012-10-02 07:18:52'),(1653,'18',1,'user_role_permissions','set','2012-10-02 07:18:55'),(1654,'19',1,'user_role_permissions','set','2012-10-02 07:18:55'),(1655,'20',1,'user_role_permissions','set','2012-10-02 07:18:56'),(1656,'21',1,'user_role_permissions','set','2012-10-02 07:18:56'),(1657,'22',1,'user_role_permissions','set','2012-10-02 07:18:59'),(1658,'23',1,'user_role_permissions','set','2012-10-02 07:19:08'),(1659,'24',1,'user_role_permissions','set','2012-10-02 07:19:08'),(1660,'25',1,'user_role_permissions','set','2012-10-02 07:19:09'),(1661,'26',1,'user_role_permissions','set','2012-10-02 07:19:09'),(1662,'27',1,'user_role_permissions','set','2012-10-02 07:19:09'),(1663,'28',1,'user_role_permissions','set','2012-10-02 07:19:10'),(1664,'29',1,'user_role_permissions','set','2012-10-02 07:19:10'),(1665,'30',1,'user_role_permissions','set','2012-10-02 07:19:12'),(1666,'31',1,'user_role_permissions','set','2012-10-02 07:19:13'),(1667,'32',1,'user_role_permissions','set','2012-10-02 07:19:14'),(1668,'33',1,'user_role_permissions','set','2012-10-02 07:19:15'),(1669,'34',1,'user_role_permissions','set','2012-10-02 07:19:16'),(1670,'35',1,'user_role_permissions','set','2012-10-02 07:19:17'),(1671,'36',1,'user_role_permissions','set','2012-10-02 07:19:17'),(1672,'37',1,'user_role_permissions','set','2012-10-02 07:19:52'),(1673,'38',1,'user_role_permissions','set','2012-10-02 07:19:53'),(1674,'39',1,'user_role_permissions','set','2012-10-02 07:19:53'),(1675,'40',1,'user_role_permissions','set','2012-10-02 07:19:54'),(1676,'41',1,'user_role_permissions','set','2012-10-02 07:19:54'),(1677,'42',1,'user_role_permissions','set','2012-10-02 07:19:55'),(1678,'43',1,'user_role_permissions','set','2012-10-02 07:19:55'),(1679,'44',1,'user_role_permissions','set','2012-10-02 07:19:57'),(1680,'45',1,'user_role_permissions','set','2012-10-02 07:19:57'),(1681,'46',1,'user_role_permissions','set','2012-10-02 07:19:58'),(1682,'47',1,'user_role_permissions','set','2012-10-02 07:19:58'),(1683,'48',1,'user_role_permissions','set','2012-10-02 07:19:59'),(1684,'49',1,'user_role_permissions','set','2012-10-02 07:19:59'),(1685,'50',1,'user_role_permissions','set','2012-10-02 07:20:01'),(1686,'51',1,'user_role_permissions','set','2012-10-02 07:20:02'),(1687,'52',1,'user_role_permissions','set','2012-10-02 07:20:04'),(1688,'53',1,'user_role_permissions','set','2012-10-02 07:20:05'),(1689,'54',1,'user_role_permissions','set','2012-10-02 07:20:05'),(1690,'55',1,'user_role_permissions','set','2012-10-02 07:20:06'),(1691,'56',1,'user_role_permissions','set','2012-10-02 07:20:06'),(1692,'57',1,'user_role_permissions','set','2012-10-02 07:20:06'),(1693,'58',1,'user_role_permissions','set','2012-10-02 07:20:07'),(1694,'59',1,'user_role_permissions','set','2012-10-02 07:20:07'),(1695,'60',1,'user_role_permissions','set','2012-10-02 07:20:09'),(1696,'61',1,'user_role_permissions','set','2012-10-02 07:20:09'),(1697,'62',1,'user_role_permissions','set','2012-10-02 07:20:10'),(1698,'63',1,'user_role_permissions','set','2012-10-02 07:20:10'),(1699,'64',1,'user_role_permissions','set','2012-10-02 07:20:11'),(1700,'1',1,'news','update','2012-10-02 07:29:55'),(1701,'8',1,'news','update','2012-10-02 07:29:59'),(1702,'1',1,'contact_locations','update','2012-10-03 03:57:19'),(1703,'1',1,'contact_locations','update','2012-10-03 04:00:38'),(1704,'3',1,'home_sliders','update','2012-10-03 04:07:19'),(1705,'1',1,'events','update','2012-10-03 05:40:44'),(1706,'1',1,'news','update','2012-10-03 05:46:23'),(1707,'1',1,'news','update','2012-10-03 06:06:49'),(1708,'18',1,'site_menus','create','2012-10-03 09:42:27'),(1709,'18',1,'site_menu_position_applications','create','2012-10-03 09:42:27'),(1710,'6',1,'pages','create','2012-10-03 09:42:27'),(1711,'3',3,'product_downloads','create','2012-10-03 09:48:53'),(1712,'1',3,'events','delete','2012-10-04 03:17:12');

/*Table structure for table `history_descriptions` */

DROP TABLE IF EXISTS `history_descriptions`;

CREATE TABLE `history_descriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `history_id` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `history_descriptions` */

insert  into `history_descriptions`(`id`,`history_id`,`description`) values (1,'136','Deni Santana delete News Test News'),(2,'143','Deni Santana delete News Create new news - updated'),(3,'144','Deni Santana delete News Test News  Edited  Again'),(4,'145','Deni Santana delete News Test News edited - 2'),(5,'146','Deni Santana delete News Test News - Edited - 3'),(6,'147','Deni Santana delete News Test News - Edited'),(7,'440','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(8,'53','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(9,'443','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(10,'441','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(11,'467','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(12,'444','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(13,'472','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(14,'468','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(15,'474','Andika Pebrian disallowed \"Administrator\" to \"Manage History\"'),(16,'473','Andika Pebrian allowed \"Administrator\" to \"Manage History\"'),(17,'476','Andika Pebrian disallowed \"Administrator\" to \"Manage History\"'),(18,'475','Andika Pebrian allowed \"Administrator\" to \"Manage History\"'),(19,'479','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(20,'477','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(21,'500','Andika Pebrian delete News LG Optimus L9: Usung Android 4.0, Layar 4.7 Inchi Plus Aplikasi Terjemah Bahasa'),(22,'581','Andika Pebrian deleted role \"Data Entry edited\"'),(23,'583','Andika Pebrian deleted role \"Data Entry\"'),(24,'729','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(25,'53','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(26,'731','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(27,'382','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(28,'1089','Deni Santana disallowed \"Administrator\" to \"Manage History\"'),(29,'53','Deni Santana allowed \"Administrator\" to \"Manage History\"'),(30,'1712','Andika Pebrian delete events Test Event');

/*Table structure for table `home_sliders` */

DROP TABLE IF EXISTS `home_sliders`;

CREATE TABLE `home_sliders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `home_sliders` */

insert  into `home_sliders`(`id`,`title`,`description`,`status`) values (1,'Knapsack Sprayer','<p>\n	is any method to limit or eradicate the mammals, birds, insects which transmit disease pathogens.</p>\n','active'),(2,' Backpack Sprayer','<p>\n	is any method to limit or eradicate the mammals, birds, insects which transmit disease pathogens.</p>\n','active'),(3,'Fogging Machine','<p>\n	is any method to limit or eradicate the mammals, birds, insects which transmit disease pathogens. Progressively restore clicks-and-mortar platforms and client-centric products. Monotonectally reinvent client-based strategic theme areas whereas intuitive initiatives. Proactively implement next-generation e-services before next-generation e-business. Energistically customize leveraged process improvements after client-centered growth strategies. Uniquely enhance low-risk high-yield data whereas 2.0 markets.</p>\n','active');

/*Table structure for table `industries` */

DROP TABLE IF EXISTS `industries`;

CREATE TABLE `industries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `industry_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `industries` */

insert  into `industries`(`id`,`title`,`industry_code`,`status`) values (2,'Chemicals','1300','active'),(3,'Basic Resources','1700','active'),(4,'Construction & Materials','2300','active'),(5,'Industrial Goods & Services','2700','active'),(6,'Automobiles & Parts','3300','active'),(7,'Food & Beverage','3500','active'),(8,'Personal & Household Goods','3700','active'),(9,'Health Care','4500','active'),(10,'Retail','5300','active'),(11,'Media','5500','active'),(12,'Travel & Leisure','5700','active'),(13,'Telecommunications','6500','active'),(14,'Utilities','7500','active'),(15,'Banks','8300','active'),(16,'Insurance','8500','active'),(17,'Real Estate','8600','active'),(18,'Financial Services','8700','active'),(19,'Technology','9500','active');

/*Table structure for table `inquiry_logs` */

DROP TABLE IF EXISTS `inquiry_logs`;

CREATE TABLE `inquiry_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `industry` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `status` enum('read','unread') COLLATE utf8_unicode_ci DEFAULT 'unread',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `inquiry_logs` */

insert  into `inquiry_logs`(`id`,`title`,`name`,`phone`,`fax`,`email`,`company`,`industry`,`country`,`attention`,`message`,`status`) values (1,'my subject','Deni','021987654321','021987654314','deni@webarq.com','webarq','0500','ID','deni@webarq.com','my message','unread'),(3,'my subject','Deni','021987','021987','spy.tux@gmail.com','webarq','1300','IN','deni@webarq.com','Distinctively foster tactical internal or \"organic\" sources through out-of-the-box deliverables. Rapidiously simplify enterprise quality vectors rather than open-source expertise. Completely supply sustainable human capital without compelling initiatives. Monotonectally integrate unique manufactured products after 2.0 e-services. Credibly leverage other\'s value-added users with orthogonal markets.','unread'),(4,'MY subject','test','021987654','0219876','test@email.com','webarq','1300','IN','deni@webarq.com','my message blalalalalalalalaaaalallasafkjhsdkjhagdhdhk','unread'),(5,'subject','Andika','0216565656','0215545554','andika.pebrian99@yahoo.co.id','Web Architect, PT','1300','IN','deni@webarq.com','message','unread'),(6,'subject','Andika','0216565656','','andika.pebrian99@yahoo.co.id','Web Architect, PT','1300','IN','deni@webarq.com','message','unread'),(7,'subject','Andika','','','andika.pebrian99@yahoo.co.id','Web Architect, PT','1300','IN','andika@webarq.com','test','read'),(8,'Subject','Andika','0216565656','0215545554','andika.pebrian99@yahoo.co.id','Web Architect, PT','1300','JP','andika1@webarq.com','Fusce in elit quis velit viverra porttitor. Sed et mauris a lacus aliquam faucibus quis eu magna. Donec tincidunt suscipit interdum. In erat felis, egestas sed placerat eget, lacinia vel metus. Fusce tortor ipsum, ullamcorper vel malesuada vel, feugiat sed elit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse posuere eleifend tempus. Etiam pulvinar quam quis leo venenatis lacinia.','read'),(9,'Technical Writer','Andika','08569656565','0215545554','andika.pebrian99@yahoo.co.id','Web Architect, PT','1300','IN','andika@webarq.com','Fusce in elit quis velit viverra porttitor. Sed et mauris a lacus aliquam faucibus quis eu magna. Donec tincidunt suscipit interdum. In erat felis, egestas sed placerat eget, lacinia vel metus. Fusce tortor ipsum, ullamcorper vel malesuada vel, feugiat sed elit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse posuere eleifend tempus. Etiam pulvinar quam quis leo venenatis lacinia.','read');

/*Table structure for table `languages` */

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` char(5) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT '0',
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `languages` */

insert  into `languages`(`id`,`label`,`is_system`,`status`,`ordering`) values ('en','English',1,'active',1),('id','Indonesian',1,'active',2);

/*Table structure for table `media_applications` */

DROP TABLE IF EXISTS `media_applications`;

CREATE TABLE `media_applications` (
  `table` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_id` int(11) NOT NULL DEFAULT '0',
  `media_library_id` int(11) NOT NULL DEFAULT '0',
  `media_position_id` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`table`,`source_id`,`media_library_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_applications` */

insert  into `media_applications`(`table`,`source_id`,`media_library_id`,`media_position_id`,`ordering`,`title`,`permalink`) values ('site_menus',3,3,2,1,'',''),('site_menus',9,6,2,1,'',''),('site_menus',11,6,2,1,'',''),('site_menus',12,5,2,1,'',''),('site_menus',10,4,2,1,'',''),('home_sliders',1,9,1,1,'',''),('home_sliders',2,1,1,1,'',''),('home_sliders',3,2,1,1,'',''),('site_menus',15,3,2,1,'',''),('site_menus',8,7,2,1,'',''),('site_menus',7,8,2,1,'',''),('home_sliders',4,4,1,1,'','');

/*Table structure for table `media_libraries` */

DROP TABLE IF EXISTS `media_libraries`;

CREATE TABLE `media_libraries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_libraries` */

insert  into `media_libraries`(`id`,`type`,`file_name`) values (1,'image','banner02.jpg'),(2,'image','banner03.jpg'),(3,'image','banner-about.jpg'),(4,'image','banner-contact.jpg'),(5,'image','banner-event.jpg'),(6,'image','banner-news.jpg'),(7,'image','banner-order.jpg'),(8,'image','banner-product.jpg'),(9,'image','banner01.jpg'),(10,'image','3nigh1t.jpg');

/*Table structure for table `media_positions` */

DROP TABLE IF EXISTS `media_positions`;

CREATE TABLE `media_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `width` smallint(6) DEFAULT NULL,
  `height` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_positions` */

insert  into `media_positions`(`id`,`label`,`width`,`height`) values (1,'Home Banner',940,350),(2,'Page Banner',940,238);

/*Table structure for table `meta` */

DROP TABLE IF EXISTS `meta`;

CREATE TABLE `meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_menu_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `meta` */

/*Table structure for table `module_menu_permissions` */

DROP TABLE IF EXISTS `module_menu_permissions`;

CREATE TABLE `module_menu_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_menu_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menu_permissions` */

insert  into `module_menu_permissions`(`id`,`module_menu_id`,`permission_id`) values (1,'user_1',5),(2,'user_2',3),(3,'user_3',2),(4,'user_4',1),(5,'system_3',6),(6,'page_1',7),(7,'page_1',8),(8,'page_1',9),(9,'page_1',10),(10,'image_library',11),(11,'banner_position',12),(12,'news_2',13),(13,'news_2',14),(14,'news_2',15),(15,'news_2',16),(16,'event_1',17),(17,'event_1',18),(18,'event_1',19),(19,'event_1',20),(20,'contact_1',21),(21,'contact_1',22),(22,'contact_1',23),(23,'contact_1',24),(24,'contact_2',25),(25,'contact_2',26),(26,'contact_2',27),(27,'contact_2',28),(28,'homeslider_1',29),(29,'homeslider_1',30),(30,'homeslider_1',31),(31,'homeslider_1',32),(32,'order_1',33),(33,'order_1',34),(34,'order_1',35),(35,'order_1',36),(36,'order_2',37),(37,'order_2',38),(38,'order_2',39),(39,'order_2',40),(40,'order_3',41),(41,'order_3',42),(42,'order_3',43),(43,'order_3',44),(44,'order_4',0),(45,'order_4',46),(46,'order_4',47),(47,'product_1',48),(48,'product_1',49),(49,'product_1',50),(50,'product_1',51),(51,'product_2',52),(52,'product_2',53),(53,'product_2',54),(54,'product_2',55),(55,'product_3',56),(56,'product_3',57),(57,'product_3',58),(58,'product_3',59),(59,'product_4',60),(60,'product_4',61),(61,'product_4',62),(62,'product_4',63);

/*Table structure for table `module_menu_positions` */

DROP TABLE IF EXISTS `module_menu_positions`;

CREATE TABLE `module_menu_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_menu_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `position` enum('top','right','bottom','left','main') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'top',
  PRIMARY KEY (`id`,`module_menu_id`,`position`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menu_positions` */

insert  into `module_menu_positions`(`id`,`module_menu_id`,`position`) values (1,'system_3','left'),(2,'user_1','left'),(3,'user_2','left'),(4,'user_3','left'),(5,'user_4','left'),(6,'page_1','left'),(7,'news_2','left'),(8,'event_1','left'),(9,'contact_1','left'),(10,'contact_2','left'),(11,'homeslider_1','left'),(12,'order_1','left'),(13,'order_2','left'),(14,'order_3','left'),(15,'order_4','left'),(16,'product_1','left'),(17,'product_2','left'),(18,'product_3','left'),(19,'product_4','left');

/*Table structure for table `module_menus` */

DROP TABLE IF EXISTS `module_menus`;

CREATE TABLE `module_menus` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` int(11) DEFAULT '0',
  `label` char(25) COLLATE utf8_unicode_ci NOT NULL,
  `permalink` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menus` */

insert  into `module_menus`(`id`,`module_id`,`parent_id`,`label`,`permalink`,`status`,`ordering`) values ('system_2','system',0,'histories','history','active',1),('system_1','system',0,'module_setting','module-setting','active',2),('system_3','system',0,'site_menu','site-menu','active',3),('user_1','user',0,'profile','profile','active',1),('user_2','user',0,'user_list','manage','active',2),('user_3','user',0,'role','role','active',3),('user_4','user',0,'permission','permission','active',4),('page_1','page',0,'page_list','manage','active',1),('image_library','medialibrary',0,'image_library','image','active',1),('banner_position','medialibrary',0,'banner_position','banner-position','active',2),('news_2','news',0,'news_list','manage','active',2),('event_1','event',0,'event_list','manage','active',1),('contact_1','contact',0,'contact_category_list','category/manage','active',1),('contact_2','contact',0,'office_location_list','location/manage','active',2),('homeslider_1','homeslider',0,'banner','manage','active',1),('order_1','order',0,'attention_list','attention/manage','active',1),('order_2','order',0,'industry_list','industry/manage','active',2),('order_3','order',0,'country_list','country/manage','active',3),('order_4','order',0,'inquiry_list','inquiry/manage','active',4),('product_1','product',0,'product_category_list','category/manage','active',1),('product_2','product',0,'product_item_list','item/manage','active',2),('product_3','product',0,'product_accessory_list','Accessory/manage','active',3),('product_4','product',0,'product_download_list','download/manage','active',4);

/*Table structure for table `modules` */

DROP TABLE IF EXISTS `modules`;

CREATE TABLE `modules` (
  `id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` char(25) COLLATE utf8_unicode_ci NOT NULL,
  `ordering` int(11) DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT '0',
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`label`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `modules` */

insert  into `modules`(`id`,`label`,`ordering`,`is_system`,`status`,`description`) values ('template','template',1,1,'active',NULL),('system','system',999,1,'active',NULL),('user','user',900,1,'active',NULL),('page','page',4,1,'active',NULL),('medialibrary','medialibrary',5,0,'active',NULL),('news','news',6,0,'active',NULL),('event','event',7,0,'active',NULL),('contact','contact',8,0,'active',NULL),('homeslider','homeslider',9,0,'active',NULL),('order','order',10,0,'active',NULL),('product','product',11,0,'active',NULL);

/*Table structure for table `news` */

DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `news_category_id` int(11) DEFAULT '1',
  `news_date` date DEFAULT NULL,
  `news_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intro` text COLLATE utf8_unicode_ci,
  `description` longtext COLLATE utf8_unicode_ci,
  `image_path` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `news` */

insert  into `news`(`id`,`news_category_id`,`news_date`,`news_title`,`permalink`,`intro`,`description`,`image_path`,`status`) values (1,1,'2012-09-14','Test News Edit # 1','test-news','<p>\n	intro.</p>\n','<p>\n	Assertively impact one-to-one convergence without interactive schemas. Enthusiastically cultivate best-of-breed best practices for exceptional growth strategies. Progressively evisculate optimal niches without process-centric e-business. Monotonectally scale distinctive markets rather than exceptional strategic theme areas. Credibly aggregate resource maximizing portals whereas collaborative solutions.<br />\n	<br />\n	Uniquely transform enterprise supply chains and adaptive meta-services. Efficiently foster client-centered experiences through best-of-breed leadership skills. Authoritatively actualize inexpensive value for functional sources. Objectively repurpose optimal customer service before equity invested supply chains. Uniquely envisioneer goal-oriented methodologies and optimal metrics.<br />\n	<br />\n	Holisticly transform front-end paradigms and innovative technology. Uniquely disintermediate seamless materials without plug-and-play sources. Progressively supply reliable outsourcing vis-a-vis out-of-the-box total linkage. Seamlessly monetize just in time total linkage without multifunctional synergy. Efficiently expedite interoperable paradigms before end-to-end resources.<br />\n	<br />\n	Distinctively whiteboard end-to-end relationships after enterprise intellectual capital. Objectively maintain multimedia based innovation vis-a-vis adaptive process improvements. Professionally streamline viral intellectual capital without alternative supply chains. Distinctively disseminate inexpensive value for goal-oriented best practices. Intrinsicly e-enable ubiquitous technologies after 2.0 services.dsadsad</p>\n<p>\n	This is the tambahan.------------------------------------------------------------------------------------------------------------------</p>\n','media/images/news/506577c6e4846_history.jpg','inactive'),(8,1,'2012-09-04','Test upload','test-upload','<p>\n	test</p>\n','<p>\n	test</p>\n','media/images/news/506577dfb0cc0_bannerproduct.jpg','inactive');

/*Table structure for table `news_categories` */

DROP TABLE IF EXISTS `news_categories`;

CREATE TABLE `news_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `news_categories` */

insert  into `news_categories`(`id`,`label`,`permalink`,`description`,`status`,`ordering`) values (1,'Uncategorized','uncategorized','','active',1);

/*Table structure for table `pages` */

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_menu_id` int(11) DEFAULT NULL,
  `page_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intro` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `pages` */

insert  into `pages`(`id`,`site_menu_id`,`page_title`,`intro`,`description`) values (1,3,'About Us','',''),(2,4,'Company Profile','<p>\n	We characterized ourselves as tiny seeds at the beginning and during these thirty years have grown and accumulated to become a big plantation.</p>\n','<p>\n	Success in every business starts from the first optimistic step with a strong commitment based on &ldquo;<strong>Discipline, Loyalty and Strong Work Ethic</strong>&rdquo; from every management personnel integrated into a vision of the future. These principles have made PT. GOLDEN AGIN develop into one of the leaders in stainless steel and plastic knapsack sprayers industry globally.</p>\n<p>\n	We characterized ourselves as tiny seeds at the beginning and during these thirty years have grown and accumulated to become a big plantation. This big plantation needs to be maintained constantlly with better developlements and knapsack sprayers will be able to do the job efficiently.</p>\n<p>\n	The motto &ldquo;<strong>Customers Satisfaction Guaranteed</strong>&rdquo; also has become our commitment in providing on time delivery, strict quality control and faster communication. Lastly, an honest, fair and trustable connection with customers are essential in achieving a good long relationship.</p>\n'),(3,5,'Company History','<p>\n	PT. Golden Agin Nusa Established on 11th of April 1980. It&rsquo;s located in Depok, Jawa Barat, Indonesia. PT. Golden Agin is a global leader in stainless steel and plastic Knapsack sprayers industry.</p>\n','<p>\n	PT. Golden Agin Nusa Established on 11th of April 1980. It&rsquo;s located in Depok, Jawa Barat, Indonesia. PT. Golden Agin is a global leader in stainless steel and plastic Knapsack sprayers industry. High quality of stainless steel and high density polyethylene as main raw materials are subsequently used to maintain the quality of the knapsack sprayers and utilizing modern efficient machineries have made these sprayers affordable to farmers. Several models of knapsack sprayers in terms of volume and material are made to fulfill various use for farming, gardening, mining, malaria prevention and vector control.</p>\n'),(4,6,'Our Values','<p>\n	Our values define who we are. They are the fundamental beliefs of our global organisation.</p>\n','<p>\n	Our values define who we are. They are the fundamental beliefs of our global organisation. They influence the way we work with each other &ndash; and the way we serve our clients and engage with our communities. We make a difference by helping our people, our clients, and our wider with the motto &ldquo;<b>Customers Satisfaction Guaranteed</b>&rdquo; with our service include delivery, strict quality control and faster communication for achieving a good relationship.</p>\n');

/*Table structure for table `permissions` */

DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `module_id` char(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`module_id`,`action`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `permissions` */

insert  into `permissions`(`id`,`module_id`,`action`,`label`,`description`) values (1,'user','manage_permission','manage_permission',NULL),(2,'user','manage_role','manage_role',NULL),(3,'user','manage_user','manage_user',NULL),(4,'user','edit','edit_profile',NULL),(5,'user','view','view_profile',NULL),(6,'system','manage_site_menu','manage_site_menu',NULL),(7,'page','create','create_new_page',NULL),(8,'page','edit','edit_page',NULL),(9,'page','delete','delete_page',NULL),(10,'page','view','view_page',NULL),(11,'medialibrary','manage_image_library','manage_image_library',NULL),(12,'medialibrary','manage_banner_position','manage_banner_position',NULL),(13,'news','create','create_news',NULL),(14,'news','edit','edit_news',NULL),(15,'news','delete','delete_news',NULL),(16,'news','view','view_news',NULL),(17,'event','create','create',NULL),(18,'event','edit','edit',NULL),(19,'event','delete','delete',NULL),(20,'event','view','view',NULL),(21,'contact','create_category','create_contact_category',NULL),(22,'contact','edit_category','edit_contact_category',NULL),(23,'contact','delete_category','delete_contact_category',NULL),(24,'contact','view_category','view_contact_category',NULL),(25,'contact','create_location','create_contact_location',NULL),(26,'contact','edit_location','edit_contact_location',NULL),(27,'contact','delete_location','delete_contact_location',NULL),(28,'contact','view_location','view_contact_location',NULL),(29,'homeslider','create','create',NULL),(30,'homeslider','edit','edit',NULL),(31,'homeslider','delete','delete',NULL),(32,'homeslider','view','view',NULL),(33,'order','create_attention','create_attention',NULL),(34,'order','edit_attention','edit_attention',NULL),(35,'order','delete_attention','delete_attention',NULL),(36,'order','view_attention','view_attention',NULL),(37,'order','create_industry','create_industry',NULL),(38,'order','edit_industry','edit_industry',NULL),(39,'order','delete_industry','delete_industry',NULL),(40,'order','view_industry','view_industry',NULL),(41,'order','create_country','create_country',NULL),(42,'order','edit_country','edit_country',NULL),(43,'order','delete_country','delete_country',NULL),(44,'order','view_country','view_country',NULL),(45,'order','edit_inquiry','edit_inquiry',NULL),(46,'order','delete_inquiry','delete_inquiry',NULL),(47,'order','view_inquiry','view_inquiry',NULL),(48,'product','create_product_category','create_product_category',NULL),(49,'product','edit_product_category','edit_product_category',NULL),(50,'product','delete_product_category','delete_product_category',NULL),(51,'product','view_product_category','view_product_category',NULL),(52,'product','create_product_item','create_product_item',NULL),(53,'product','edit_product_item','edit_product_item',NULL),(54,'product','delete_product_item','delete_product_item',NULL),(55,'product','view_product_item','view_product_item',NULL),(56,'product','create_product_accessory','create_product_accessory',NULL),(57,'product','edit_product_accessory','edit_product_accessory',NULL),(58,'product','delete_product_accessory','delete_product_accessory',NULL),(59,'product','view_product_accessory','view_product_accessory',NULL),(60,'product','create_product_download','create_product_download',NULL),(61,'product','edit_product_download','edit_product_download',NULL),(62,'product','delete_product_download','delete_product_download',NULL),(63,'product','view_product_download','view_product_download',NULL);

/*Table structure for table `product_accessories` */

DROP TABLE IF EXISTS `product_accessories`;

CREATE TABLE `product_accessories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_category_id` int(11) DEFAULT NULL,
  `product_item_id` int(10) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `file_path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `product_accessories` */

insert  into `product_accessories`(`id`,`title`,`product_category_id`,`product_item_id`,`description`,`file_path`,`status`,`permalink`,`image_path`) values (1,'KSP-12 Filler Cap ',1,1,'description','media/pdf/product/accessories/506065ab4fa1e_blueprintv0.8bygjms.pdf','active','ksp-12-filler-cap','media/images/product/accessories/50606cf753110_product07.png');

/*Table structure for table `product_categories` */

DROP TABLE IF EXISTS `product_categories`;

CREATE TABLE `product_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `product_categories` */

insert  into `product_categories`(`id`,`title`,`description`,`status`,`permalink`) values (1,'Knapsack Prayer','<p>\n	Knapsack prayer.</p>\n','active','knapsack-prayer'),(2,'Tree Sprayer','<p>\n	Tree sprayer.</p>\n','active','tree-sprayer'),(3,'Swan Fog','<p>\n	Swan fog.</p>\n','active','swan-fog'),(5,'Product Test','<p>\n	testa</p>\n','active','product-test');

/*Table structure for table `product_downloads` */

DROP TABLE IF EXISTS `product_downloads`;

CREATE TABLE `product_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_category_id` int(11) DEFAULT NULL,
  `product_item_id` int(10) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `file_path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `product_downloads` */

insert  into `product_downloads`(`id`,`title`,`product_category_id`,`product_item_id`,`description`,`file_path`,`status`,`permalink`) values (1,'Brosur',1,1,'brosur.','media/pdf/product/downloads/506073fb5b183_backtrack4-guide-tutorial.pdf','active','brosur'),(2,'Brosur',1,2,'brosur kedua.','media/pdf/product/downloads/506074874c38a_backtrack_5_tutorial_6.pdf','inactive','brosur-sa-14'),(3,'Brosur',5,3,'description','media/pdf/product/downloads/506cf9150c9fe_schedule_polis.pdf','active','brosur1');

/*Table structure for table `product_items` */

DROP TABLE IF EXISTS `product_items`;

CREATE TABLE `product_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `product_category_id` int(11) DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `information` varchar(1208) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_benefit` varchar(1208) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `model` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `image_path` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `feature_product` enum('inactive','active') COLLATE utf8_unicode_ci DEFAULT 'inactive',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `product_items` */

insert  into `product_items`(`id`,`title`,`product_category_id`,`description`,`information`,`customer_benefit`,`status`,`permalink`,`model`,`image_path`,`feature_product`) values (1,'SA-10 Semi Automatic Stainless Steel',3,'Tank material|High Quality Stainless Steel;\nTank capacity|9;\nWorking Pressure (kg/cm2)|2.0-5.0;','If Backpack Sprayer (15 Litre) product is not what you want, we can be customized according to your needs, please send us your order to Email: sales@golden-agin.com, or click here to post your buying lead. Backpack Sprayer (15 Litre) Manufacturer, Supplier & Factory search on: Google, Yahoo, Msn','Easy to use;\nSmooth tank shape;','active','sa-10-semi-automatic-stainless-steel','SA-10','media/images/product/items/506150ba9e06f_productbig.png','active'),(2,'SA-14 BIG Semi Automatic Stainless Steel',1,'Tank material|High Quality Stainless Steel;','If Backpack Sprayer (15 Litre) product is not what you want, we can be customized according to your needs, please send us your order to Email: sales@golden-agin.com, or click here to post your buying lead. Backpack Sprayer (15 Litre) Manufacturer, Supplier & Factory search on: Google, Yahoo, Msn','Easy to use;','active','sa-14-big-semi-automatic-stainless-steel','SA-14','media/images/product/items/506140e2afcfa_product03.png','active'),(3,'Apple',5,'Aliquam ac mauris at tellus fermentum dignissim\nPraesent tincidunt, lacus sed volutpat dictum, diam eros laoreet massa, et vestibulum est lorem nec odio. Nam scelerisque, neque nec tempus fringilla, massa arcu faucibus lacus, sed commodo turpis libero in nunc. Aliquam ac mauris at tellus fermentum dignissim eu vel urna. Suspendisse eget neque in dolor iaculis suscipit ac sit amet justo. Cras gravida leo non sem dapibus vel pharetra urna lacinia. Vestibulum sit amet enim non nisi placerat rhoncus. Vivamus volutpat, mauris aliquet accumsan accumsan, enim ligula dignissim quam, eget accumsan felis augue nec enim.','Fusce in elit quis velit viverra porttitor. Sed et mauris a lacus aliquam faucibus quis eu magna. Donec tincidunt suscipit interdum. In erat felis, egestas sed placerat eget, lacinia vel metus. Fusce tortor ipsum, ullamcorper vel malesuada vel, feugiat sed elit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse posuere eleifend tempus. Etiam pulvinar quam quis leo venenatis lacinia.','Nulla et libero felis. Nullam quis velit quam. Curabitur sed massa augue.','active','apple','Mac OS','media/images/product/items/506964b3e0a37_003.jpg','active'),(4,'Helm',2,'this|description;\nand thats|too;','this is information.','nothing;','active','helm','H0123','media/images/product/items/506abf2d90f59_45-116-thickbox.jpg','active');

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `is_admin` tinyint(1) DEFAULT '0',
  `is_system` tinyint(1) DEFAULT '0',
  `label` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `roles` */

insert  into `roles`(`id`,`is_admin`,`is_system`,`label`,`status`) values (1,1,1,'Superadmin','active'),(2,1,1,'Administrator','active'),(3,0,0,'Sub Admin','active'),(6,1,0,'Date Entry Edited','active');

/*Table structure for table `site_menu_position_applications` */

DROP TABLE IF EXISTS `site_menu_position_applications`;

CREATE TABLE `site_menu_position_applications` (
  `site_menu_id` int(11) NOT NULL DEFAULT '0',
  `site_menu_position_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`site_menu_id`,`site_menu_position_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menu_position_applications` */

insert  into `site_menu_position_applications`(`site_menu_id`,`site_menu_position_id`) values (0,1),(1,1),(3,1),(4,0),(5,0),(6,0),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,2),(16,1),(18,0);

/*Table structure for table `site_menu_positions` */

DROP TABLE IF EXISTS `site_menu_positions`;

CREATE TABLE `site_menu_positions` (
  `id` int(11) NOT NULL DEFAULT '0',
  `label` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menu_positions` */

insert  into `site_menu_positions`(`id`,`label`) values (1,'Main'),(2,'Bottom');

/*Table structure for table `site_menus` */

DROP TABLE IF EXISTS `site_menus`;

CREATE TABLE `site_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` tinyint(1) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `menu_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menus` */

insert  into `site_menus`(`id`,`is_system`,`parent_id`,`menu_title`,`permalink`,`ordering`,`status`) values (1,1,0,'Home','home',1,'active'),(3,0,0,'About Us','about-us',2,'active'),(4,0,3,'Company Profile','company-profile',1,'active'),(5,0,3,'Company History','company-history',2,'active'),(6,0,3,'Our Values','our-values',3,'active'),(7,1,0,'Product','product',3,'active'),(8,1,0,'How To Order','how-to-order',4,'active'),(9,1,0,'News & Event','news-event',5,'active'),(10,1,0,'Contact Us','contact-us',6,'active'),(11,1,9,'News','news',1,'active'),(12,1,9,'Event','event',2,'active'),(13,1,10,'Address','contact/address',1,'active'),(14,1,10,'Contact Form','contact/form',2,'active'),(15,1,0,'Search','search',7,'active'),(16,1,8,'Inquiry Form','inquiry-form',1,'active');

/*Table structure for table `tokens` */

DROP TABLE IF EXISTS `tokens`;

CREATE TABLE `tokens` (
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expired` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `tokens` */

/*Table structure for table `translations` */

DROP TABLE IF EXISTS `translations`;

CREATE TABLE `translations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang_id` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`source_id`,`lang_id`,`table`,`field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `translations` */

/*Table structure for table `user_details` */

DROP TABLE IF EXISTS `user_details`;

CREATE TABLE `user_details` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `first_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `middle_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` enum('male','female') COLLATE utf8_unicode_ci DEFAULT 'male',
  `address` text COLLATE utf8_unicode_ci,
  `phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_details` */

insert  into `user_details`(`user_id`,`first_name`,`last_name`,`middle_name`,`sex`,`address`,`phone`,`avatar`) values (1,'Deni','Santana',NULL,'male','web architect',NULL,NULL),(2,'Esteban','Alejandro',NULL,'male','Nous Verse logbox',NULL,NULL),(3,'Andika','Pebrian',NULL,'male','Jl. Raya Bekasi km 18',NULL,NULL),(4,'Andika','Pebrianto',NULL,'male','Kelapa Gading',NULL,NULL),(5,'andika','pebrianto',NULL,'male','test',NULL,NULL),(6,'andika','pebrian',NULL,'male','tes',NULL,NULL);

/*Table structure for table `user_role_permissions` */

DROP TABLE IF EXISTS `user_role_permissions`;

CREATE TABLE `user_role_permissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` smallint(6) DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_role_permissions` */

insert  into `user_role_permissions`(`id`,`role_id`,`permission_id`) values (1,2,1),(2,2,2),(3,2,3),(4,2,4),(5,2,5),(6,3,4),(7,3,5),(8,2,6),(9,2,7),(10,2,8),(11,2,9),(12,2,10),(13,2,11),(14,2,13),(15,2,14),(16,2,15),(17,2,16),(18,2,17),(19,2,18),(20,2,19),(21,2,20),(22,2,21),(23,2,22),(24,2,23),(25,2,24),(26,2,25),(27,2,26),(28,2,27),(29,2,28),(30,2,29),(31,2,30),(32,2,32),(33,2,31),(34,2,33),(35,2,35),(36,2,34),(37,2,36),(38,2,37),(39,2,38),(40,2,39),(41,2,40),(42,2,41),(43,2,42),(44,2,43),(45,2,44),(46,2,45),(47,2,46),(48,2,47),(49,2,48),(50,2,49),(51,2,50),(52,2,51),(53,2,52),(54,2,53),(55,2,54),(56,2,55),(57,2,56),(58,2,57),(59,2,58),(60,2,59),(61,2,60),(62,2,61),(63,2,62),(64,2,63);

/*Table structure for table `user_sessions` */

DROP TABLE IF EXISTS `user_sessions`;

CREATE TABLE `user_sessions` (
  `user_id` int(11) DEFAULT NULL,
  `session` varchar(85) COLLATE utf8_unicode_ci DEFAULT NULL,
  `login` datetime DEFAULT NULL,
  `logout` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_sessions` */

insert  into `user_sessions`(`user_id`,`session`,`login`,`logout`) values (1,'cms::780d7005884b159ec16b5831273b40c5db6a670d::bevskhcsa52l211tjs42fesl17','2012-09-11 01:39:22',NULL),(1,'cms::db5241511a1fbee70275606cbf8b7596ec607a98::v8k3d0tuelmt930p3m9mhaeio5','2012-09-12 02:43:53',NULL),(1,'cms::43070e478a6feded674078b0511b19674062cad2::tq3o1i4nr8qs7u2n3bh013ohg2','2012-09-13 03:35:01',NULL),(1,'cms::626117ab51b0954ee2c8c06ad3b06ecb58d05e2e::73uqojnpjvn4jsstp8fq8ab6l6','2012-09-14 07:18:17',NULL),(1,'cms::06562b18d4f9309f6b596e375b9793d6201daea4::htpd53nmthpp7emmg24uds07c6','2012-09-16 22:56:48',NULL),(1,'cms::75d381564d1f738e211628a7273e062332dc531d::nie576fr2sndlt5kojp4l0re32','2012-09-17 00:35:25',NULL),(1,'cms::06562b18d4f9309f6b596e375b9793d6201daea4::8l9l3f08r16055om0jl6h9e745','2012-09-17 06:09:02',NULL),(1,'cms::cacc073166375b33fc1e87b0fbcc15527d37b64b::655r90ejhqtga7elsnn134m3e7','2012-09-18 03:33:32','2012-09-18 05:37:57'),(1,'cms::cacc073166375b33fc1e87b0fbcc15527d37b64b::4sek49112690p90ngsit2eu4h3','2012-09-18 05:38:56',NULL),(1,'cms::2eb04ddcdfada74b21e11c47686867d2a1f78565::m6bum5sa1ujc003rdagio3msa1','2012-09-18 21:30:56',NULL),(1,'cms::3ec8d4055adaaa6e03b6285ef7b863a414dc9dca::mareo4pg2vh3lbcfg2qm39dlm2','2012-09-20 03:18:07',NULL),(1,'cms::52f7762af3da84b32d1ecc72c59965bb25243f47::nsjanl8mo1pjskgns268s3vh06','2012-09-20 04:04:06',NULL),(1,'cms::3ec8d4055adaaa6e03b6285ef7b863a414dc9dca::0acfpqj3phjj9f6odf6i520qu7','2012-09-20 06:31:39',NULL),(1,'cms::3dfdfc6a1a43d85b5b72b4822278a2044259c832::kr09slc23hhvs1g58iguo67dt6','2012-09-21 02:14:45',NULL),(1,'cms::4f3430c61b07e98cd6d8b3c478d4547ee8490e40::48gugcidievf9b70aob39v0kb3','2012-09-23 23:33:40',NULL),(1,'cms::abb34c69d51eaf451b8ccfe92bc728a2ae490c50::4dpdurbcota6383g4ogi7gnki7','2012-09-23 23:38:25','2012-09-24 02:33:41'),(1,'cms::abb34c69d51eaf451b8ccfe92bc728a2ae490c50::bvo3mmpa9u3r4gggqebjaif720','2012-09-24 02:33:59',NULL),(1,'cms::53e3e3c0cf85decd638925bc531ac4f13ec1329a::ns023804v4p2859r7cm2h236j5','2012-09-24 04:23:37',NULL),(1,'cms::f8e7eca1eae78aa8f5f8e21f1dd14910935f9510::qcvi9tgnhul7k6pv92std3poo6','2012-09-24 04:32:55',NULL),(1,'cms::4314415141db17ffc4d729ad71c321ff93e0cd4b::92f5sc2d03tnu7m4eqpmdts652','2012-09-24 05:31:29',NULL),(1,'cms::fb024045801bb9cc897af95a276ad77699e27f74::smqeh8qbki0lb6tkno7cragq04','2012-09-25 00:22:22',NULL),(1,'cms::6a1e990a0bdc11ff00b8854fdd8a791a3f474a9c::3q6nign28kf7vp3m6kekqbvsl5','2012-09-25 22:14:49',NULL),(1,'cms::5e45f1e6daab58dbd4c30b70d2e3193cf1d75a9a::aq299bpopcmhcna7gf81dihpp5','2012-09-25 23:52:42',NULL),(1,'cms::5e45f1e6daab58dbd4c30b70d2e3193cf1d75a9a::audqomh23du91i03729eooo5s2','2012-09-26 04:03:54',NULL),(1,'cms::ac2835b9a1e4647000b56c1feab740e96f6ff243::3b6s5ieo9v5shui7vstu37vr67','2012-09-27 00:20:18',NULL),(1,'cms::3443d5eb10d568dc2dbae6bea5ad767b965068d8::76uf54atqe6bmgirif83ef2p96','2012-09-28 01:59:17',NULL),(1,'cms::3443d5eb10d568dc2dbae6bea5ad767b965068d8::ttm35obihhvsjihl0hpaf6dqu7','2012-09-28 03:33:02','2012-09-28 03:36:41'),(1,'cms::3443d5eb10d568dc2dbae6bea5ad767b965068d8::m0fg97pe83a2po6apo0e74hhp2','2012-09-28 03:36:54',NULL),(1,'cms::3443d5eb10d568dc2dbae6bea5ad767b965068d8::qicg8m0p4sgp3os6jk4tf0qn52','2012-09-28 04:04:40',NULL),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::mkflesn5p6aiffthgqbvtqn8p6','2012-09-30 21:33:43',NULL),(1,'cms::e65e96d2586277fa1f235a123c0d4b6339d4cd9c::kmaeaf1g1v3vl7umrqc4uimjo4','2012-09-30 22:18:29','2012-09-30 22:19:23'),(3,'cms::e65e96d2586277fa1f235a123c0d4b6339d4cd9c::fcc28qc2j01595j26taovi99r3','2012-09-30 22:19:33','2012-09-30 22:19:52'),(1,'cms::e65e96d2586277fa1f235a123c0d4b6339d4cd9c::2f3n4b2s82vnd32m6l7vn7h6o3','2012-09-30 22:19:58',NULL),(3,'cms::714688d4fb2962439cb4ae84739905249191a289::3rhk4ict5jue04qg899m2ok5c5','2012-09-30 22:29:21','2012-09-30 22:29:33'),(1,'cms::714688d4fb2962439cb4ae84739905249191a289::6h6kj3nbg9trkmmcanej6qs841','2012-09-30 22:29:40','2012-09-30 22:30:20'),(3,'cms::714688d4fb2962439cb4ae84739905249191a289::fgvhi8s8vlui02m98p1ch0l2f7','2012-09-30 22:30:25','2012-10-01 00:29:41'),(1,'cms::9670eba6835751935fc43c9e0dc56c53f23d7daa::bkqt2mcp0cj10sq7h31b1635v4','2012-09-30 22:30:51',NULL),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::armhkjr6i0gudhigqs6u49f2q0','2012-09-30 23:14:50','2012-10-01 00:28:00'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::8q6moc9537k0ld7e64butgqes2','2012-10-01 00:28:06','2012-10-01 00:32:30'),(3,'cms::714688d4fb2962439cb4ae84739905249191a289::l41l1o67ta8h38j7ser6kt92s7','2012-10-01 00:30:05','2012-10-01 00:31:22'),(4,'cms::714688d4fb2962439cb4ae84739905249191a289::d5d7avf5b8b38oknll85slkho2','2012-10-01 00:31:27','2012-10-01 00:32:31'),(3,'cms::714688d4fb2962439cb4ae84739905249191a289::vm4m40k5p6b4vbp687650mb8g0','2012-10-01 00:32:40','2012-10-01 03:42:26'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::lpfkk3somajpai108bq3h2t9p2','2012-10-01 00:32:44','2012-10-01 00:33:03'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::bl06q3oqsk6cbjaigveut8p9d1','2012-10-01 00:33:08','2012-10-01 00:41:33'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::12hh4k4880m0fa78tegtegjr95','2012-10-01 00:41:41','2012-10-01 01:27:49'),(1,'cms::c1b6c4997d6c6a9e248f75251b711fab4dfff2f3::jv92thmgaofrfvv48vcr68omg1','2012-10-01 01:07:28',NULL),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::mf8lna35fpo96ga8955mvvkm07','2012-10-01 01:27:58','2012-10-01 01:30:20'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::19h4u6ch2ug5hk5s2lkg17b6b7','2012-10-01 01:30:26','2012-10-01 01:39:48'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::fqa33kghivkejkp1purke85o44','2012-10-01 01:39:55','2012-10-01 01:41:53'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::3bv2g37bvvnct46b92oivhfg54','2012-10-01 01:42:01','2012-10-01 01:43:23'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::ld35905ae91m850rm2ekuio3a1','2012-10-01 01:43:34','2012-10-01 07:09:34'),(3,'cms::714688d4fb2962439cb4ae84739905249191a289::mdi2424rrkl1v5b1cfguf01ea0','2012-10-01 03:42:36',NULL),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::qmg98346nnjta31m0ian3bpcr7','2012-10-01 03:50:18','2012-10-01 03:50:50'),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::6ia16v9ane1bd8ime2vuhd0jo7','2012-10-01 03:51:27','2012-10-01 03:51:30'),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::gckd1q664tlk6g9fr6gcvna5c7','2012-10-01 03:51:50','2012-10-01 03:51:55'),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::1me03atambc2pir1jbuml7osg7','2012-10-01 03:52:21','2012-10-01 03:52:33'),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::55lq118npb0evvi7j1pb3imtg6','2012-10-01 03:54:03','2012-10-01 03:54:09'),(5,'cms::723a7348036085c0062155b4e63a80d5b91c0558::rf2h3ltjv8t67qfi6i9pr06ev0','2012-10-01 03:55:20','2012-10-01 03:55:26'),(6,'cms::723a7348036085c0062155b4e63a80d5b91c0558::6hfp8mt23ug6vfg6irde2b7bp0','2012-10-01 03:58:20','2012-10-01 03:58:31'),(1,'cms::db6a27397e026aeaa83af8e53a258061050fffbf::j3rd4e3hqlussfv9chdf0bmr41','2012-10-01 05:56:10','2012-10-01 06:16:55'),(3,'cms::db6a27397e026aeaa83af8e53a258061050fffbf::h89b4vo89lffos5gabmhkm17p6','2012-10-01 06:17:02',NULL),(3,'cms::275632545653ec7d6784d3407dcc2628593211db::mrrm8oh94cemqutg1d9j59iqa1','2012-10-01 06:31:24','2012-10-01 07:21:07'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::ap5llfjmcbr0n3jv98nja33741','2012-10-01 07:09:41','2012-10-01 07:21:48'),(3,'cms::275632545653ec7d6784d3407dcc2628593211db::imsmdqurvncjaprat0r9kp36j6','2012-10-01 07:21:12','2012-10-01 07:21:18'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::6toatg1dt2gpegh41fadfopj95','2012-10-01 07:22:27','2012-10-01 07:24:55'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::3sq5fcu42mejjv555hsb7nfig1','2012-10-01 07:25:06','2012-10-01 07:27:39'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::7ai97vbksomvhj6tjgcaf0obc4','2012-10-01 07:27:47','2012-10-01 07:29:55'),(1,'cms::275632545653ec7d6784d3407dcc2628593211db::htk8iuh51v4hadmh9oknjm3mk5','2012-10-01 07:28:59','2012-10-01 07:30:39'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::v0joidm16lbhealariiibd1v55','2012-10-01 07:30:09','2012-10-01 07:39:43'),(3,'cms::275632545653ec7d6784d3407dcc2628593211db::locs7t8clbh64ch35skdg7rm15','2012-10-01 07:30:49',NULL),(1,'cms::864d124bace03bcc8503e18d019d02d126c63505::5sjf3glfdd1potn7hfevl9a505','2012-10-01 07:31:18',NULL),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::65euh3gao9t8s8s96d80l0l4h4','2012-10-01 07:39:53','2012-10-01 07:44:11'),(3,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::4rn325cpljbnraublre5vrlao4','2012-10-01 07:44:17','2012-10-01 07:45:22'),(1,'cms::9fffa12a8989d9bca3976c7689b835dd77d9a800::8eqh02hcg281jlabqd1cft6d73','2012-10-01 07:45:32',NULL),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::jf30b36gaa6ves7d94tg31de53','2012-10-01 21:44:17','2012-10-01 22:02:27'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::llj7kvk900hdm2nsl0pnrv9bq0','2012-10-01 22:02:35',NULL),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::l2vbjvvgf12ndvu0120gm6r6l1','2012-10-01 22:17:29','2012-10-02 01:43:38'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::q5n8rmhlim81qfum6ohki6a5v4','2012-10-02 01:43:49','2012-10-02 05:59:38'),(2,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::edotisshj0b6bcn5evqrk5cue7','2012-10-02 05:59:50','2012-10-02 06:40:11'),(3,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::ksotckmvri2t4laltco3khfe56','2012-10-02 06:40:38','2012-10-02 06:41:54'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::t7qtgdkku1a8a3usaa55k33fj0','2012-10-02 06:42:20','2012-10-02 06:49:44'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::86d3c8erom7evguk7l4un5ebg2','2012-10-02 06:49:59','2012-10-02 06:50:16'),(3,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::52q8d3grb6p4b5badhi33l0ph4','2012-10-02 06:50:51','2012-10-02 06:52:41'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::9iqv5ijv46t98mrck5ven6htp6','2012-10-02 06:53:15','2012-10-02 07:08:28'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::pt5mq5mdsbjdmna3v27hldov57','2012-10-02 07:08:41','2012-10-02 07:12:24'),(3,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::jjbt1fpkh4dbjr94e77rcqblg7','2012-10-02 07:12:31','2012-10-02 07:17:44'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::o4to02asvotqogq083lepgc5f5','2012-10-02 07:17:55','2012-10-02 07:18:12'),(3,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::bu0a9dc0p0c9cd7bgecbuncmq5','2012-10-02 07:18:22','2012-10-02 07:18:28'),(1,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::av4f5168pfahk6ls687fdtnpn2','2012-10-02 07:18:36','2012-10-02 07:20:22'),(3,'cms::0c48c81aee3e44350c9db908159a6e5d651484ce::mulppdd7o6t0kd6ukd1fe627e6','2012-10-02 07:20:28',NULL),(3,'cms::7fb2908022a9fa7dc0ea0aaaaca6475a20b6f558::ivqdl6i476mkj0sndq7fpnlps0','2012-10-02 21:29:55',NULL),(1,'cms::7fb2908022a9fa7dc0ea0aaaaca6475a20b6f558::3358hh4oidudqfdqelphjriam2','2012-10-02 22:35:23',NULL),(1,'cms::b56a56aed8f294defbf1db12cc906973a5ede086::tjdav13p0g0ddhmpqa6ni79g41','2012-10-03 02:49:09',NULL),(1,'cms::b56a56aed8f294defbf1db12cc906973a5ede086::g3jc311455fh9sbjs1dhb52i26','2012-10-03 03:08:01','2012-10-03 05:33:16'),(1,'cms::a6a26a2f37bb85194d4f33b26b66fca9da4a6197::8mbtv0r4q6l8lp4voj0i4pdf13','2012-10-03 03:13:19',NULL),(3,'cms::b56a56aed8f294defbf1db12cc906973a5ede086::ike1o0riaruirusoll2t04b295','2012-10-03 05:33:23','2012-10-03 05:35:02'),(1,'cms::b56a56aed8f294defbf1db12cc906973a5ede086::3jkc2dtqb0de8e9o6ebvk76d72','2012-10-03 05:35:13',NULL),(1,'cms::fbf36bf0bd4fb43031af61b2b337d10dce3b9798::tkijf1ngmsjo1039ge4197iu21','2012-10-03 20:58:53',NULL),(1,'cms::e14679d6972bee2836b01c5f5b9de7253b80c3bc::56m331crore91gk4ijf1t7evc0','2012-10-03 21:02:28','2012-10-03 21:44:34'),(3,'cms::e14679d6972bee2836b01c5f5b9de7253b80c3bc::ji75nbq1u3q4irtfvgitl5uhj6','2012-10-03 21:44:43',NULL),(3,'cms::48195ba8ed883e4401b579b7ed2cc678b10b040a::vv62jcvcad0reeufh62e6f8ee2','2012-10-03 21:47:50',NULL),(1,'cms::e14679d6972bee2836b01c5f5b9de7253b80c3bc::f3ti3agd941tkur796edi0ksk7','2012-10-04 03:16:27','2012-10-04 03:16:48'),(3,'cms::e14679d6972bee2836b01c5f5b9de7253b80c3bc::vhcutggpkbh1oppmgqsj0nuh76','2012-10-04 03:16:56',NULL);

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` tinyint(1) DEFAULT '0',
  `role_id` smallint(6) DEFAULT NULL,
  `username` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` char(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive','banned','pending','deleted') COLLATE utf8_unicode_ci DEFAULT 'active',
  `activation_key` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `users` */

insert  into `users`(`id`,`is_system`,`role_id`,`username`,`password`,`email`,`status`,`activation_key`) values (1,1,1,'superadmin','a3e6f7e0cb6f18b71458c688c873fe3ce98b2817','deni@webarq.com','active','1stVenue'),(2,0,2,'administrator','6fa26299b59b2cfc7b7380a0afd75f1251297f0d','admin@webarq.com','active','2ndVenue'),(3,0,2,'andika','6fa26299b59b2cfc7b7380a0afd75f1251297f0d','andika@webarq.com','active',NULL),(4,0,0,'Andika1','6fa26299b59b2cfc7b7380a0afd75f1251297f0d','andika1@webarq.com','active',NULL),(5,0,0,'Andika2','a3e6f7e0cb6f18b71458c688c873fe3ce98b2817','andika2@webarq.com','active',NULL),(6,0,6,'andika3','6fa26299b59b2cfc7b7380a0afd75f1251297f0d','andika3@webarq.com','active',NULL);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
