<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Error Class Controller
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
 


class Controller_Error_Error extends Controller_Space_Html {
    protected $site;
    
    /**
     * @var string error message
     */    
    protected $message;
    
    
    public function before() {
        parent::before();
        $this->site->column        = 1;  
        
        // Internal request only!
        if (Request::$initial !== Request::$current) :
            if ($message = rawurldecode($this->request->param('message'))) :
                $this->message = $message;
            endif;
        else :
            $this->request->action(404);
        endif;
        
        //i18n::load('system/error/en');     
        $this->response->status((int) $this->request->action());
    }
    
	public function action_index() {
        $this->response->body('Error'); 
	}
    
    public function action_404() {         
        $this->meta('title',__('error_404'))
            ->set('content',$this->message)
            ->render('default/one-column');
            
//        $this->site->meta->title   = 
//        $this->site->error_title   = __('account').' '.i18n::get('error_404').' '.__('jail');
//        $this->site->error_message = $this->request->param('message'); 
//        $this->site->content       = $this->view('html/error/error');
    }   

} // End Welcome
