<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    General Api
 * @Module      General
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors
**/ 

class General extends Kohana_General {
        
    public function select_parent_menu(array $configs = array()) {
        $attr['name']  = empty($configs['name']) ? 'parent' : $configs['name'];
        $attr['value'] = empty($configs['value']) ? 0 : $configs['value'];
        $attr['class'] = 
            empty($configs['attribute']['class']) 
                ? 'traversal' 
                : $configs['attribute']['class'].' traversal';
        
        $attr = array_merge($configs['attribute'],$attr);
                
        $and_condition = null;
        
        if (!empty($attr['job']))
            $and_condition[0] = array('and_where','id != '.$attr['item_id']);
        
        return Traversal::select(array(
                'table'             => 'site_menus',
                'field_opt_value'   => 'id',
                'field_opt_text'    => 'menu_title',
                'extend_conditions' => $and_condition,
                'attributes'        => $attr
            ));
    }
    
    public static function not_found($path=null) {
        return View::factory(empty($path) ? 'html/error/error' : $path);
    }
}