<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    History Model
 * @Module      General
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_History extends Model_Base {
    
    /**
     * @param boolean execute query data or return object
     */ 
    public static function total_history($execution = TRUE) {
        return Model::factory('role')->base_total('histories','id',$execution);
    }
    
    public static function limit_history($execution = TRUE){
        $prepare =Model::factory('role')->select('ch.id','ch.time',array(DB::expr("CONCAT(first_name,' ',last_name)"),'actor'),'ch.source_id','ch.type','ch.table','chd.description')
                        ->from(array('histories','ch'))
                        ->join(array('user_details','ud'))->on('ud.user_id = ch.owner')
                        ->join(array('history_descriptions','chd'),'left')->on('chd.history_id = ch.id')
                        ->offset(Paging::$page->offset)
                        ->limit(Paging::$page->items_per_page)
                        ->order_by('id','desc');
                        
        return $execution === true ? $prepare->execute() : $prepare;
    }       
    
    public function insert_history(array $post = array(),$force=false) {            
        $source_id = $owner = $table = $type = null;       
        $config_history = Config::check('track_history');  
        if ( (!empty($config_history) && $config_history->value == 1) || $force === true ) {
            $time = date('Y-m-d h:i:s');
            extract($post);
            
            if (empty($owner)) {
                $cookie = Cookie::get('cms','absolutely_empty');
                if ($cookie != 'absolutely_empty'){
                    $user   = User::factory();
                    $user->identify($cookie);
                    $owner = $user->profile->id;
                } else {
                    $owner = 0;
                }
            }
            $execute = $this->insert('histories')
                 ->set('source_id',$source_id)
                 ->set('owner',$owner)
                 ->set('table',$table)
                 ->set('type',$type)
                 ->set('time',$time)
                 ->execute();
            
            if (!empty($description)) {
                $this->insert_history_descriptions($execute[0],$description);
            }
            
            return $execute;
        }
    }
    
    /**
     * @var mixed   int of history id or boolean whether execute query or not
     */
    public function get_history($id) {
        $get = $this->select('histories.*')->from('histories');
        
        if (is_bool($id))
            if ($id === false)
                return $get;
        else
            return $get->where('id = '.$id)->execute()->current();
                    
    }
    
    public function insert_history_descriptions($history_id,$description) {
        return $this->insert('history_descriptions')
             ->set('history_id',$history_id)
             ->set('description',$description)
             ->execute();
    }
    
    public function row_delete($id=0,$execute=true) {
        $execute = is_bool($id) ? $id : $execute;
        if ($execute === false) {
            return $this->delete('histories');
        }else {
            $this->delete('histories')->where('id = '.$id)->execute();
            $this->delete('history_descriptions')->where('history_id = '.$id)->execute();
            return true;
        }
    }
    
    public function get_time($table,$type = 'create') {
        $time = $this->select('time')->from('histories')->where('table = '.$table)
                     ->and_where('type = '.$type)
                     ->execute()->current();
        return empty($time->time) ? null :  $time->time;                    
    }
    
}