<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Banner Postion Listing View
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/  
Model::factory('library')->get_library(1);
?>

<script>
    $(document).ready(function(){
        var json = {
                        "original"      : {
                            "location"  : "<?php echo $lib->root_dir;?>"  
                        },
                        "thumb"         : {
                            "resize"    : true,
                            "width"     : "<?php echo $lib->thumb_width; ?>",
                            "height"    : "<?php echo $lib->thumb_height; ?>",
                            "location"  : "<?php echo $lib->thumb_dir;?>"
                        }    
                    };
                     
        $("#uploadify_button").uploadify({
            'buttonImage'       : '<?php echo $site->system_img;?>general/browse-file.png',
            'width'             : 160, 
            'height'            : 35,
            'fileTypeDesc'      : '<?php echo __('image_file');?>',
            'fileTypeExts'      : '<?php echo $lib->allowed;?>',
            'fileSizeLimit'     : '<?php echo $lib->file_size;?>',
            
            'formData'          : {
                                        "session"   : "<?php echo $site->cookie;?>",
                                        "temp_dir"  : "<?php echo $lib->temp_dir;?>",
                                        "directory" : JSON.stringify(json)
                                  },
            'fileObjName'       : 'image_upload',
            
            'auto'              : true,
            'swf'               : '<?php echo $site->system_js;?>party3d/uploadify3/scripts/uploadify.swf',
            'uploader'          : '<?php echo $site->bs_cms;?>medialibrary/ajax/image-upload',
            'onUploadStart'     : function(file) {
                $('#uploader_container .masking_button').show();    
            },
            'onUploadProgress'  : function(file, bytesUploaded, bytesTotal, totalBytesUploaded, totalBytesTotal) {                
                var max_progress   = parseInt($('.progress_container').css('width'));
                var progress_width = (totalBytesUploaded/totalBytesTotal)*max_progress;
                
                if (progress_width > 10) { 
                    $('.progress_container #animate, .progress_container #text').show('fast');                    
                    $('.progress_container #animate').css('width',progress_width);
                    $('.progress_container #text').html('Upload '+file.name);
                }
            },
            'onQueueComplete'   : function(queueData) {
                //console.log(queueData);
                window.location.reload();
            },
            'onUploadComplete'  : function (file) {                
                //console.log(file);
            }
            /** **/
            ,
            'onUploadSuccess'   : function(file, data, response) {
                //alert('The file ' + file.name + ' was successfully uploaded with a response of ' + response + ':' + data);
            },
            'onUploadError'     : function(file, errorCode, errorMsg, errorString) {
                alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
            }
            /** **/
        }); 
  });         
</script>
<div style="padding: 0px 0px 25px 0px;">
    <span><img src="<?php echo URL::base(true).'assets/system/images/icon/16x16/information.png' ;?>" > <span style="font-weight: bold; font-size: 12px;">For your information</span> </span>
    <ol>
        <li style="font-style: italic; margin-left: 20px;">1. Image resolution for <strong>Home Banners</strong> : Width = <strong>940px</strong>, Height = <strong>350px</strong></li>
        <li style="font-style: italic; margin-left: 20px;">2. Image resolution for <strong>Page Banner</strong> : Width = <strong>940px</strong>, Height = <strong>238px</strong></li>
    </ol>
</div>
<div id="uploader_container">    
    <div class="button_container fl">
        <div id="uploadify_button"></div>
    </div>
    <div class="masking_button"></div>
    <div class="progress_container">
        <div id="animate"></div>
        <div id="text"><?php echo __('progress_upload'); ?></div>
    </div>
    <div class="clear ls10"></div>
    <div class="horizon_separator_two"></div>
    <div class="ls5"></div>
    <?php
        if (!empty(Paging::$init->list_items[0])) {
            $index = Paging::$page->current_first_item;
            $loop  = 1;
            foreach (Paging::$init->list_items as $item) {
                echo '<div class="banner_container">';
                    echo '<div class="banner_item">';
                        echo HTML::image($lib->thumb_dir.'/'.$item->file_name,array(
                            'alt' => $item->file_name,
                            'title'  => $item->file_name,
                            'style'  => "width:60px;"
                        ));
                    echo '</div>';
                    echo '<div class="banner_description">';
                        echo __('used_banner',array(
                                '%total' => $item->total_used,
                                '%times' => $item->total_used <= 1 ? 'time' : 'times'
                            ));
                        echo '<div class="ls5"></div>';
                        if ($item->total_used <=0) {
                            echo Form::list_action($site,'delete',array(   
                                        'title' => __('delete_banner'),
                                        "href"   => $site->bs_cms.'medialibrary/ajax/delete-media/'.$item->id,
                                        'class' => 'ajax',
                                        "i_have" => '{
                                                "type" : "image",
                                                "file" : "'.$item->file_name.'",
                                                "session": "'.$site->cookie.'",
                                                "message": [{
                                                            "title":"'.__('confirmation').'",
                                                            "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('banner'.' '.$item->file_name))).'"
                                                        }]
                                            }',
                                    ));
                        }
                    echo '</div>';
                echo '</div>';
                
                if ($loop % 4 == 0 || $loop == count(Paging::$init->list_items)) {
                    echo '<div class="clear ls10"></div>';
                }
                $index++;
                $loop++;
            }
        }
    ?>
    <div class="clear ls10"></div>
    <div class="horizon_separator_two"></div>
    <div class="ls5"></div>
    <div class="right">
    <?php
        if (!empty(Paging::$init->list_items[0])) {
            echo Paging::$page->render();
        }
    ?>
    </div>
</div>
 

<div class="clear ls5"></div>

<?php     
    $img_library = ImageLibrary::factory();
    $img_library->resize_as_position(4,1); 
?>