<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      News
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_News_Manage extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'news_list';
        $this->authorized(array(
                'news' => 'create,edit,delete,view',
            )); // Check permission           
         
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Filter Condition
        $filter = $this->site->session->get('filter');        
        if (!empty($filter['news-category'])) {
            $infilter = 0;
            foreach ($filter['news-category'] as $key => $value) {
                if (!empty($value)) {
                    if ($infilter <= 0) 
                        Paging::$init->list_items->and_where_open();                        
                    Paging::$init->list_items->or_where('news.news_category_id = '.$key);
                    $infilter++;
                }
            }
            if ($infilter >= 1) 
                Paging::$init->list_items->and_where_close();
        }
        // Search Condition
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('news.id = '.$value_condition)
            ->or_where('news.news_title like %'.$value_condition.'%')
            ->or_where('news.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'news',
                    'items_per_page' => 10
                ));            
            Paging::$init->list_items->order_by('news_date','desc');            
            $this->condition();
            Paging::$init->compile();
            
            $content  = $this->html('news-list')->set('categories',Model::factory('newscategory')
                            ->limit_newscategory());
                                    
            $this->meta('title',__('manage_news'))
                 ->set('title',__('manage_news'))
                 ->set('content',$content)
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        $this->styles(array(
                 $this->site->system_css.'js/ui/base/jquery.ui.all' => 'screen,projection'
            ));
        $this->scripts(array(
                $this->site->system_js.'library/ui/jquery.ui.datepicker.min.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
        // Extend permission
        $class_action = $this->param1;
        $this->authorized(array('news' => $class_action));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('news',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('news')->get_by('field','id',$this->param2)->current();
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('news-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
    }
    
    public function action_save() {        
        $this->authorized(array(
            'news' => 'create'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => 'news',
                       'form'           => 'news',
                       'owner'          => $this->site->user->profile->id
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('news_category')))));
                    $this->request->redirect('admin-cp/news/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/news/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'news' => 'edit_category'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package'        => 'news',
                       'form'           => 'news',
                       'owner'          => $this->site->user->profile->id
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/news/manage/form/edit/'.$this->param1);
    }
    
    public function action_delete_news() {       
        $this->authorized('news','delete');
        if ($this->authorisation) {            
           $delete = Transaction::delete('news')
                        ->owner($this->site->user->profile->id,$this->site->user->profile->full_name)
                        ->history_item('news_title')
                        ->row($this->param1)
                        ->execute($result);
                            
        }
        $this->request->redirect('admin-cp/news/manage');
    }
}
   

?>