<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Cms Ajax User Class Controller
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Order_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();
    }
    
    /*** delete attention ***/
    public function action_delete_attention() {
        $result = false;  
        $delete = $this->db->delete('attentions')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete industry ***/
    public function action_delete_industry() {
        $result = false;  
        $delete = $this->db->delete('industries')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete country ***/
    public function action_delete_country() {
        $result = false;  
        $delete = $this->db->delete('countries')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*** delete country ***/
    public function action_delete_inquiry() {
        $result = false;  
        $delete = $this->db->delete('inquiry_logs')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    /*
     * check captcha validation;
     */
    public function action_view_inquiry(){
        $ret = array(
                    'id'=>'',
                    'title'=>'',
                    'name'=>'',
                    'phone'=>'',
                    'fax'=>'',
                    'email'=>'',
                    'company'=>'',
                    'industry'=>'',
                    'country'=>'',
                    'attention'=>'',
                    'message'=>'',
                    'status'=>''
                );
        
        $inquiry_id = Arr::get($this->request->initial()->post(), 'inquiry_id');                  
        $inquiry_detail = Model::factory('inquiry')->get_inquiry($inquiry_id);
                        
        if(!empty($inquiry_detail)){
            foreach($inquiry_detail as $data){
                $ret = array(
                    'id'=>$data->id,
                    'title'=>$data->title,
                    'name'=>$data->name,
                    'phone'=>$data->phone,
                    'fax'=>$data->fax,
                    'email'=>$data->email,
                    'company'=>$data->company,
                    'industry'=>$data->industry,
                    'country'=>$data->country,
                    'attention'=>$data->attention,
                    'message'=>$data->message,
                    'status'=>$data->status
                );
            }
        }
        
        $this->ajax = json_encode($ret);
    }
    
   /*
     * check captcha validation;
     */
    public function action_check_captcha(){
        $code = Arr::get($this->request->initial()->post(), 'code');
        $valid = Captcha::valid($code);
        
        $ret = array('result'=>$valid);

        $this->ajax = json_encode($ret);
    }
    
    /*
     * send email
     */
    public function action_send_email(){
        
        $name = Arr::get($this->request->initial()->post(), 'name');
        $phone = Arr::get($this->request->initial()->post(), 'phone');
        $fax = Arr::get($this->request->initial()->post(), 'fax');
        $email = Arr::get($this->request->initial()->post(), 'email');
        
        $company = Arr::get($this->request->initial()->post(), 'company');
        $industry = Arr::get($this->request->initial()->post(), 'industry');
        $country = Arr::get($this->request->initial()->post(), 'country');        
        
        $subject = Arr::get($this->request->initial()->post(), 'subject');
        $message = Arr::get($this->request->initial()->post(), 'message');
        $code = Arr::get($this->request->initial()->post(), 'code');
        $attention = Arr::get($this->request->initial()->post(), 'attention');
        
        $send_email = $this->send_message(
                    $name, $phone, $fax, $email, 
                    $company, $industry, $country,
                    $subject, $message, $attention, $code
                );
        
        if($send_email){
            $save_inquiry = $this->save_inquiry(
                    $name, $phone, $fax, $email, 
                    $company, $industry, $country,
                    $subject, $message, $attention
                );            
            $ret = ($save_inquiry)?array('result'=>'success'):array('result'=>'failed');            
        } else {
            $ret = array('result'=>'failed');
        }
            
        $this->ajax = json_encode($ret);
    }
    
    
    /*
     * send message throught email
     */
    private function send_message($name=null, $phone=null, $fax=null, $email=null, $company=null, $industry=null, $country=null, $subject=null, $message=null, $attention=null, $code=null) {
        $msg = '';
        
        $msg = "<style>#email-body {font-family:Arial,FreeSans,Helvetica,sans-serif;font-size:12px;}</style>";
        $msg .= "<div id=\"email-body\">";
        $msg .= "<strong>Dear Admin</strong>,<br /><br />You have new message from:<br/><br/>" .                
                "Name    : " . $name . "<br />" .
                "Phone   : " . $phone . "<br/>" .
                "Email   : " . $email. "<br/>" .               
                "<br />Message: <br />" .
                "$message" .
                "<br /><br /><br /></div>";
        $msg .= "<div>";
        $msg .= "Best Regards,<br/>
                <strong>Golden Agin Inquiry form</strong>";
        $msg .= "</div>";

        $send_email = Email::factory($subject, html_entity_decode($msg), 'text/html')
                        ->to($attention)
                        //->from('deni@localhost', ' goldenagin website ')
                        ->from($email, ' goldenagin website ')
                        ->send();
        
        if($send_email){
            return true;
        } else {
            return false;
        }
    }
    
    
   /*
   * 
   */
    private function save_inquiry($name=null, $phone=null, $fax=null, $email=null, $company=null, $industry=null, $country=null, $subject=null, $message=null, $attention=null){
        $save_inquiry = Model::factory('order')
                ->save_inquiry($name, $phone, $fax, $email, $company, $industry, $country, $subject, $message, $attention);
        
        $ret = ($save_inquiry)?true:false;       
        return $ret;
    }
    
}