<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Cms Class Controller
 * @Module      Product
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Product_Category extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'product-category-list';
        $this->authorized(array(
                'product' => 'create_product_category,edit_product_category,delete_product_category,view_product_category',
            )); // Check permission           
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('product_categories.id = '.$value_condition)
            ->or_where('product_categories.title like %'.$value_condition.'%')
            ->or_where('product_categories.description like %'.$value_condition.'%')
            ->or_where('product_categories.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_manage();
    }
    
    public function action_manage() {
         
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'productcategory',
                    'items_per_page' => 10
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_product_category'))
                 ->set('title',__('manage_product_category'))
                 ->set('content',$this->html('product-category-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        $this->styles(array(
                 $this->site->system_css.'js/ui/base/jquery.ui.all' => 'screen,projection'
            ));
        $this->scripts(array(
                //$this->site->system_js.'party3d/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
        // Extend permission
        $class_action = $this->param1;
        $this->authorized(array('product' => $class_action.'_product_category'));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('product_category',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('productcategory')->get_by('field','id',$this->param2)->current();
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('product-category-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
        
    }
    
    public function action_save() {        
        $this->authorized(array(
            'product' => 'create_product_category'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => 'product',
                       'form'           => 'product_category',
                       'owner'          => $this->site->user->profile->id
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('product')))));
                    $this->request->redirect('admin-cp/product/category/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/product/category/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'product' => 'edit_product_category'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package'        => 'product',
                       'form'           => 'product_category',
                       'owner'          => $this->site->user->profile->id
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/product/category/manage/form/edit/'.$this->param1);
    }
}