<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author             Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Product Api Class
 * @Module             News
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Product extends Kohana_Product {
    
    public static function input_order_category(array $data = null) {
        $data['table'] = 'product_categories';
        return General::factory($data)->input_order();
    }
    
    public static function select_category(array $data = null) {
        $categories = Model::factory('productcategory')
                        ->limit_productcategory(false)                        
                        ->order_by('product_categories.id')
                        ->execute();
        
        $options = array(''=>__('select_one'));
        if (!empty($categories[0])) 
            foreach ($categories as $category)
                $options[$category->id] = $category->title;
        
        return Form::select($data['name'],$options,$data['value'],$data['attribute']);
    }
    
    public static function select_product(array $data = null, $category_id = null) {
        $products = Model::factory('productitem')
                        ->limit_productitem(false)
                        ->where('product_category_id', '=', $category_id)
                        ->order_by('product_items.id')
                        ->execute();
        
        $options = array(''=>__('select_one'));
        if (!empty($products[0])) 
            foreach ($products as $product)
                $options[$product->id] = $product->title;
        
        return Form::select($data['name'],$options,$data['value'],$data['attribute']);
    }
    
}