<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Product Download List
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'product/download/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'product/download/form/create'); ?></div>    
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('title');?></th>
            <th class="title"><?php echo __('Product Category');?></th>
            <th class="title"><?php echo __('Product Item');?></th>
            <th class="addres"><?php echo __('pdf_file');?></th>
            <th class="status"><?php echo __('status');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {
                    $modify_class = __make_class($index,$item->status);
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$item->title.'</td>';
                        
                        $product_category = Model::factory('product')->get_category_name($item->product_category_id);  
                        $product_item = Model::factory('product')->get_item_name($item->product_item_id); 
                        echo '<td>'.$product_category.'</td>';
                        echo '<td>'.$product_item.'</td>';
                        
                        echo '<td class="center">';
                        echo (!empty($item->file_path))?HTML::anchor(URL::base(true).$item->file_path, HTML::image(Config::$site_config->themes_img.'cms/icon/pdf.png')):'';
                        echo '</td>';
                        echo '<td class="center">'.$item->status.'</td>';
                        echo '<td class="center">';
                            $list_action  = $item->status == 'active' ? 'deactivate' : 'activate';
                            $update_value = $item->status == 'active' ? 'inactive' : 'active';
                              
                            echo Form::list_action($site,$list_action,array(   
                                    "class"  => "ajax",
                                    "href"   => $site->bs_cms.'system/ajax/update-status/product_downloads/'.$update_value.'/'.$item->id,
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('product').' '.$item->title)).'"
                                                    }]
                                        }',
                                ));
                            echo '&nbsp; &nbsp;';
                            
                            echo Form::list_action($site,'edit',array(   
                                    'title' => __('edit_user'),
                                    'href'  => $site->bs_cms.'product/download/form/edit/'.$item->id
                                ));
                            echo '&nbsp; &nbsp;';
                                                      
                            echo Form::list_action($site,'delete',array(   
                                    'title' => __('delete_role'),
                                    "href"   => $site->bs_cms.'product/ajax/delete-download/'.$item->id,
                                    'class' => 'ajax',
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('product_download'.' '.$item->title))).'"
                                                    }]
                                        }',
                                ));
                                echo '&nbsp; &nbsp;';
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="9">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="8">
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    