<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Class Pakcage Handler
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Kohana_Package { 
    /**
     * @var object pacakage;
     */ 
    public static $init;
    
    public $dbtype  = '';
    
    private $db_length    = array (
            'tinyint'  => 4,
            'smallint' => 6,
            'int'      => 11,
            'bigint'   => 20,
            'char'     => 25,
            'varchar'  => 255
        );        
    private $db_should_collate  = array(
            'tinytext','text','mediumtext','longtext'
        ); 
    private $db_allowed_unsigned = array (
            'tinyint','smallint','int','bigint','float','decimal','double'
        );  
        
    private $db_null      = TRUE;
    private $db_unsigned  = FALSE;
    private $db_increment = FALSE;
    private $db_zerofill  = FALSE;
    private $db_create    = TRUE;
    private $db_comment   = NULL;     
    private $db_charset   = 'utf8';
    private $db_collate   = 'utf8_unicode_ci';
    private $db_engine    = 'MyISAM';
    private $db_default   = 'NULL';
    
    
    private $uniq_id = 0;
    /**
     * Initiate Package
     * @return  object package
     */
    public static function instance() {
        return self::$init = new Package;
    }
    
    /**
     * @var     string package kohana name
     * @return  install package and insert dummy data
     * @example Package::install('verse');
     */
    public function install($package) {
        $this->uniq_id++;
        
        $this->create_db();
        
        if (Kohana::$environment == Kohana::DEVELOPMENT) {
            $config_package = Kohana::$config->load('package/'.$package);
            
            if (!empty($config_package->configuration)) {
                $this->create_table(json_decode($config_package->configuration));
            }
            if (!empty($config_package->alter_configuration)) {
                $this->alter_table(json_decode($config_package->alter_configuration));
            }
            if (!empty($config_package->mandatory)) {
                $this->insert_row_table(json_decode($config_package->mandatory));
            }
            if (!empty($config_package->dummies)) {
                $this->insert_row_table(json_decode($config_package->dummies));
            }
        }
    }
    
    public function create_db($dbname = NULL) {
        if (empty($dbname)) {
            $config = Kohana::$config->load('database');
            if (!empty($config->default)) {
                $dbname = empty($config->default['connection']['database']) ? null : $config->default['connection']['database'];
            }
        }        
        if (empty($dbname)) die('No databases');
        
        $query_create_db = "CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        //Database::instance('default')->query(Database::INSERT,$query,true);
    }
    
    /**
     * @var object kohana configuration json
     * @return  install package
     */
    public function create_table($configuration) {
        foreach ($configuration as $table => $fields) { // Looping for table
            $primaries = null;
            $query  = "CREATE TABLE IF NOT EXISTS `$table` ( ";        
            $commas = false;    
            foreach ($fields as $field => $setting) { // Looping for field        
                if (!empty($setting->type)) {        
                    $query .= $commas === true ? ', ' : '';
                    $query .= $this->setting_field_attribute($field,$setting);
                    $setting->field_name = $field;
                    $commas = true;
                    
                    // Primary Preparation
                    !empty($setting->primary) && $setting->primary === TRUE ? $primaries[$field] = $field : '';
                }
            }
            $query .= $this->db_set_primary($primaries);
            $query .= ") ENGINE ";
            $query .= empty($setting->engine) ? $this->db_engine : $setting->engine; // Engine
            $query .= " DEFAULT CHARSET ";
            $query .= empty($setting->charset) ? $this->db_charset : $setting->charset; // Charset
            $query .= " COLLATE ";
            $query .= empty($setting->collate) ? $this->db_collate : $setting->collate; // Collate
            
            //echo $query.'<br/><br/>';
            DB::query(Database::INSERT,$query)->execute();
        }     
    }
    
    /**
     * @var object kohana configuration
     */
    public function alter_table($configuration) {
        /**
         * ALTER TABLE `wcms-db`.`news` 
         * ADD COLUMN `ban2` CHAR(5) NULL AFTER `char2`, 
         * ADD COLUMN `ban3` CHAR(6) NULL AFTER `ban2`
         */
         foreach ($configuration as $table => $fields) {
            $query  = "ALTER IGNORE TABLE `$table` ";      
            $commas = false;    
            $alter  = false; // Alter table false
            $primaries = $existing_primary = null;
            
            foreach ($fields as $field => $setting) { // Looping for field        
                if (!empty($setting->type)) {
                    $add_column = true;
                    /** 01. Get existing table columns **/
                    $columns   = DB::query(Database::SELECT,"SHOW columns FROM `$table`")->execute();            
                    if (!empty($columns[0])) {
                        foreach ($columns as $column) {
                            $object_column = helper_tool::arr_to_object($column);
                            if ($object_column->field == $field ) {
                                $add_column = false;
                            }
                            if ($object_column->key === 'PRI' && $alter === false) 
                                $primaries .= empty($primaries) 
                                        ? "`$object_column->field`"
                                        : ",`$object_column->field`";
                        } 
                        
                        $setting->after = !empty($setting->after)
                                ? $setting->after
                                : ($alter === false ? $object_column->field : $previous_after);
                        $previous_after = $field;
                    }
                    if ($add_column === true) {
                        $query .= $commas === true ? ', ' : '';
                        $query .= 'ADD COLUMN '.$this->setting_field_attribute($field,$setting);                        
                        $query .= !empty($setting->after) ? "AFTER `$setting->after` " : "";
                        $alter  = true; // Alter table true
                        $commas = true;    
                    }    
                    !empty($setting->primary) && $setting->primary === TRUE 
                        ? ($primaries .= empty($primaries) ? "`$field`" : ",`$field`") 
                        : '';
                }
            }
            if (!empty($primaries)) {
                $query .= ', DROP PRIMARY KEY, ADD PRIMARY KEY('.$primaries.')';
            }
            
            // Run query
            //echo $query.'<br/>';
            if ($alter === true)
                DB::query(Database::INSERT,$query)->execute();
         }
    }
    
    /**
     * @var string field name
     * @var object field settings
     */
    protected function setting_field_attribute($field,$setting) {
        
        $query  = $this->db_set_length($field,$setting);
        $query .= $this->db_set_enumeration($setting);    
        $query .= $this->db_set_unsigned($setting);
        $query .= $this->db_set_zero($setting);    
        $query .= $this->db_set_collate($setting);
        $query .= empty($setting->notnull) ? "" : " NOT NULL ";   
        $query .= $this->db_set_default($setting);
        $query .= empty($setting->increment) ? "" : " AUTO_INCREMENT ";    
        $query .= empty($setting->comment) ? "" : " COMMENT '$comment' ";
        
        return $query;
    }
    
    /**
     * @var object kohana dummy json
     * @return  insert row data to table
     */
    public function insert_row_table($data, $ignore = true, $history = true) { 
        if (is_string($data)) $data = json_decode($data);
        $source_id = 0;
        $model_base = Model::factory('base');
        
        foreach ($data as $table => $rows){
            foreach ($rows as $row) {
                $query  = $ignore === true ? "INSERT IGNORE INTO `$table`" : "INSERT INTO `$table`";
                $query .= "(";
                $query_value = '';
                $set_comma = false;
                $source_id = 0;
                
                foreach ($row as $field => $value);                
                $model_base->select($field)->from($table);
                          
                foreach ($row as $field => $value) {
                    // Manipulate Value
                    $value = $this->check_for_value($value);
                    
                    // We do not check id or ordering field
                    if ($field != 'id' && $field != 'ordering') {
                        if ($set_comma === false)
                            $model_base->where($field,'=',$value);
                        else {
                            if ($table == 'site_menus')
                                $model_base->or_where($field,'=',$value);
                            else
                                $model_base->and_where($field,'=',$value);
                        }
                    }
                                            
                    $source_id = $field == 'id' ? $value : $source_id;
                                                       
                    $query .= $set_comma === true ? ",`$field`" : "`$field`";
                    if ($value == 'auto' && ($field == 'id' || $field == 'ordering')) {
                        $count = Database::instance('default')->query(Database::SELECT,"SELECT COUNT(id) AS `total` FROM `histories`",true);
                        $value = $count+1;    
                    }
                    $query_value .= $set_comma === true ? ",'$value'" : "'$value'";
                    $set_comma = true;
                }
                                
                $query .= ") VALUES ($query_value)";
                
                
                //Safety row check
                $get_row = $model_base->as_object()->execute();
                if (empty($get_row[0]))
                    $insert_ignore = DB::query(Database::INSERT,$query)->execute();
                else
                    $insert_ignore = NULL;
                
                if (is_array($insert_ignore) && count($insert_ignore) == 2 && $insert_ignore[1] == 1)  {
                    if (empty($source_id)) {
                        $source_id = $insert_ignore[0];    
                    }
                    
                    if ($history === true) {
                        // Insert To History
                        Model::factory('history')->insert_history(
                            array(
                                'source_id'=>$source_id,
                                'owner'=>1,
                                'table'=>$table,
                                'type'=>$this->history_type($table),
                                'time'=>date('Y-m-d h:i:s')
                            ));
                    }
                }
            }
        }    
        
        return empty($source_id) ? $insert_ignore : $source_id;
    }
    
    /**
     * @param   string value to check   
     */
    
    public function check_for_value($value = null) {
        if (is_object($value)) {
            return json_encode($value);
        }
        if (strpos(trim(strtolower($value)),'select') !== false) {
            $do_value = DB::query(Database::SELECT,$value)->as_object()->execute();
            $value = empty($do_value[0]) ? 0 : $do_value[0]->id;     
        }
        return $value;
    }
    
    /**
     * @var string  field name
     * @var object  json decode result
     */
    public function db_set_length ($field,$setting) {
        if (array_key_exists($setting->type,$this->db_length)) {
            $length = empty($setting->length) ? $this->db_length[$setting->type] : $setting->length;
            return "`$field` $setting->type ($length)  ";  
        }else {  
            return "`$field` $setting->type ";
        }
    }
    
    /**
     * @var object  json decode result
     */    
    public function db_set_enumeration($setting) {
        if ($setting->type === 'enum') {
            $query  = "('";
            $query .= empty($setting->option) 
                        ? "active','inactive"
                        : str_replace(',',"','",$setting->option);
            $query .= "') ";
            return $query;
        }
    }
    
    /**
     * @var object  json decode result
     */    
    public function db_set_unsigned($setting) {
        $unsigned = !isset($setting->unsigned) ? $this->db_unsigned : $setting->unsigned;
        return $unsigned === TRUE && in_array($setting->type,$this->db_allowed_unsigned) ? " UNSIGNED" : '';
    }
    
    /**
     * @var object  json decode result
     */    
    public function db_set_zero($setting) {
        $zerofill = !isset($setting->zerofill) ? $this->db_zerofill : $setting->zerofill;
        return $zerofill === TRUE && in_array($setting->type,$this->allowed_unsigned) ? " ZEROFILL" : "";
    }
    
    /**
     * @var object  json decode result
     */    
    public function db_set_collate($setting) {
        if (in_array($setting->type,$this->db_should_collate)) {
            return empty($setting->collate) ? " COLLATE ".$this->db_collate." " : " COLLATE ".$setting->collate." ";    
        }
    }
    
    /**
     * @var object  json decode result
     */    
    public function db_set_default($setting) {
        $default = !isset($setting->default) ? $this->db_default : "'".$setting->default."'" ;
        return empty($setting->primary) && empty($setting->notnull) ? " DEFAULT ".$default." " : "";
    }
    
    /**
     * @var array field primary key
     */    
    public function db_set_primary($primaries) {
        if (!empty($primaries) && is_array($primaries)){
            $count_primary = 1;
            $query = ', PRIMARY KEY  (';
            foreach ($primaries as $key_primary=>$name_primary){
                $query .= "`$name_primary`";
                $query .= $count_primary < count($primaries) ? ',' : '';
                $count_primary++;
            }
            $query .= ')';
            return $query;
        }    
    }
    
    
        
    /**
     * @var     object  pakcage kohana object
     * @var     mixed   pakcage kohana configuration group name or array new package kohana configuration
     * @uses    Calling from package kohana class factory funtionc, to altering class with new configuration     
     */     
    public function populate(&$package, $new_configuration = NULL) {
        $config_file  = strtolower(get_class($package));           
        $load_conf    = Kohana::$config->load($config_file); // Load package kohana config
        $package_conf = !empty($load_conf->default) ? $load_conf->default : array(); // First load default config.
                
        if (!empty($new_configuration) && 
            $new_configuration != 'default' && 
            !is_array($new_configuration) && 
            !empty($load_conf->$new_configuration) && 
            is_array($load_conf->$new_configuration)) {
                                
                $package_conf = array_merge($package_conf,$load_conf->$new_configuration);    
        }elseif(is_array($new_configuration)) {
            $package_conf = array_merge($package_conf,$new_configuration);
        }
        
        $this->setup($package,$package_conf);
        
        return $package;
    }
    
    /**
     * @var     object  object module to be wrote
     * @var     array   A set of pairs to write
     * @return  object  object module after wrote, Note. Passing by reference 
     */
	public function setup(&$load_package = NULL,array $config = array()) {
        if (!empty($load_package)){
            $config = isset($load_package->config) 
                        ? $config + $load_package->config : $config; // Current config overwrite
            
                
            $config = isset($load_package->configs)
                        ? $config + $load_package->configs : $config; // Current config overwrite
                        
            foreach ($config as $key=>$value) { // Recursive set each config as module object var
                    if ($key == 'model') {
                        if (is_array($value)) {
                            foreach ($value as $value2) {                                
                                $value2 = strtolower($value2);
                                $model_name = 'model_'.$value2;                              
                                Kohana::find_file('classes/model/',$value2)
                                    ? $load_package->$model_name = Model::factory($value2)
                                    : '';
                            }
                        } else {
                            $value = strtolower($value);
                            $model_name = 'model_'.$value;                                                                                                           
                            Kohana::find_file('classes/model/',$value)
                                ? $load_package->$model_name = Model::factory($value)
                                : '';
                        }
                    }
                    $load_package->$key = $value;
            }
        }
        
        // Set Module Model
        Package::set_model($load_package);
        
        $load_package->tool = new Helper_Tool; 
	}    
    
    public function set_model(&$load_package,$optional_name = '') {
        
        $model_name = !empty($optional_name) ? $optional_name : strtolower(get_class($load_package));
        $check_file = Kohana::find_file('classes/model/',$model_name);
        
        $sys_instance = Kohana::$config->load('sys');     
        if ($check_file) {            
            $package_model_name = 'model_'.strtolower($model_name);
            $load_package->$package_model_name = !isset($load_package->$package_model_name)
                    ? Model::factory($model_name)
                    : $load_package->$package_model_name;
            
            //Set  instance module model  
            if (!empty($sys_instance->_db_group)) 
                $load_package->$package_model_name->_db_group = $sys_instance->_db_group;
                
        }else{            
            $load_package->db   = Model::factory('Base');    
            
            //Set  instance model verse       
            if (!empty($sys_instance->_db_group)) 
                $load_package->db->_db_group = $sys_instance->_db_group;    
        }
    }
    
    public static function is_module($module_name=NULL) {
        if (empty($module_name)) return false;
        
        $check = DB::select('code')->from('modules')->where('code','=',strtolower($module_name))->as_object()->execute();
        return !empty($check[0]) ? true : false;
    }
    
    public function history_type($key = NULL) {
        $array = array (
                'languages' => 'install',
                'modules' => 'install',
                'users' => 'register',
                'user_details' => 'update',
                'module_menu_positions' => 'set',
                'module_menu_permissions' => 'add',
                'permissions' => 'create',
                'user_role_permissions' => 'allow'                
            );
        
        return empty($key) ? 'create' : ( empty($array[$key]) ? 'create' : $array[$key]);        
    }
}
    
if ( !function_exists('__make_class')) {
    function __make_class($index = null ,$status = null) {
        $class = $index % 2 == 0 ? 'listing_odd' : 'listing_even';    
        $class = $status == 'inactive' || $status == 'unpublish'
            ? 'listing_inactive'
            : $class;
        
        $class = empty($index) && empty($status) ? 'listing_general' : $class; 
        return $class;        
    }    
}

?>