/*
SQLyog Ultimate v9.02 
MySQL - 5.5.16 : Database - wcms-db
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`wcms-db` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci */;

USE `wcms-db`;

/*Table structure for table `ceos` */

DROP TABLE IF EXISTS `ceos`;

CREATE TABLE `ceos` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `prefix` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domicile` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `incumbency_start` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `incumbency_end` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fullname` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `detail` text COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `ceos` */

/*Table structure for table `comments` */

DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `table_row_id` int(11) DEFAULT NULL,
  `comment` mediumtext COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `comments` */

/*Table structure for table `configs` */

DROP TABLE IF EXISTS `configs`;

CREATE TABLE `configs` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `value` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `configs` */

insert  into `configs`(`id`,`description`,`value`) values ('track_history','1 for On and 0 for Off','{\"value\":\"1\"}');

/*Table structure for table `contact` */

DROP TABLE IF EXISTS `contact`;

CREATE TABLE `contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `contact` */

/*Table structure for table `events` */

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `location` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `events` */

insert  into `events`(`id`,`title`,`permalink`,`start_date`,`end_date`,`location`,`description`,`status`) values (2,'Espada No. 9','espada-no-9','2012-08-02 16:45:00','2012-08-04 16:45:00','Dimana Aja','<p>\n	<span style=\"color: rgb(0, 0, 0); font-family: arial; font-size: 13px; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); display: inline !important; float: none; \">Auctor cras augue nunc, hac augue eu porta, a pulvinar mattis porta sed arcu, ac! In nunc sagittis tristique diam pid cursus, et, arcu sit, in eu diam proin. Ultrices magna velit enim! Eu augue eu in? Dapibus tincidunt sagittis amet ac mus sit, porta magnis pellentesque, duis, lectus cum purus turpis urna velit pulvinar vel egestas proin nunc ac ac ac? Cras elementum, cursus!</span></p>\n<p>\n	<span style=\"color: rgb(0, 0, 0); font-family: arial; font-size: 13px; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); display: inline !important; float: none; \">Quis mid odio mid nisi, egestas porta porta urna nascetur. Urna, vel! Dis mattis, magnis, in in scelerisque enim quis ac, lorem pulvinar? Tempor turpis ac porta nunc enim, mid amet scelerisque enim a a in pellentesque sit sit. Porttitor est auctor amet. Tincidunt? Cursus aliquet facilisis, sit ridiculus facilisis! Hac, tempor proin sit facilisis sed mus, ut. Amet cursus placerat ac cras, lacus velit, purus sed! Et porttitor tempor facilisis. Turpis vel sed adipiscing, platea tincidunt, placerat lacus, aenean ut nunc a. Etiam phasellus porta enim in, rhoncus.</span></p>\n','active');

/*Table structure for table `histories` */

DROP TABLE IF EXISTS `histories`;

CREATE TABLE `histories` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source_id` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(11) DEFAULT NULL,
  `table` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=166 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `histories` */

insert  into `histories`(`id`,`source_id`,`owner`,`table`,`type`,`time`) values (1,'track_history',1,'configs','create','2012-08-13 10:11:44'),(2,'1',1,'site_menu_positions','create','2012-08-13 10:11:44'),(3,'2',1,'site_menu_positions','create','2012-08-13 10:11:44'),(4,'1',1,'site_menus','create','2012-08-13 10:11:44'),(5,'0',1,'site_menu_position_applications','create','2012-08-13 10:11:44'),(6,'en',1,'languages','install','2012-08-13 10:11:44'),(7,'id',1,'languages','install','2012-08-13 10:11:44'),(8,'template',1,'modules','install','2012-08-13 10:11:44'),(9,'system',1,'modules','install','2012-08-13 10:11:44'),(10,'system_2',1,'module_menus','create','2012-08-13 10:11:44'),(11,'system_1',1,'module_menus','create','2012-08-13 10:11:45'),(12,'system_3',1,'module_menus','create','2012-08-13 10:11:45'),(13,'1',1,'module_menu_positions','set','2012-08-13 10:11:45'),(14,'2',1,'module_menu_positions','set','2012-08-13 10:11:45'),(15,'3',1,'module_menu_positions','set','2012-08-13 10:11:45'),(16,'1',1,'roles','create','2012-08-13 10:11:45'),(17,'2',1,'roles','create','2012-08-13 10:11:45'),(18,'3',1,'roles','create','2012-08-13 10:11:45'),(19,'1',1,'users','register','2012-08-13 10:11:45'),(20,'2',1,'users','register','2012-08-13 10:11:45'),(21,'3',1,'users','register','2012-08-13 10:11:45'),(22,'0',1,'user_details','update','2012-08-13 10:11:45'),(23,'0',1,'user_details','update','2012-08-13 10:11:45'),(24,'0',1,'user_details','update','2012-08-13 10:11:45'),(25,'user',1,'modules','install','2012-08-13 10:11:45'),(26,'1',1,'permissions','create','2012-08-13 10:11:45'),(27,'2',1,'permissions','create','2012-08-13 10:11:45'),(28,'3',1,'permissions','create','2012-08-13 10:11:45'),(29,'4',1,'permissions','create','2012-08-13 10:11:45'),(30,'5',1,'permissions','create','2012-08-13 10:11:45'),(31,'6',1,'permissions','create','2012-08-13 10:11:45'),(32,'7',1,'permissions','create','2012-08-13 10:11:45'),(33,'8',1,'permissions','create','2012-08-13 10:11:45'),(34,'user_1',1,'module_menus','create','2012-08-13 10:11:45'),(35,'user_2',1,'module_menus','create','2012-08-13 10:11:45'),(36,'user_3',1,'module_menus','create','2012-08-13 10:11:45'),(37,'user_4',1,'module_menus','create','2012-08-13 10:11:45'),(38,'1',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(39,'2',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(40,'3',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(41,'4',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(42,'5',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(43,'6',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(44,'7',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(45,'4',1,'module_menu_positions','set','2012-08-13 10:11:45'),(46,'5',1,'module_menu_positions','set','2012-08-13 10:11:45'),(47,'6',1,'module_menu_positions','set','2012-08-13 10:11:45'),(48,'7',1,'module_menu_positions','set','2012-08-13 10:11:45'),(49,'1',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(50,'2',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(51,'3',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(52,'4',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(53,'5',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(54,'6',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(55,'7',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(56,'8',1,'user_role_permissions','allow','2012-08-13 10:11:45'),(57,'page',1,'modules','install','2012-08-13 10:11:45'),(58,'9',1,'permissions','create','2012-08-13 10:11:45'),(59,'10',1,'permissions','create','2012-08-13 10:11:45'),(60,'11',1,'permissions','create','2012-08-13 10:11:45'),(61,'12',1,'permissions','create','2012-08-13 10:11:45'),(62,'page_1',1,'module_menus','create','2012-08-13 10:11:45'),(63,'8',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(64,'9',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(65,'10',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(66,'11',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(67,'8',1,'module_menu_positions','set','2012-08-13 10:11:45'),(68,'comment',1,'modules','install','2012-08-13 10:11:45'),(69,'comment',1,'module_menus','create','2012-08-13 10:11:45'),(70,'9',1,'module_menu_positions','set','2012-08-13 10:11:45'),(71,'ceo',1,'modules','install','2012-08-13 10:11:45'),(72,'13',1,'permissions','create','2012-08-13 10:11:45'),(73,'14',1,'permissions','create','2012-08-13 10:11:45'),(74,'15',1,'permissions','create','2012-08-13 10:11:45'),(75,'16',1,'permissions','create','2012-08-13 10:11:45'),(76,'ceo',1,'module_menus','create','2012-08-13 10:11:45'),(77,'12',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(78,'13',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(79,'14',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(80,'15',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(81,'10',1,'module_menu_positions','set','2012-08-13 10:11:45'),(82,'1',1,'media_positions','create','2012-08-13 10:11:45'),(83,'2',1,'media_positions','create','2012-08-13 10:11:45'),(84,'medialibrary',1,'modules','install','2012-08-13 10:11:45'),(85,'image_library',1,'module_menus','create','2012-08-13 10:11:45'),(86,'banner_position',1,'module_menus','create','2012-08-13 10:11:45'),(87,'17',1,'permissions','create','2012-08-13 10:11:45'),(88,'18',1,'permissions','create','2012-08-13 10:11:45'),(89,'16',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(90,'17',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(91,'news',1,'modules','install','2012-08-13 10:11:45'),(92,'19',1,'permissions','create','2012-08-13 10:11:45'),(93,'20',1,'permissions','create','2012-08-13 10:11:45'),(94,'21',1,'permissions','create','2012-08-13 10:11:45'),(95,'22',1,'permissions','create','2012-08-13 10:11:45'),(96,'23',1,'permissions','create','2012-08-13 10:11:45'),(97,'24',1,'permissions','create','2012-08-13 10:11:45'),(98,'25',1,'permissions','create','2012-08-13 10:11:45'),(99,'26',1,'permissions','create','2012-08-13 10:11:45'),(100,'news_1',1,'module_menus','create','2012-08-13 10:11:45'),(101,'news_2',1,'module_menus','create','2012-08-13 10:11:45'),(102,'18',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(103,'19',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(104,'20',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(105,'21',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(106,'22',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(107,'23',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(108,'24',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(109,'25',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(110,'11',1,'module_menu_positions','set','2012-08-13 10:11:45'),(111,'12',1,'module_menu_positions','set','2012-08-13 10:11:45'),(112,'2',1,'site_menus','create','2012-08-13 10:11:45'),(113,'0',1,'site_menu_position_applications','create','2012-08-13 10:11:45'),(114,'event',1,'modules','install','2012-08-13 10:11:45'),(115,'27',1,'permissions','create','2012-08-13 10:11:45'),(116,'28',1,'permissions','create','2012-08-13 10:11:45'),(117,'29',1,'permissions','create','2012-08-13 10:11:45'),(118,'30',1,'permissions','create','2012-08-13 10:11:45'),(119,'event_1',1,'module_menus','create','2012-08-13 10:11:45'),(120,'26',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(121,'27',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(122,'28',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(123,'29',1,'module_menu_permissions','add','2012-08-13 10:11:45'),(124,'13',1,'module_menu_positions','set','2012-08-13 10:11:45'),(125,'3',1,'site_menus','create','2012-08-13 10:21:09'),(126,'0',1,'site_menu_position_applications','create','2012-08-13 10:21:09'),(127,'1',1,'news_categories','create','2012-08-14 03:12:42'),(128,'2',1,'news_categories','create','2012-08-14 03:12:54'),(129,'1',1,'news','create','2012-08-14 03:13:28'),(130,'1',1,'events','create','2012-08-14 03:34:14'),(131,'2',1,'news_categories','delete','2012-08-14 03:54:31'),(132,'1',1,'news_categories','delete','2012-08-14 04:39:28'),(133,'1',1,'news','delete','2012-08-14 04:40:04'),(134,'1',1,'events','delete','2012-08-14 04:41:07'),(135,'3',1,'news_categories','create','2012-08-14 04:42:33'),(136,'4',1,'news_categories','create','2012-08-14 04:42:51'),(137,'2',1,'news','create','2012-08-14 04:44:16'),(138,'3',1,'news','create','2012-08-14 04:44:58'),(139,'2',1,'events','create','2012-08-14 04:45:56'),(140,'1',1,'media_libraries','upload','2012-08-14 04:49:40'),(141,'2',1,'media_libraries','upload','2012-08-14 04:49:42'),(142,'3',1,'media_libraries','upload','2012-08-14 04:49:43'),(143,'4',1,'media_libraries','upload','2012-08-14 04:49:47'),(144,'1',1,'site_menus','update','2012-08-14 04:50:21'),(145,'1',1,'site_menus','update','2012-08-14 04:51:08'),(146,'1',1,'site_menus','update','2012-08-14 04:51:39'),(147,'4',1,'site_menus','create','2012-08-14 07:05:44'),(148,'0',1,'site_menu_position_applications','create','2012-08-14 07:05:44'),(149,'5',1,'media_libraries','upload','2012-08-15 02:09:10'),(150,'5',1,'site_menus','create','2012-08-15 02:13:42'),(151,'5',1,'site_menu_position_applications','create','2012-08-15 02:13:42'),(152,'1',1,'pages','create','2012-08-15 02:13:43'),(153,'1',1,'site_menus','update','2012-08-15 07:51:33'),(154,'1',1,'site_menus','update','2012-08-15 08:44:54'),(155,'1',1,'site_menus','update','2012-08-15 09:01:26'),(157,'1',1,'site_menus','create','2012-08-15 09:12:14'),(158,'0',1,'site_menu_position_applications','create','2012-08-15 09:12:14'),(159,'2',1,'site_menus','create','2012-08-15 09:12:14'),(160,'0',1,'site_menu_position_applications','create','2012-08-15 09:12:14'),(161,'3',1,'site_menus','create','2012-08-15 09:12:14'),(162,'0',1,'site_menu_position_applications','create','2012-08-15 09:12:14'),(163,'2',1,'site_menus','update','2012-08-15 09:13:42'),(164,'4',1,'site_menus','create','2012-08-15 10:16:01'),(165,'3',1,'site_menus','update','2012-08-15 11:28:11');

/*Table structure for table `history_descriptions` */

DROP TABLE IF EXISTS `history_descriptions`;

CREATE TABLE `history_descriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `history_id` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `history_descriptions` */

insert  into `history_descriptions`(`id`,`history_id`,`description`) values (1,'131','Aproxima Dustler delete news_categories Sport'),(2,'132','Aproxima Dustler delete news_categories Announcement'),(3,'133','Aproxima Dustler delete News For you, We Released'),(4,'134','Aproxima Dustler delete events Libur tlah tiba');

/*Table structure for table `languages` */

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` char(5) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT '0',
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `languages` */

insert  into `languages`(`id`,`label`,`is_system`,`status`,`ordering`) values ('en','English',1,'active',1),('id','Indonesian',1,'active',2);

/*Table structure for table `media_applications` */

DROP TABLE IF EXISTS `media_applications`;

CREATE TABLE `media_applications` (
  `table` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_id` int(11) NOT NULL DEFAULT '0',
  `media_library_id` int(11) NOT NULL DEFAULT '0',
  `media_position_id` int(11) DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`table`,`source_id`,`media_library_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_applications` */

insert  into `media_applications`(`table`,`source_id`,`media_library_id`,`media_position_id`,`ordering`,`title`,`permalink`) values ('site_menus',1,4,1,1,'Fraction of the Deva',''),('site_menus',1,3,1,2,'path to Golden Spirit',''),('site_menus',1,2,1,3,'Ring of Determination',''),('site_menus',2,1,1,1,'Left Brain',''),('site_menus',3,5,1,1,'','');

/*Table structure for table `media_libraries` */

DROP TABLE IF EXISTS `media_libraries`;

CREATE TABLE `media_libraries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_libraries` */

insert  into `media_libraries`(`id`,`type`,`file_name`) values (1,'image','contact-header.png'),(2,'image','exhibitor-header.png'),(3,'image','gog-800shabbyblogsbellaheader.png'),(4,'image','800-x-150-header-logo.jpg'),(5,'image','webarq.jpg');

/*Table structure for table `media_positions` */

DROP TABLE IF EXISTS `media_positions`;

CREATE TABLE `media_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` char(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `width` smallint(6) DEFAULT NULL,
  `height` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `media_positions` */

insert  into `media_positions`(`id`,`label`,`width`,`height`) values (1,'Top',800,150),(2,'Left',80,65);

/*Table structure for table `meta` */

DROP TABLE IF EXISTS `meta`;

CREATE TABLE `meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_menu_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `meta` */

/*Table structure for table `module_menu_permissions` */

DROP TABLE IF EXISTS `module_menu_permissions`;

CREATE TABLE `module_menu_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_menu_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menu_permissions` */

insert  into `module_menu_permissions`(`id`,`module_menu_id`,`permission_id`) values (1,'user_1',5),(2,'user_2',3),(3,'user_3',2),(4,'user_4',1),(5,'system_2',6),(6,'system_1',7),(7,'system_3',8),(8,'page_1',9),(9,'page_1',10),(10,'page_1',11),(11,'page_1',12),(12,'ceo',13),(13,'ceo',14),(14,'ceo',15),(15,'ceo',16),(16,'image_library',17),(17,'banner_position',18),(18,'news_1',23),(19,'news_1',24),(20,'news_1',25),(21,'news_1',26),(22,'news_2',19),(23,'news_2',20),(24,'news_2',21),(25,'news_2',22),(26,'event_1',27),(27,'event_1',28),(28,'event_1',29),(29,'event_1',30);

/*Table structure for table `module_menu_positions` */

DROP TABLE IF EXISTS `module_menu_positions`;

CREATE TABLE `module_menu_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_menu_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `position` enum('top','right','bottom','left','main') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'top',
  PRIMARY KEY (`id`,`module_menu_id`,`position`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menu_positions` */

insert  into `module_menu_positions`(`id`,`module_menu_id`,`position`) values (1,'system_1','left'),(2,'system_2','left'),(3,'system_3','left'),(4,'user_1','left'),(5,'user_2','left'),(6,'user_3','left'),(7,'user_4','left'),(8,'page_1','left'),(9,'comment','left'),(10,'ceo','left'),(11,'news_1','left'),(12,'news_2','left'),(13,'event_1','left');

/*Table structure for table `module_menus` */

DROP TABLE IF EXISTS `module_menus`;

CREATE TABLE `module_menus` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` int(11) DEFAULT '0',
  `label` char(25) COLLATE utf8_unicode_ci NOT NULL,
  `permalink` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `module_menus` */

insert  into `module_menus`(`id`,`module_id`,`parent_id`,`label`,`permalink`,`status`,`ordering`) values ('system_2','system',0,'histories','history','active',1),('system_1','system',0,'module_setting','module-setting','active',2),('system_3','system',0,'site_menu','site-menu','active',3),('user_1','user',0,'profile','profile','active',1),('user_2','user',0,'user_list','manage','active',2),('user_3','user',0,'role','role','active',3),('user_4','user',0,'permission','permission','active',4),('page_1','page',0,'page_list','manage','active',1),('comment','comment',0,'comment','manage','active',1),('ceo','ceo',0,'ceo_list','manage','active',1),('image_library','medialibrary',0,'image_library','image','active',1),('banner_position','medialibrary',0,'banner_position','banner-position','active',2),('news_1','news',0,'news_category_list','category/manage','active',1),('news_2','news',0,'news_list','manage','active',2),('event_1','event',0,'event_list','manage','active',1);

/*Table structure for table `modules` */

DROP TABLE IF EXISTS `modules`;

CREATE TABLE `modules` (
  `id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` char(25) COLLATE utf8_unicode_ci NOT NULL,
  `ordering` int(11) DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT '0',
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`label`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `modules` */

insert  into `modules`(`id`,`label`,`ordering`,`is_system`,`status`,`description`) values ('template','template',1,1,'active',NULL),('system','system',999,1,'active',NULL),('user','user',900,1,'active',NULL),('page','page',4,1,'active',NULL),('comment','comment',5,1,'active',NULL),('ceo','ceo',6,0,'active',NULL),('medialibrary','medialibrary',7,0,'active',NULL),('news','news',8,0,'active',NULL),('event','event',9,0,'active',NULL);

/*Table structure for table `news` */

DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `news_category_id` int(11) DEFAULT '0',
  `news_date` date DEFAULT NULL,
  `news_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intro` text COLLATE utf8_unicode_ci,
  `description` longtext COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `news` */

insert  into `news`(`id`,`news_category_id`,`news_date`,`news_title`,`permalink`,`intro`,`description`,`status`) values (2,3,'2012-08-01','For you, We Released','for-you-we-released','<p>\n	<span style=\"color: rgb(0, 0, 0); font-family: arial; font-size: 13px; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); display: inline !important; float: none; \">Dolor dis porttitor placerat adipiscing ac cum dignissim natoque ultricies ac ut amet sit, sed proin nisi turpis sit magna porta, dictumst auctor nunc! Est arcu nisi ultricies, parturient purus ut, tempor phasellus dis turpis aliquam? Turpis? Aliquam.</span></p>\n','<p style=\"margin: 0px 0px 10px; padding: 0px; border: 0px; outline: 0px; font-size: 13px; vertical-align: baseline; background-color: transparent; color: rgb(0, 0, 0); font-family: arial; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-position: initial initial; background-repeat: initial initial; \">\n	Magna aliquet! Auctor cum dignissim a, ac, nec aenean augue in. Augue. Mus quis massa est integer odio, dictumst magna rhoncus urna, a enim duis. Nunc etiam tristique, ultrices a nisi nec parturient, auctor. Sed duis mauris dignissim, sagittis ac tristique et est, in nisi eros porttitor risus odio nisi. Tincidunt, augue! Mid, lacus. Etiam ac in lacus? Ac magna sed sed, integer augue dignissim, in, enim. Turpis placerat dolor, cursus, quis? Facilisis tristique aliquam elit integer scelerisque vel? Integer penatibus tincidunt.</p>\n<p style=\"margin: 0px 0px 10px; padding: 0px; border: 0px; outline: 0px; font-size: 13px; vertical-align: baseline; background-color: transparent; color: rgb(0, 0, 0); font-family: arial; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-position: initial initial; background-repeat: initial initial; \">\n	Est augue augue penatibus turpis sit ac? A pid? Magnis mus? Nisi, ut nunc tincidunt nunc placerat placerat vel phasellus lectus sociis vel tortor parturient pulvinar! Ac porta lacus! Adipiscing nunc amet, ac amet velit? Sociis et pulvinar ridiculus, aliquam etiam. Sociis hac velit sit aliquet nisi aliquam rhoncus mus auctor? Massa turpis ridiculus vel, nunc? Lectus? Cum! Et. Nascetur, in, etiam porta, nec sed hac adipiscing vel, ac, scelerisque elit, magna sociis integer lacus! Quis eu ac sit aliquam ac a amet scelerisque turpis turpis tincidunt non cursus mus nisi etiam cum, magna a, dolor tincidunt pid pid! Ut ridiculus a non tincidunt! Vel, magnis, urna dolor rhoncus amet! Aenean, enim in quis elementum? Augue porta, odio sagittis.</p>\n','active'),(3,4,'2012-08-02','Speedo Spectrum','speedo-spectrum','<p>\n	<span style=\"color: rgb(0, 0, 0); font-family: arial; font-size: 13px; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); display: inline !important; float: none; \">Enim, non augue turpis et enim a, nec enim sagittis aliquam. Augue augue cum vel magna nec integer pulvinar, mid montes mus massa, et? Massa amet placerat, ultrices magnis tortor porttitor nisi integer hac dictumst dis nisi!</span></p>\n','<p style=\"margin: 0px 0px 10px; padding: 0px; border: 0px; outline: 0px; font-size: 13px; vertical-align: baseline; background-color: transparent; color: rgb(0, 0, 0); font-family: arial; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-position: initial initial; background-repeat: initial initial; \">\n	Rhoncus eros, penatibus nisi pulvinar ut in, adipiscing mattis? Aenean sed sit magna, mid elementum sed duis etiam, cras diam nunc mattis vut aenean pulvinar elementum amet tempor, nisi ut ac, porttitor est et sed facilisis lorem ultrices dolor dignissim, amet! Augue lorem enim integer odio ridiculus dictumst aenean magna, cursus integer rhoncus eros amet ridiculus et lacus non pulvinar elementum dictumst placerat sed natoque cum et turpis porta ut ac nunc? Sit, phasellus? Vut ut hac porta platea urna, mus dapibus.</p>\n<p style=\"margin: 0px 0px 10px; padding: 0px; border: 0px; outline: 0px; font-size: 13px; vertical-align: baseline; background-color: transparent; color: rgb(0, 0, 0); font-family: arial; font-style: normal; font-variant: normal; font-weight: normal; letter-spacing: normal; line-height: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; background-position: initial initial; background-repeat: initial initial; \">\n	Sed sagittis, cursus arcu ac cursus ut ut lacus non porttitor nascetur ac ultricies, cras risus aliquam velit diam, et lorem dictumst platea turpis amet enim enim turpis et, tortor, quis, facilisis, pulvinar porttitor? Scelerisque, aliquam hac elit? Dictumst augue vut, porta duis tristique egestas, a. Sed. Mattis porta elementum integer dignissim cursus aenean pellentesque! Nascetur, ultrices? Ultricies phasellus? Lorem amet quis porta facilisis turpis duis tincidunt tincidunt augue. Rhoncus pulvinar! Cum sit rhoncus tincidunt dignissim enim dis pulvinar vut elementum porta diam? Habitasse ac lectus lectus natoque habitasse, aliquet nisi, dolor tristique auctor elementum, eros lorem elit elementum elementum vel? Vut dis, pulvinar sit penatibus sit, integer mid diam egestas sagittis egestas scelerisque, sit a est lundium augue.</p>\n','active');

/*Table structure for table `news_categories` */

DROP TABLE IF EXISTS `news_categories`;

CREATE TABLE `news_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  `ordering` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `news_categories` */

insert  into `news_categories`(`id`,`label`,`permalink`,`description`,`status`,`ordering`) values (3,'Announcement','announcement','','active',1),(4,'Sport','sport','','active',2);

/*Table structure for table `pages` */

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site_menu_id` int(11) DEFAULT NULL,
  `page_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intro` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `pages` */

/*Table structure for table `permissions` */

DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `module_id` char(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`module_id`,`action`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `permissions` */

insert  into `permissions`(`id`,`module_id`,`action`,`label`,`description`) values (1,'user','manage_permission','manage_permission',NULL),(2,'user','manage_role','manage_role',NULL),(3,'user','manage_user','manage_user',NULL),(4,'user','edit','edit_profile',NULL),(5,'user','view','view_profile',NULL),(6,'system','manage_history','manage_history',NULL),(7,'system','manage_module','manage_module',NULL),(8,'system','manage_site_menu','manage_site_menu',NULL),(9,'page','create','create_new_page',NULL),(10,'page','edit','edit_page',NULL),(11,'page','delete','delete_page',NULL),(12,'page','view','view_page',NULL),(13,'ceo','add','add_new_ceo',NULL),(14,'ceo','edit','edit_ceo',NULL),(15,'ceo','delete','delete_ceo',NULL),(16,'ceo','view','view_ceo',NULL),(17,'medialibrary','manage_image_library','manage_image_library',NULL),(18,'medialibrary','manage_banner_position','manage_banner_position',NULL),(19,'news','create','create_news',NULL),(20,'news','edit','edit_news',NULL),(21,'news','delete','delete_news',NULL),(22,'news','view','view_news',NULL),(23,'news','create_category','create_news_category',NULL),(24,'news','edit_category','edit_news_category',NULL),(25,'news','delete_category','delete_news_category',NULL),(26,'news','view_category','view_news_category',NULL),(27,'event','create','create',NULL),(28,'event','edit','edit',NULL),(29,'event','delete','delete',NULL),(30,'event','view','view',NULL);

/*Table structure for table `roles` */

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `is_admin` tinyint(1) DEFAULT '0',
  `is_system` tinyint(1) DEFAULT '0',
  `label` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `roles` */

insert  into `roles`(`id`,`is_admin`,`is_system`,`label`,`status`) values (1,1,1,'Superadmin','active'),(2,1,1,'Administrator','active'),(3,1,0,'Data Entry','active');

/*Table structure for table `site_menu_position_applications` */

DROP TABLE IF EXISTS `site_menu_position_applications`;

CREATE TABLE `site_menu_position_applications` (
  `site_menu_id` int(11) NOT NULL DEFAULT '0',
  `site_menu_position_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`site_menu_id`,`site_menu_position_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menu_position_applications` */

insert  into `site_menu_position_applications`(`site_menu_id`,`site_menu_position_id`) values (1,1),(2,1),(3,1);

/*Table structure for table `site_menu_positions` */

DROP TABLE IF EXISTS `site_menu_positions`;

CREATE TABLE `site_menu_positions` (
  `id` int(11) NOT NULL DEFAULT '0',
  `label` char(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menu_positions` */

insert  into `site_menu_positions`(`id`,`label`) values (1,'Main'),(2,'Bottom');

/*Table structure for table `site_menus` */

DROP TABLE IF EXISTS `site_menus`;

CREATE TABLE `site_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` tinyint(1) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `menu_title` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8_unicode_ci DEFAULT 'active',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `site_menus` */

insert  into `site_menus`(`id`,`is_system`,`parent_id`,`menu_title`,`permalink`,`ordering`,`status`) values (1,1,0,'Home','home',1,'active'),(2,1,0,'News','news',2,'active'),(3,1,0,'Event','event',3,'active');

/*Table structure for table `tokens` */

DROP TABLE IF EXISTS `tokens`;

CREATE TABLE `tokens` (
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expired` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `tokens` */

/*Table structure for table `translations` */

DROP TABLE IF EXISTS `translations`;

CREATE TABLE `translations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source_id` char(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang_id` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `field` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`,`source_id`,`lang_id`,`table`,`field`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `translations` */

insert  into `translations`(`id`,`source_id`,`lang_id`,`table`,`field`,`value`) values (1,'1','id','site_menus','menu_title','Beranda'),(2,'1','id','site_menus','permalink','home'),(3,'5','id','site_menus','menu_title','Page Satu'),(4,'5','id','site_menus','permalink','page-satu'),(5,'1','id','pages','page_title','Page Satu'),(6,'1','id','pages','intro',''),(7,'1','id','pages','description',''),(8,'2','id','site_menus','menu_title','News'),(9,'2','id','site_menus','permalink','news'),(10,'3','id','site_menus','menu_title','Event'),(11,'3','id','site_menus','permalink','event');

/*Table structure for table `user_details` */

DROP TABLE IF EXISTS `user_details`;

CREATE TABLE `user_details` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `first_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `middle_name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` enum('male','female') COLLATE utf8_unicode_ci DEFAULT 'male',
  `address` text COLLATE utf8_unicode_ci,
  `phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_details` */

insert  into `user_details`(`user_id`,`first_name`,`last_name`,`middle_name`,`sex`,`address`,`phone`,`avatar`) values (1,'Aproxima','Dustler',NULL,'male','Nous Verse logbox',NULL,NULL),(2,'Esteban','Alejandro',NULL,'male','Nous Verse logbox',NULL,NULL),(3,'Vicento','Stamforst',NULL,'male','Nous Verse logbox',NULL,NULL);

/*Table structure for table `user_role_permissions` */

DROP TABLE IF EXISTS `user_role_permissions`;

CREATE TABLE `user_role_permissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` smallint(6) DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_role_permissions` */

insert  into `user_role_permissions`(`id`,`role_id`,`permission_id`) values (1,2,1),(2,2,2),(3,2,3),(4,2,4),(5,2,5),(6,3,4),(7,3,5),(8,2,6);

/*Table structure for table `user_sessions` */

DROP TABLE IF EXISTS `user_sessions`;

CREATE TABLE `user_sessions` (
  `user_id` int(11) DEFAULT NULL,
  `session` varchar(85) COLLATE utf8_unicode_ci DEFAULT NULL,
  `login` datetime DEFAULT NULL,
  `logout` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `user_sessions` */

insert  into `user_sessions`(`user_id`,`session`,`login`,`logout`) values (1,'cms::5ddbf56c54d131a74625aa32f537dbbbaea0a624::51cde3896f2b295f7966f19f3b3948f2','2012-08-13 22:34:51',NULL),(1,'cms::8ab02dbc940d14c4490e9e971396a806603ee8a9::46ec4e30a6c447dac71a4a2c81c6b93d','2012-08-14 23:16:05',NULL),(1,'cms::eddf6644daf7ddb0e1cbb87766df928aff4b59d8::8925b39e80ee60c951e77c50dc1041d7','2012-08-15 02:08:30',NULL),(1,'cms::112897df84deff2d0d4a8fd7d13c67bffb8f554d::8409f7b1349c65f4bb3985d1b9da1cec','2012-08-15 05:31:34',NULL),(1,'cms::aab291a5a91b62a12841bad025ea89cea98acc4b::bae2bec86cff03ee281567f37eac7c3d','2012-08-15 22:43:22',NULL);

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_system` tinyint(1) DEFAULT '0',
  `role_id` smallint(6) DEFAULT NULL,
  `username` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` char(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive','banned','pending','deleted') COLLATE utf8_unicode_ci DEFAULT 'active',
  `activation_key` char(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `users` */

insert  into `users`(`id`,`is_system`,`role_id`,`username`,`password`,`email`,`status`,`activation_key`) values (1,1,1,'superadmin','7ca09a25d5955b6459c26e1c9edf451150efa5af','su@nouspeed.com','active','1stVe'),(2,0,2,'administrator','13334ed0ae867998107301a4957b003034027685','admin@nouspeed.com','active','2ndVe'),(3,0,3,'data.entry','8f7e432c4d92b60fca0d65d120f99cdc9663c47b','entry@nouspeed.com','active','3rdVe');

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
