<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      Empty
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "events" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : true,
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "title",
                                                "class" : "title required"
                                            }
                                    }
                                
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 2
                                            }
                                    }
                            },
                        "event_date" : 
                            {
                                "type" : "datetime",
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "event_date",
                                                "class" : "datetimepicker required",
                                                "readonly" : "readonly"
                                            }
                                    }
                            },                        
                        "description" : 
                            {
                                "type" : "longtext",
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "description",
                                                "class" : "description"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "status",
                                                "class" : "status"
                                            }
                                    }
                            }
                    }
            }
        ',
    
    'alter_configuration' => 
        '
            {
                "events" :
                    {
                        "image_path" : 
                            {
                                "type" : "varchar",
                                "length" : 400,
                                "after" : "description",
                                "form" :
                                    {
                                        "event" :
                                            {
                                                "label" : "Image",
                                                "type"  : "file",
                                                "class" : "image_path",
                                                "info"  : "Best image resolution: Width = 380px, Height = 225px"
                                            }
                                    }
                            }
                    }
            }
                
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "event",
                            "label" : "event",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "event",
                            "action" : "create",
                            "label" : "create"
                        },
                        {
                            "module_id" : "event",
                            "action" : "edit",
                            "label" : "edit"
                        },
                        {
                            "module_id" : "event",
                            "action" : "delete",
                            "label" : "delete"
                        },
                        {
                            "module_id" : "event",
                            "action" : "view",
                            "label" : "view"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "event_1",
                            "module_id" : "event",
                            "parent_id" : 0,
                            "label" : "event_list",
                            "permalink" : "manage",
                            "ordering" : 1
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "event_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'event\' AND `action` = \'create\'"
                        },
                        {
                            "module_menu_id" : "event_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'event\' AND `action` = \'edit\'"
                        },
                        {
                            "module_menu_id" : "event_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'event\' AND `action` = \'delete\'"
                        },
                        {
                            "module_menu_id" : "event_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'event\' AND `action` = \'view\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "event_1",
                            "position" : "left"
                        }
                    ],
                "site_menus" :
                    [
                        {
                            "is_system" : 1,
                            "parent_id" : 0,
                            "menu_title" : "Event",
                            "permalink" : "event",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `site_menus`"     
                        }
                    ],
                "site_menu_position_applications" :
                    [
                        {
                            "site_menu_id" : "SELECT `id` FROM `site_menus` WHERE `menu_title` = \'Event\'",
                            "site_menu_position_id" : 1
                        }
                    ]
            }
        '
);