<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => '
        {
            "pages" :
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "site_menu_id" : {
                            "type" : "int",
                            "seek" : "site_menus"
                        },
                    "page_title" : {
                            "type" : "varchar",
                            "length" : 250,
                            "multilang" : false,
                            "form" : {
                                    "page" : {
                                            "name" : "page_title",
                                            "label" : "page_title",
                                            "id" : "page_title",
                                            "class" : "page_title required",
                                            "open_decoration" : "page_content"
                                        }
                                }
                            
                        },
                    "intro" : {
                            "type" : "varchar",
                            "length" : 3000,
                            "multilang" : false,
                            "form" : {
                                    "page" : {
                                            "type" : "textarea",
                                            "name" : "intro",
                                            "label" : "intro",
                                            "class" : "intro",
                                            "id" : "intro"
                                        }
                                }
                        },
                    "description" : {
                            "type" : "longtext",
                            "multilang" : false,
                            "form" : {
                                    "page" : {
                                            "name" : "description",
                                            "label" : "description",
                                            "class" : "description",
                                            "id" :  "description",
                                            "close_decoration" : "page_content"
                                        }
                                }
                        }
                }
        }
    ',  
    'mandatory' => '
        {
            "modules" : 
                [
                    {
                        "id" : "page",
                        "label" : "page",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                        "is_system" : 1
                    }
                ],
            "permissions" : 
                [
                    {
                        "module_id" : "page",
                        "action" : "create",
                        "label" : "create_new_page"
                    },
                    {
                        "module_id" : "page",
                        "action" : "edit",
                        "label" : "edit_page"
                    },
                    {
                        "module_id" : "page",
                        "action" : "delete",
                        "label" : "delete_page"
                    },
                    {
                        "module_id" : "page",
                        "action" : "view",
                        "label" : "view_page"
                    }
                ],
            "module_menus" : 
                [
                    {
                        "id" : "page_1",
                        "module_id" : "page",
                        "parent_id" : 0,
                        "label" : "page_list",
                        "permalink" : "manage",
                        "ordering" : 1
                    }
                ],
            "module_menu_permissions" : 
                [
                    {
                        "module_menu_id" : "page_1",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'page\' AND `action` = \'create\'"
                    },
                    {
                        "module_menu_id" : "page_1",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'page\' AND `action` = \'edit\'"
                    },
                    {
                        "module_menu_id" : "page_1",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'page\' AND `action` = \'delete\'"
                    },
                    {
                        "module_menu_id" : "page_1",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'page\' AND `action` = \'view\'"
                    }
                ],
            "module_menu_positions" : 
                [
                    {
                        "module_menu_id" : "page_1",
                        "position" : "left"
                    }
                ]
        }
    ',
);

?>