<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Page Listing Template
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

if (empty($columns) || !is_array($columns)) {
    echo 'No Columns' ; return;
}
?>

<div class="widget_cms">
<!--    <div class="fl"><?php // echo Form::button_new($site,'system/site-menu/form/create'); ?></div>-->
    <div class="clear"></div>
</div>

<table class="webarq_percent_table sortable" id="traversing-page-listing">
    <thead>
        <tr>
            <!--<th class="dropdown"></th>-->
            <th class="checkbox"></th>
            <th class="no"><?php echo __('no');?></th>
            <?php   
                foreach ($columns as  $key => $column) {
                    $column = $column == 'create_time' ? __('create',array('%item'=>'Time')) : $column;
                    echo '<th class="'.strtolower(helper_tool::pretty_name($column,'_')).'">'
                            .__($column).'</th>';
                }
                
            ?>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php 
            $length_of_column = count($columns)+3;
            echo !empty($tbody) 
                ? $tbody
                : '<tr><td colspan="'.$length_of_column.'">'.__('no_data').'</td></tr>';
        ?>     
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="<?php echo count($columns)+3;?>"> 
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php echo !empty($paging) ? $paging : "-"; ?>
</div>

<script>
    $('document').ready(function(){ 
        $('#traversing-page-listing').treeTable({
            //clickableNodeNames: true,
            treeColumn : 2,
            indent : 0      
        });

        /**
        $("#traversing-page-listing tbody tr").draggable({
            helper: "clone",
            opacity: .75,
            refreshPositions: true, // Performance?
            revert: "invalid",
            revertDuration: 300,
            scroll: true
        });
        
        $("#traversing-page-listing tbody tr").droppable({
            drop : function(event, ui) {                
                // Setting Draggable ui.draggable
                var drag = ui.draggable;
                var drag_node = drag.attr("id").split("-").pop();
                var drag_parent_node = drag.attr('nested_node');                
                
                // Setting Droppable using $(this)
                var drop = $(this);
                var drop_node = drop.attr("id").split("-").pop();
                var drop_parent_node = drop.attr('nested_node');
            }
        });
        $("#traversing-page-listing tbody").sortable({ 
            handle : '.sort_handler',
            axis   : 'y',
            cursor : 'hand',
            opacity: 0.4,
            receive: function (event,ui) {
                alert('receoive');    
            },
            update : function (event,ui) {
                var curr_id = sortable_get_id(ui.item);
                var next_id = sortable_get_id(ui.item.next());
                var prev_id = sortable_get_id(ui.item.prev());
                                
                var _prev = new Object();
                var _next = new Object();
                
                // Set current data
                _prev.parent = $('tr#box_'+curr_id).attr('parent');
                _prev.order  = $('tr#box_'+curr_id).attr('ordering');
                
                // By default will use previous list after change
                if (prev_id !== false){
                    _next.parent = $('tr#box_'+prev_id).attr('parent');
                    _next.order  = parseInt($('tr#box_'+prev_id).attr('ordering'));                                                 
                } else {
                    _next.parent = $('tr#box_'+next_id).attr('parent');
                    _next.order  = parseInt($('tr#box_'+next_id).attr('ordering'));
                }                
                
                $.post(
                    bs_site+'general/cheat/re-ordering',
                    {
                        'table'       : 'site_menus',
                        'prev_parent' : _prev.parent,
                        'prev_order'  : _prev.order,
                        'next_parent' : _next.parent,
                        'next_order'  : _next.order,
                        'session'     : '<?php echo $site->cookie ;?>',
                        'module'      : 'page',
                    },
                    function(response){
                        console.log(response);
                    }
                ,'json');
            } 
        });
        **/
    })
    
    
</script>