<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Role Listing View
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

?>
<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'user/role/manage/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'user/role/form/create'); ?></div>
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th><?php echo __('role_name');?></th>
            <th style="width: 100px;"><?php echo __('is_admin');?></th>
            <th><?php echo __('status');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $role) {
                    $modify_class = __make_class($index,$role->status);
                    $modify_class = $role->is_system ? 'listing_restricted' : $modify_class;
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search(__($role->label)).'</td>';
                        echo '<td class="center">';
                            echo $role->is_admin == 1
                                ? Html::image($site->themes_img.'cms/icon/check.png',array('width','16'))
                                : '';
                        echo '</td>';
                        echo '<td class="center">'.__($role->status).'</td>';
                        echo '<td class="center">';
                            if ($role->is_system == 0) {
                                $list_action  = $role->status == 'active' ? 'deactivate' : 'activate';
                                $update_value = $role->status == 'active' ? 'inactive' : 'active';
                                  
                                echo Form::list_action($site,$list_action,array(   
                                        "class"  => "ajax",
                                        "href"   => $site->bs_cms.'system/ajax/update-status/roles/'.$update_value.'/'.$role->id,
                                        "i_have" => '{
                                                "session": "'.$site->cookie.'",
                                                "message": [{
                                                            "title":"'.__('confirmation').'",
                                                            "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('role'.' '.$role->label))).'"
                                                        }]
                                            }',
                                    ));
                                echo '&nbsp; &nbsp;';
                                
                                echo Form::list_action($site,'edit',array(   
                                        'title' => __('edit_role'),
                                        'href'  => $site->bs_cms.'user/role/form/edit/'.$role->id
                                    ));
                                echo '&nbsp; &nbsp;';
                                                             
                                echo Form::list_action($site,'delete',array(   
                                        'title' => __('delete_role'),
                                        "href"   => $site->bs_cms.'user/ajax/delete-roles/'.$role->id,
                                        'class' => 'ajax',
                                        "i_have" => '{
                                                "session": "'.$site->cookie.'",
                                                "message": [{
                                                            "title":"'.__('confirmation').'",
                                                            "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('role'.' '.$role->label))).'"
                                                        }]
                                            }',
                                    ));
                                echo '&nbsp; &nbsp;';
                            }
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="6">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="5">
                <?php 
                    echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    