<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 		Daniel Simangunsong, modified by Marjuqi R.
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      ceo
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => '
        {
            "ceos" : 
                {
                    "id" : {
                            "type" : "tinyint",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "prefix" : {
                            "type" : "varchar",
                            "length" : 5,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Prefix",
                                            "name" : "prefix",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Prefix",
                                            "name" : "prefix",
                                            "class" : "required"
                                        }
                                }                            
                        },
                    "domicile" : {
                            "type" : "varchar",
                            "length" : 45,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Domicile",
                                            "name" : "domicile",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Domicile",
                                            "name" : "domicile",
                                            "class" : "required"
                                        }
                                }                            
                        },
                    "incumbency_start" : {
                            "type" : "varchar",
                            "length" : 4,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Incumbency Year Start",
                                            "name" : "incumbency_start",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Incumbency Year Start",
                                            "name" : "incumbency_start",
                                            "class" : "required"
                                        }
                                }                            
                        },
                    "incumbency_end" : {
                            "type" : "varchar",
                            "length" : 4,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Incumbency Year End",
                                            "name" : "incumbency_end",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Incumbency Year End",
                                            "name" : "incumbency_end",
                                            "class" : "required"
                                        }
                                }                            
                        },
                    "fullname" : {
                            "type" : "varchar",
                            "length" : 45,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Full Name",
                                            "name" : "fullname",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Full Name",
                                            "name" : "fullname",
                                            "class" : "required"
                                        }
                                }                            
                        },
                    "country" : {
                            "type" : "varchar",
                            "length" : 45,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Country",
                                            "name" : "country",
                                            "class" : "required"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Country",
                                            "name" : "country",
                                            "class" : "required"
                                        }
                                }
                        },
                    "photo" : {
                            "type" : "varchar",
                            "length" : 255,
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Photo",
                                            "name" : "photo",
                                            "type" : "file",
                                            "class" : "required",
											"id" : "uploadify_button"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Photo",
                                            "name" : "photo",
											"type" : "file",
                                            "class" : "required",
											"id" : "uploadify_button"
                                        }
                                }
                        },
                    "detail" : {
                            "type" : "text",
                            "form" : {
                                    "create_ceo" : {
                                            "label" : "Detail",
                                            "name" : "detail"
                                        },
                                    "edit_ceo" : {
                                            "label" : "Detail",
                                            "name" : "detail"
                                        }
                                }
                        },
                    "status" : {
                            "type" : "tinyint"
                        }
                }
        }
    ',
    'mandatory' => '
        {
            "modules" : 
                [
                    {
                        "id" : "ceo",
                        "label" : "ceo",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                        "is_system" : 0
                    }
                ],
            "permissions" : 
                [
                    {
                        "module_id" : "ceo",
                        "action" : "add",
                        "label" : "add_new_ceo"
                    },
                    {
                        "module_id" : "ceo",
                        "action" : "edit",
                        "label" : "edit_ceo"
                    },
                    {
                        "module_id" : "ceo",
                        "action" : "delete",
                        "label" : "delete_ceo"
                    },
                    {
                        "module_id" : "ceo",
                        "action" : "view",
                        "label" : "view_ceo"
                    }
                ],
            "module_menus" : 
                [
                    {
                        "id" : "ceo",
                        "module_id" : "ceo",
                        "parent_id" : 0,
                        "label" : "ceo_list",
                        "permalink" : "manage",
                        "ordering" : 1
                    }
                ],
            "module_menu_permissions" : 
                [
                    {
                        "module_menu_id" : "ceo",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'ceo\' AND `action` = \'add\'"
                    },
                    {
                        "module_menu_id" : "ceo",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'ceo\' AND `action` = \'edit\'"
                    },
                    {
                        "module_menu_id" : "ceo",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'ceo\' AND `action` = \'delete\'"
                    },
                    {
                        "module_menu_id" : "ceo",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'ceo\' AND `action` = \'view\'"
                    }
                ],
            "module_menu_positions" : 
                [
                    {
                        "module_menu_id" : "ceo",
                        "position" : "left"
                    }
                ]
        }
    ',
);

?>