<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Welcome Controller
 * @Module      ~
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
 * */
class Controller_Site_Contact_Contact extends Controller_Space_Site {

    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('contact-us');       
       $this->site->menu->active = 'contact-us';
       $this->permalink = $this->request->param('permalink');
       
       /*** Banner ***/
       $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
       $this->site->menu->title = Model::factory('contact')->get_parent_menu_title('contact-us');
       
       $current_active = Request::initial()->action();
       $category_active = (strcasecmp($current_active, 'index') == 0)?'address' : $current_active;
              
       /*** Left Content ***/
       $this->left_content = View::factory('general/left-content')
                ->set('contact_left', true)
                ->set('email_widget', true)
               ->set('category_active', $category_active);
       
       /*** email categories ***/
       $this->email_categories = Model::factory('contactcategory')->get_all_active_category();
       
       /*** office location ***/
       $this->office_location = Model::factory('contactlocation')->get_office_location();
    }
    
    public function action_index() {
        $this->action_address();
    }

    /*
     * 
     */
    public function action_address() {        
                
        $right_content = View::factory('html/site/contact/right-content')
                ->set('office_location', $this->office_location)
                ->set('email_categories', $this->email_categories)
                ->set('section', 'address');
       
        $this->set('title', 'Contact | ' . $this->site->meta->title)
             ->meta('title', 'Contact | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    /*
     * 
     */
    public function action_form() {        
                
        $right_content = View::factory('html/site/contact/right-content')
                ->set('email_categories', $this->email_categories)
                ->set('office_location', $this->office_location)
                ->set('section', 'form');
       
        $this->set('title', 'Contact | ' . $this->site->meta->title)
             ->meta('title', 'Contact | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    
    /*
     * return success send email
     */
    public function action_thankyou(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/contact/right-content')
                ->set('message', 'success')
                ->set('email_categories', $this->email_categories)
                ->set('office_location', $this->office_location);

        $this->set('title', 'Contact | ' . $this->site->meta->title)
             ->meta('title', 'Contact | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    /*
     * return error send email
     */
    public function action_failed_send_email(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/contact/right-content')
                ->set('message', 'failed')
                ->set('office_location', $this->office_location);

        $this->set('title', 'Contact | ' . $this->site->meta->title)
             ->meta('title', 'Contact | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    
}

// End Welcome
