<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class
 * @Module      Home Sliders 
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Homeslider extends Model_Base {
    
    /*
     * 
     */
    protected $_table = 'home_sliders';
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('title')->from($this->_table)->where('id = '.$id)->execute()->current();
        return empty($check->title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'home_sliders "'.$check->title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_homeslider($execution = TRUE){
        $homesliders = Setup::join_histories($this->_table)
                    ->order_by('id','desc');                     
        return $execution === true ? $homesliders->execution() : $homesliders;
    }
    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories($this->_table);
        
        if ($get_params[0] == 'field') {
            $field_name = "home_sliders.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get all active Home Slider images
     */
    public function get_slider_images($activeness = 'active'){
        $query = DB::select('media_libraries.file_name')
                ->from('media_applications')                
                ->join('media_libraries', 'left')
                ->on('media_applications.media_library_id', '=', 'media_libraries.id')
                ->where('media_applications.table', '=', 'home_sliders')
                ->as_object()
                ->execute();
              
        if ($query->valid())
        {
            $result = $query;
        }
        else
        {
            $result = null;
        }
        
        return $result;
    }
    
    /*
     * 
     */
    
    public function get_slider_home(){
        $query = "SELECT 
                `hs`.`title`, `hs`.`description`,
                `ml`.`file_name`, `mp`.`label`
                FROM `home_sliders` AS `hs`
                LEFT JOIN `media_applications` AS `ma`
                ON  (`hs`.`id` = `ma`.`source_id`)
                LEFT JOIN `media_libraries` AS `ml`
                ON (`ma`.`media_library_id` = `ml`.`id`) 
                LEFT JOIN `media_positions` AS `mp`
                ON `ma`.`media_position_id` = `mp`.`id`
                WHERE `ma`.`table` = 'home_sliders'
                AND `hs`.`status` = 'active'";
        
        $result = DB::query(Database::SELECT, $query)
                ->as_object()
                ->execute();
        
        if($result->valid()){
            $home_slider = $result;
        } else {
            $home_slider = null;
        }
        
        return $home_slider;
    }
}
