<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Module Package Installation
 * @Module      Home Slider
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "home_sliders" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 100,
                                "multilang" : false,
                                "form" :
                                    {
                                        "home_slider" :
                                            {
                                                "label" : "title",
                                                "class" : "title required"
                                            }
                                    }
                                
                            },                   
                        "description" : 
                            {
                                "type" : "text",
                                "multilang" : false,
                                "form" :
                                    {
                                        "home_slider" :
                                            {
                                                "label" : "description",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "home_slider" :
                                            {
                                                "label" : "status",
                                                "class" : "status"
                                            }
                                    }
                            }
                    }
            }
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "homeslider",
                            "label" : "homeslider",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "homeslider",
                            "action" : "create",
                            "label" : "create"
                        },
                        {
                            "module_id" : "homeslider",
                            "action" : "edit",
                            "label" : "edit"
                        },
                        {
                            "module_id" : "homeslider",
                            "action" : "delete",
                            "label" : "delete"
                        },
                        {
                            "module_id" : "homeslider",
                            "action" : "view",
                            "label" : "view"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "homeslider_1",
                            "module_id" : "homeslider",
                            "parent_id" : 0,
                            "label" : "banner",
                            "permalink" : "manage",
                            "ordering" : 1
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "homeslider_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'homeslider\' AND `action` = \'create\'"
                        },
                        {
                            "module_menu_id" : "homeslider_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'homeslider\' AND `action` = \'edit\'"
                        },
                        {
                            "module_menu_id" : "homeslider_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'homeslider\' AND `action` = \'delete\'"
                        },
                        {
                            "module_menu_id" : "homeslider_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'homeslider\' AND `action` = \'view\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "homeslider_1",
                            "position" : "left"
                        }
                    ]
            }
        '
);