<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Media Library Api
 * @Module      Media Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
 * 
 * Next development, form builder for banner insert into general form builder.
**/ 

class Kohana_MediaLibrary {
    public static function media_positions($execute=true) {
       $select = Model::factory('base')->select()
                            ->from('media_positions');
       return $execute === true ? $select->execute() : $select;
    }
    
    /**
     * media files check directory 
     * @param   mixed string or array folder name 
     */ 
    public static function check_dir($folder) {
        if (is_array($folder)){
            foreach ($folder as $new_folder){
                MediaLibrary::do_check($new_folder);    
            }
        } else {
            MediaLibrary::do_check($folder);
        }
    }  
    
    public static function do_check($folder) {
        $media_path = NULL;
        foreach (explode('/',$folder) as $dir) {
            $dir = self::folder_naming($dir);
            $media_path .= empty($media_path) ? $dir : '/'.$dir;
            if (!file_exists($media_path))
                mkdir($media_path,0755);  
        };
    }
    
    /**
     * @param   string  folder name to convert based on allowed string
     */
    public static function folder_naming($string = '') {
        return strtolower(Helper_tool::pretty_name($string,'-'));
    }
    
    // Handle media input
    public static function input_media($applicant_table,$applicant_table_id = null) {
        $html = '';
        if (Config::check_module('library') === true) {
            
            $html .= '<div class="decoration banner">'; // Block Container
            
            $html .= '<div class="fl  label-form" ';
            $html .= !empty($form->label_width) ? 'style="width:'.$form->label_width.'px;" ' : '';
            $html .= '>'.__('banner').'</div>';
            
            $html .= '<div class="fl center label-form" style="width:20px;">:</div>';
            $html .= '<div class="fl" style="margin-top:5px;">'; // Input Container
            
                /**
                 * Gathering previous banner if table media id is isset
                 */
                if (isset($applicant_table_id)) {
                    $previous_selector_media = Model::factory('base')->select('ma.*','ml.file_name')
                                                ->from(array('media_applications','ma'))
                                                ->join(array('media_libraries','ml'))
                                                ->on('ma.media_library_id = ml.id')
                                                ->where('table = '.$applicant_table)
                                                ->and_where('source_id = '.$applicant_table_id)
                                                ->and_where('ml.type = image')
                                                ->order_by('ordering','ASC')
                                                ->execute();
                }
                $html .= '<input type="hidden" name="applicant_table" value="'.$applicant_table.'"/>';
                $html .= '<input type="hidden" name="applicant_table_id" value="'.$applicant_table_id.'"/>';
                $html .= '<div id="file_server_picker"></div>';
                $html .= '<div>';
                $html .= '<ul id="banner_field">';
                    if (!empty($previous_selector_media[0])) {
                        $lib = ImageLibrary::factory();
                        foreach ($previous_selector_media as $selector) {
                            // Get Banner Position
                            $positions = Model::factory('base')
                                          ->select()
                                          ->from('media_positions')
                                          ->execute();
                            $post = Helper_Tool::arr_to_object(array(
                                    'id'  => $selector->media_library_id,
                                    'sty' => 'width:60px;',
                                    'src' => Config::$site_config->bs_root.$lib->thumb_dir.'/'.$selector->file_name,
                                ));                          
                            $html .= View::factory('html/cms/medialibrary/libraries-item',array(
                                    'positions' => $positions,
                                    'post'      => $post,
                                    'selector'  => $selector
                                ));     
                        }
                    }
                $html .= '</ul>';
                $html .= '</div>';
                
            $html .= '</div>'; // End of input container
            $html .= '<div class="clear"></div>';
            $html .= '</div>'; // End of block container
        } else {
            $html .= 'Please enable your media library module first';
        }
                 
        return $html;  
    }
    
}

?>